# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1426-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(59960);
 script_cve_id("CVE-2007-3388", "CVE-2007-4137");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 1426-1 (qt-x11-free)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to qt-x11-free
announced via advisory DSA 1426-1.

Several local/remote vulnerabilities have been discovered in the Qt GUI
Library. The Common Vulnerabilities and Exposures project identifies the
following problems:

CVE-2007-3388

Tim Brown and Dirk Mller discovered several format string
vulnerabilities in the handling of error messages, which might lead
to the execution of arbitrary code.

CVE-2007-4137

Dirk Mller discovered an off-by-one buffer overflow in the Unicode
handling, which might lead to the execution of arbitrary code.

For the old stable distribution (sarge), these problems have been fixed
in version 3:3.3.4-3sarge3. Packages for m68k will be provided later.

For the stable distribution (etch), these problems have been fixed in
version 3:3.3.7-4etch1.

For the unstable distribution (sid), these problems have been fixed in
version 3:3.3.7-8.

We recommend that you upgrade your qt-x11-free packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201426-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 1426-1 (qt-x11-free)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libqt3-i18n", ver:"3.3.4-3sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"qt3-doc", ver:"3.3.4-3sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"qt3-examples", ver:"3.3.4-3sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libqt3c102-mt-mysql", ver:"3.3.4-3sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libqt3c102-psql", ver:"3.3.4-3sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"qt3-dev-tools", ver:"3.3.4-3sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libqt3-compat-headers", ver:"3.3.4-3sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"qt3-dev-tools-compat", ver:"3.3.4-3sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"qt3-qtconfig", ver:"3.3.4-3sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libqt3-mt-dev", ver:"3.3.4-3sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libqt3c102-mysql", ver:"3.3.4-3sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libqt3c102", ver:"3.3.4-3sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libqt3c102-mt-sqlite", ver:"3.3.4-3sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libqt3c102-mt-psql", ver:"3.3.4-3sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libqt3-headers", ver:"3.3.4-3sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"qt3-designer", ver:"3.3.4-3sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libqt3c102-mt", ver:"3.3.4-3sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libqt3c102-mt-odbc", ver:"3.3.4-3sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libqt3c102-odbc", ver:"3.3.4-3sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"qt3-dev-tools-embedded", ver:"3.3.4-3sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"qt3-assistant", ver:"3.3.4-3sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"qt3-apps-dev", ver:"3.3.4-3sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"qt3-linguist", ver:"3.3.4-3sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libqt3c102-sqlite", ver:"3.3.4-3sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libqt3-dev", ver:"3.3.4-3sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libqt3c102-mt-ibase", ver:"3.3.4-3sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libqt3c102-ibase", ver:"3.3.4-3sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"qt3-examples", ver:"3.3.7-4etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"qt3-doc", ver:"3.3.7-4etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libqt3-i18n", ver:"3.3.7-4etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"qt3-dev-tools-embedded", ver:"3.3.7-4etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libqt3-mt-odbc", ver:"3.3.7-4etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libqt3-mt-dev", ver:"3.3.7-4etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"qt3-dev-tools-compat", ver:"3.3.7-4etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"qt3-linguist", ver:"3.3.7-4etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"qt3-designer", ver:"3.3.7-4etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libqt3-headers", ver:"3.3.7-4etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libqt3-mt-psql", ver:"3.3.7-4etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"qt3-qtconfig", ver:"3.3.7-4etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"qt3-assistant", ver:"3.3.7-4etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libqt3-mt-sqlite", ver:"3.3.7-4etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"qt3-apps-dev", ver:"3.3.7-4etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"qt-x11-free-dbg", ver:"3.3.7-4etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libqt3-mt-mysql", ver:"3.3.7-4etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libqt3-mt", ver:"3.3.7-4etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libqt3-compat-headers", ver:"3.3.7-4etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"qt3-dev-tools", ver:"3.3.7-4etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libqt3-mt-ibase", ver:"3.3.7-4etch1", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
