# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1379-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(58639);
 script_cve_id("CVE-2007-5135");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 1379-1 (openssl)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to openssl
announced via advisory DSA 1379-1.

An off-by-one error has been identified in the SSL_get_shared_ciphers()
routine in the libssl library from OpenSSL, an implementation of Secure
Socket Layer cryptographic libraries and utilities.  This error could
allow an attacker to crash an application making use of OpenSSL's libssl
library, or potentially execute arbitrary code in the security context
of the user running such an application.

For the stable distribution (etch), this problem has been fixed in
version 0.9.8c-4etch1.  For the old stable distribution (sarge), this
problem has been fixed in version 0.9.7e-3sarge5.  For the unstable and
testing distributions (sid and lenny, respectively), this problem has
been fixed in version 0.9.8e-9.

We recommend that you upgrade your openssl packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201379-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 1379-1 (openssl)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libssl-dev", ver:"0.9.8c-4etch1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libssl0.9.7", ver:"0.9.7e-3sarge5", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openssl", ver:"0.9.8c-4etch1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libssl0.9.8", ver:"0.9.8c-4etch1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libssl0.9.8-dbg", ver:"0.9.8c-4etch1", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
