# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1351-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(58524);
 script_cve_id("CVE-2007-2893");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 1351-1 (bochs)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to bochs
announced via advisory DSA 1351-1.

Tavis Ormandy discovered that bochs, a highly portable IA-32 PC emulator,
is vulnerable to a buffer overflow in the emulated NE2000 network device
driver, which may lead to privilege escalation.

For the oldstable distribution (sarge) this problem has been fixed in
version 2.1.1+20041109-3sarge1.

For the stable distribution (etch) this problem has been fixed in
version 2.3-2etch1.

For the unstable distribution (sid) this problem has been fixed in
version 2.3+20070705-1.

We recommend that you upgrade your bochs packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201351-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 1351-1 (bochs)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"bochs-doc", ver:"2.1.1+20041109-3sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"bochsbios", ver:"2.1.1+20041109-3sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"bochs", ver:"2.1.1+20041109-3sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"bochs-sdl", ver:"2.1.1+20041109-3sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"bochs-term", ver:"2.1.1+20041109-3sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"bochs-wx", ver:"2.1.1+20041109-3sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"bochs-x", ver:"2.1.1+20041109-3sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"bximage", ver:"2.1.1+20041109-3sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"bochs-svga", ver:"2.1.1+20041109-3sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"sb16ctrl-bochs", ver:"2.1.1+20041109-3sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"bochs-doc", ver:"2.3-2etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"bochsbios", ver:"2.3-2etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"bochs", ver:"2.3-2etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"bochs-sdl", ver:"2.3-2etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"bochs-term", ver:"2.3-2etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"bochs-wx", ver:"2.3-2etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"bochs-x", ver:"2.3-2etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"bximage", ver:"2.3-2etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"bochs-svga", ver:"2.3-2etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"sb16ctrl-bochs", ver:"2.3-2etch1", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
