# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1180-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(57384);
 script_cve_id("CVE-2006-4005", "CVE-2006-4006");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 1180-1 (bomberclone)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to bomberclone
announced via advisory DSA 1180-1.

Luigi Auriemma discovered two security related bugs in bomberclone, a
free Bomberman clone.  The Common Vulnerabilities and Exposures
project identifies the following problems:

CVE-2006-4005

The program copies remotely provided data uncheced which could
lead to a denial of service via an application crash.

CVE-2006-4006

Bomberclone uses remotely provided data as length argument which
can lead to the disclosure of private information.

For the stable distribution (sarge) these problems have been fixed in
version 0.11.5-1sarge2.

For the unstable distribution (sid) these problems have been fixed in
version 0.11.7-0.1.

We recommend that you upgrade your bomberclone package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201180-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 1180-1 (bomberclone)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2006 E-Soft Inc. http://www.securiytspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"bomberclone-data", ver:"0.11.5-1sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"bomberclone", ver:"0.11.5-1sarge2", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
