# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory RHSA-2009:0018 ()
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63111);
 script_cve_id("CVE-2008-2383");
 script_version ("$");
 name["english"] = "RedHat Security Advisory RHSA-2009:0018";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing updates announced in
advisory RHSA-2009:0018.

The xterm program is a terminal emulator for the X Window System.

A flaw was found in the xterm handling of Device Control Request Status
String (DECRQSS) escape sequences. An attacker could create a malicious
text file (or log entry, if unfiltered) that could run arbitrary commands
if read by a victim inside an xterm window. (CVE-2008-2383)

All xterm users are advised to upgrade to the updated package, which
contains a backported patch to resolve this issue. All running instances of
xterm must be restarted for the update to take effect.

Solution:
Please note that this update is available via
Red Hat Network.  To use Red Hat Network, launch the Red
Hat Update Agent with the following command: up2date

http://rhn.redhat.com/errata/RHSA-2009-0018.html
http://www.redhat.com/security/updates/classification/#important

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Redhat Security Advisory RHSA-2009:0018";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"xterm", rpm:"xterm~179~11.EL3", rls:"RHENT_3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xterm-debuginfo", rpm:"xterm-debuginfo~179~11.EL3", rls:"RHENT_3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xterm", rpm:"xterm~192~8.el4_7.2", rls:"RHENT_4")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xterm-debuginfo", rpm:"xterm-debuginfo~192~8.el4_7.2", rls:"RHENT_4")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xterm", rpm:"xterm~215~5.el5_2.2", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xterm-debuginfo", rpm:"xterm-debuginfo~215~5.el5_2.2", rls:"RHENT_5")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
