// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _OSD_Thread_HeaderFile
#define _OSD_Thread_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

#ifndef _OSD_ThreadFunction_HeaderFile
#include <OSD_ThreadFunction.hxx>
#endif
#ifndef _OSD_PThread_HeaderFile
#include <OSD_PThread.hxx>
#endif
#ifndef _Standard_ThreadId_HeaderFile
#include <Standard_ThreadId.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Address_HeaderFile
#include <Standard_Address.hxx>
#endif


//! A simple platform-intependent interface to execute <br>
//!          and control threads. <br>
class OSD_Thread  {
public:

  void* operator new(size_t,void* anAddress) 
  {
    return anAddress;
  }
  void* operator new(size_t size) 
  {
    return Standard::Allocate(size); 
  }
  void  operator delete(void *anAddress) 
  {
    if (anAddress) Standard::Free((Standard_Address&)anAddress); 
  }

  //! Empty constructor <br>
  Standard_EXPORT   OSD_Thread();
  //! Initialize the tool by the thread function <br>
  Standard_EXPORT   OSD_Thread(const OSD_ThreadFunction& func);
  //! Copy constructor <br>
  Standard_EXPORT   OSD_Thread(const OSD_Thread& other);
  //! Copy thread handle from other OSD_Thread object. <br>
  Standard_EXPORT     void Assign(const OSD_Thread& other) ;
    void operator =(const OSD_Thread& other) 
{
  Assign(other);
}
  //! Destructor. On Windows, closes handle to the thread. <br>
//!          On UNIX/Linux, does nothing. <br>
  Standard_EXPORT     void Destroy() ;
~OSD_Thread()
{
  Destroy();
}
  
  Standard_EXPORT     void SetPriority(const Standard_Integer thePriority) ;
  //! Initialize the tool by the thread function. <br>
//!          If the current thread handle is not null, nullifies it. <br>
  Standard_EXPORT     void SetFunction(const OSD_ThreadFunction& func) ;
  //! Starts a thread with thread function given in constructor, <br>
//!          passing the specified input data (as void *) to it. <br>
//!          The parameter \a WNTStackSize (on Windows only) <br>
//!          specifies size of the stack to be allocated for the thread <br>
//!          (by default - the same as for the current executable). <br>
//!          Returns True if thread started successfully <br>
  Standard_EXPORT     Standard_Boolean Run(const Standard_Address data = 0,const Standard_Integer WNTStackSize = 0) ;
  //! Detaches the execution thread from this Thread object, <br>
//!          so that it cannot be waited. <br>
//!          Note that mechanics of this operation is different on <br>
//!          UNIX/Linux (the thread is put to detached state) and Windows <br>
//!          (the handle is closed). <br>
//!          However, the purpose is the same: to instruct the system to <br>
//!          release all thread data upon its completion. <br>
  Standard_EXPORT     void Detach() ;
  
  Standard_EXPORT     Standard_Boolean Wait() const;
  //! Wait till the thread finishes execution. <br>
//!          Returns True if wait was successful, False in case of error. <br>
  Standard_EXPORT     Standard_Boolean Wait(Standard_Address& result) const;
  //! Waits for some time and if the thread is finished, <br>
//!          it returns the result. <br>
//!          The function returns false if the thread is not finished yet. <br>
  Standard_EXPORT     Standard_Boolean Wait(const Standard_Integer time,Standard_Address& result) const;
  //! Returns ID of the currently controlled thread ID, <br>
//!          or 0 if no thread is run <br>
  Standard_EXPORT     Standard_ThreadId GetId() const;
  //! Auxiliary: returns ID of the current thread <br>
  Standard_EXPORT   static  Standard_ThreadId Current() ;





protected:





private:



OSD_ThreadFunction myFunc;
OSD_PThread myThread;
Standard_ThreadId myThreadId;
Standard_Integer myPriority;


};





// other Inline functions and methods (like "C++: function call" methods)


#endif
