# -*- coding: utf-8 -*-
#
#  httpc.py - a HTTPC compatible Saori module for ninix
#  Copyright (C) 2011, 2012 by Shyouzou Sugitani <shy@users.sourceforge.jp>
#
#  This program is free software; you can redistribute it and/or modify it
#  under the terms of the GNU General Public License (version 2) as
#  published by the Free Software Foundation.  It is distributed in the
#  hope that it will be useful, but WITHOUT ANY WARRANTY; without even the
#  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
#  PURPOSE.  See the GNU General Public License for more details.
#

import httplib
import urlparse
import glib

try:
    import chardet
except:
    chardet = None

from ninix.dll import SAORI


class Saori(SAORI):

    def __init__(self):
        SAORI.__init__(self)
        self.__sakura = None
        self.__bg = {}

    def finalize(self):
        for timeout_id in self.__bg:
            glib.source_remove(timeout_id)
        return 1

    def need_ghost_backdoor(self, sakura):
        self.__sakura = sakura

    def check_import(self):
        return int(self.__sakura is not None and chardet is not None)

    def get(self, url, start=None, end=None):
        url = urlparse.urlparse(url)
        if not (url[0] == 'http' and url[3] == url[4] == url[5] == ''):
            return self.RESPONSE[400]
        conn = httplib.HTTPConnection(url[1])
        conn.request("GET", url[2])
        res = conn.getresponse()
        if res.status != 200: # XXX
            return []
        content = res.read()
        c_type = res.getheader('content-type')
        if c_type:
            for x in c_type.split(';'):
                if x.strip().startswith('charset='):
                    self.charset = x[9:]
                    break # XXX
        else:
            pass ## FIXME: check META http-equiv
        if self.charset is None:
            ## FIXME: respect explicit character encoding information
            self.charset = chardet.detect(content)['encoding']
        if self.charset is None:
            return []
        data = unicode(content, self.charset, 'ignore')
        conn.close()
        if start is not None:
            assert end is not None
            nc = 0
            ls = len(start)
            le = len(end)
            result = []
            while 1:
                ns = data.find(start, nc)
                if ns < 0:
                    break
                ns += ls
                ne = data.find(end, ns)
                if ne < 0:
                    break
                nc = ne + le
                result.append(data[ns:ne])
        else:
            result = [data]
        return result

    def execute(self, argument):
        bg = None
        self.charset = None
        process_tag = None
        if len(argument) >= 1:
            if argument[0] == 'bg':
                if len(argument) < 2:
                    # 'bgするならIDを指定していただけませんと。'
                    return self.RESPONSE[400]
                bg = argument[1]
                argument = argument[2:]
        if len(argument) >= 1:
            if argument[0] in ['sjis', 'utf-8', 'utf-16be', 'utf-16le']:
                self.charset = argument[0]
                argument = argument[1:]
            elif argument[0] =='euc':
                self.charset = 'EUC-JP'
                argument = argument[1:]
            elif argument[0] =='jis':
                self.charset = 'ISO-2022-JP '
                argument = argument[1:]
            if argument[0] == 'erase_tag':
                def erase_tag(data): ## FIXME: not supported yet
                    pass
                process_tag = erase_tag
                argument = argument[1:]
            elif argument[0] == 'translate_tag':
                def translate_tag(data): ## FIXME: not supported yet
                    pass
                process_tag = translate_tag
                argument = argument[1:]
        if not argument:
            ##assert bg is None and process_tag is None
            return 'SAORI/1.0 200 OK\r\n' \
                'Result: {0}\r\n\r\n'.format(self.loaded) # XXX
        elif len(argument) > 3:
            return self.RESPONSE[400]
        elif len(argument) == 2: # FIXME: not supported yet
            return 'SAORI/1.0 200 OK\r\n' \
                'Result: 0\r\n\r\n'
        else:
            if bg: # needs multi-threading?
                timeout_id = glib.timeout_add(1000, # XXX
                                              self.notify,
                                              bg, argument, process_tag)
                self.__bg[timeout_id] = bg
                return None # 'SAORI/1.0 204 No Content\r\n\r\n'
            else:
                data = self.get(*argument)
                if not data:
                    return None # 'SAORI/1.0 204 No Content\r\n\r\n'
                result = 'SAORI/1.0 200 OK\r\n' \
                    'Result: {0}\r\n'.format( \
                    data[0].encode('Shift_JIS', 'replace'))
                for n in range(len(data)):
                    result = ''.join((
                            result,
                            'Value{0:d}: {1}\r\n'.format(
                                n, data[n].encode('Shift_JIS', 'replace'))))
                result += '\r\n'
                return result
                         
    def notify(self, id, argument, process_tag):
        result = self.get(*argument)
        if process_tag is not None:
            pass ## FIXME
        self.__sakura.notify_event('OnHttpcNotify', id, None, *result)
