#include "process.h"
#include <qmessagebox.h>
#include <qlistview.h>
#include <qpushbutton.h>
#include <qlineedit.h>

void Process::signal_connect()
{
	connect((const QObject *)close, SIGNAL(clicked()), (const QObject *)this, SLOT(slot_close()));
	connect((const QObject *)kill, SIGNAL(clicked()), (const QObject *)this, SLOT(slot_kill()));
	connect((const QObject *)&timer, SIGNAL(timeout ()), (const QObject *)this, SLOT(slot_timeout()));
}

void Process::resizeEvent(QResizeEvent *z)
{
	process->resize(z->size().width() - 20, z->size().height() - 45 - 10);
	close->setGeometry(z->size().width() - 50 - 10, z->size().height() - 10 - 25, 50, 23);
	kill->setGeometry(z->size().width() - 50 - 50 - 20, z->size().height() - 10 - 25, 50, 23);
}

void Process::closeEvent(QCloseEvent *z)
{
	z->accept();
}
