#ifndef OPTIONS_DIALOGS_H_
#define OPTIONS_DIALOGS_H_

#include <string>

#include <wx/dialog.h>
#include <wx/panel.h>

#include "OutputterBase.h"

class wxCheckBox;
class wxSpinCtrl;
class wxButton;

namespace jcs {

class Basic3DOutputter;
class AnalyzeOutputter;
class NewBvOutputter;
class NewSpmOutputter;
class NewMetaOutputter;
class NiftiOutputterBase;

int ShowOptionsDlg(int type, OutputterBase* outputter);

int ShowOverride(int type, OutputterBase* outputter, const std::string& series_uid);

class NoOptionsDlg: public wxDialog
{
public:
	NoOptionsDlg();

	void OnOkay(wxCommandEvent& event);

protected:
    DECLARE_EVENT_TABLE()

};


class BasicOptionsDlg : public wxDialog
{
public:
	BasicOptionsDlg(const wxString& title, Basic3DOutputter* outputter);

	bool SplitDirs() const;
	int Dimensionality() const;
	int Skip() const;
	bool Rescale() const;

	std::vector<wxString> NameFields() const;

	bool Rebuild() const;

protected:
	class BasicPanel : public wxPanel
	{
	public:
		BasicPanel(wxWindow* parent);
		wxCheckBox* mpSplitDirsCheck;
		wxCheckBox* mpDimCheck;
		wxSpinCtrl* mpSkipSpin;
		wxCheckListBox* mpNameFields;
		wxCheckBox* mpRescaleCheck;

	};    

	bool SaveNameFields();

	BasicPanel* myPanel;

private:
	Basic3DOutputter* mOutputter;


};


class AnalyzeOptionsDlg : public BasicOptionsDlg
{
public:
	AnalyzeOptionsDlg(AnalyzeOutputter* outputter);

	void OnOkay(wxCommandEvent& event);
	bool NeedsRebuild() const { return mNeedsRebuild; }

protected:
    DECLARE_EVENT_TABLE()

private:
	AnalyzeOutputter* mOutputter;
	bool mNeedsRebuild;

};


class BvOptionsDlg : public wxDialog
{
public:
	BvOptionsDlg(NewBvOutputter* outputter);

	void OnOkay(wxCommandEvent& event);
	bool NeedsRebuild() const { return mNeedsRebuild; }
	bool SplitDirs() const;
	bool SaveV16() const;
	int Skip() const;

protected:
    DECLARE_EVENT_TABLE()

private:
	wxSpinCtrl* mpBvSpin;
	wxCheckBox* mpBvCheck;
	wxCheckBox* mpSplitDirsCheck;
	wxCheckListBox* mpNameFields;
	bool mNeedsRebuild;
	bool mSplit;
	bool mSaveV16;
	int mSkip;
	NewBvOutputter* mOutputter;

	bool SaveNameFields();
};


class MetaOptionsDlg : public BasicOptionsDlg
{
public:
	MetaOptionsDlg(NewMetaOutputter* outputter);

	void SetFields(std::vector<std::string> fields);
	std::vector<std::string> GetFields() const ;

	void OnOkay(wxCommandEvent& event);
	void OnClear(wxCommandEvent& event);

	bool NeedsRebuild() const { return mNeedsRebuild; }
	bool SaveHeaderOnly() const { return mpHeaderOnlyCheck->GetValue(); }

protected:
    DECLARE_EVENT_TABLE()

private:
	wxCheckBox* mpHeaderOnlyCheck;
	wxCheckListBox* mpCheckList;

	int mAddTag(const std::string tag);
	int mCheckItem(const std::string item);

	bool mNeedsRebuild;
	bool mSplit;
	int mDim;
	bool mHeaderOnly;
	int mSkip;

	NewMetaOutputter* mOutputter;

};


class SpmOptionsDlg : public BasicOptionsDlg
{
public:
	SpmOptionsDlg(NewSpmOutputter* outputter);

	void OnOkay(wxCommandEvent& event);
	bool NeedsRebuild() const { return mNeedsRebuild; }

protected:
    DECLARE_EVENT_TABLE()

private:
	bool mNeedsRebuild;
	bool mSplit;
	int mDim;
	int mSkip;
	NewSpmOutputter* mOutputter;
};


class NiftiOptionsDlg : public BasicOptionsDlg
{
public:
	NiftiOptionsDlg(NiftiOutputterBase* outputter);

	void OnOkay(wxCommandEvent& event);
	bool NeedsRebuild() const { return mNeedsRebuild; }
	bool SaveNii() const { return mpNiiCheck->GetValue(); }

protected:
    DECLARE_EVENT_TABLE()

private:
	wxCheckBox* mpNiiCheck;
	bool mNeedsRebuild;
	bool mSaveNii;
	bool mSplit;
	int mDim;
	int mSkip;

	NiftiOutputterBase* mOutputter;


};


}

#endif

class OverrideDlg : public wxDialog
{
public:
	OverrideDlg();

	wxCheckBox* dimCheck;
	wxSpinCtrl* skipSpin;

};

