/* Copyright (C) 2000-2009 Lavtech.com corp. All rights reserved.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
*/

#ifndef _UDM_SEARCH_TOOL_H
#define _UDM_SEARCH_TOOL_H

#define UDM_FAST_PRESORT_DOCS	300

/* Functions form urldata.c */
extern void UdmURLDataSortBySite(UDM_URLDATALIST *L);
extern void UdmURLDataGroupBySite(UDM_URLDATALIST *L);
extern void UdmURLDataSortByPattern(UDM_URLDATALIST *D, const char *pattern);
extern int UdmURLDataListSearch(UDM_URLDATALIST *List, urlid_t id);
extern int UdmURLDataListClearParams(UDM_URLDATALIST *List, size_t num_best_rows);
extern size_t UdmURLDataCompact(UDM_URLDATA *dst, UDM_URLDATA *src, size_t n);

/* Functions from score.c */
extern int UdmUserScoreListApplyToURLScoreList(UDM_URLSCORELIST *URLScoreList,
                                               UDM_URL_INT4_LIST *UserScoreList,
                                               int UserScoreFactor);
extern int UdmUserScoreListApplyToURLDataList(UDM_URLDATALIST *URLDataList,
                                              UDM_URL_INT4_LIST *UserScoreList,
                                              int UserScoreFactor);

extern int
UdmURLDataListApplyRelevancyFactors(UDM_AGENT *Agent,
                                    UDM_URLDATALIST *DataList,
                                    int RelevancyFactor,
                                    int DateFactor);

extern void UdmURLScoreListSortByScore(UDM_URLSCORELIST *ScoreList);
extern void UdmURLScoreListSortByScoreThenURLTop(UDM_URLSCORELIST *ScoreList,
                                                 size_t topcount);
extern void UdmURLScoreListSortByScoreThenURL(UDM_URLSCORELIST *ScoreList);

extern void UdmGroupByURL2(UDM_AGENT *Agent,
                           UDM_DB *db,
                           UDM_RESULT *Res,
                           UDM_SECTIONLIST *CoordList,
                           UDM_URLSCORELIST *ScoreList);

extern int  UdmPrepare(UDM_AGENT *query,UDM_RESULT *res);
extern __C_LINK int __UDMCALL UdmParseQueryString(UDM_AGENT * Agent,UDM_VARLIST * vars, const char * query_string);

/* Functions from wordinfo.c */
int UdmResWordInfo(UDM_ENV *Env, UDM_RESULT *Res);


/* Functions from fuzzy.c */
int UdmAllForms(UDM_AGENT *Indexer,
                UDM_WIDEWORDLIST *result,
                UDM_WIDEWORD *uword);


/* Functions from highlight.c */
extern char *UdmHlConvert(UDM_WIDEWORDLIST *L,const char * src, UDM_CHARSET * lcs, UDM_CHARSET * bcs);
extern size_t UdmHlConvertExt(UDM_AGENT *A, char *dst, size_t dstlen,
                              UDM_WIDEWORDLIST *L, UDM_CHARSET *wcs,
                              const char * src, size_t length,
                              UDM_CHARSET * lcs, UDM_CHARSET * bcs,
                              int hilight_stopwords, int segmenter);
extern size_t
UdmHlConvertExtWithConv(UDM_AGENT *A, char *dst, size_t dstmaxlen,
                        UDM_WIDEWORDLIST *List,
                        const char *src, size_t srclen,
                        UDM_CONV *uni_wcs, UDM_CONV *lc_uni, UDM_CONV *uni_bc,
                        int hilight_stopwords, int segmenter);
                                                                                               
extern int  UdmConvert(UDM_ENV *Conf, UDM_RESULT *Res,UDM_CHARSET *lcs,UDM_CHARSET *bcs);
extern char* UdmRemoveHiLightDup(const char *s);

/* Functions from segment.c */
int *UdmUniSegment(UDM_AGENT *Indexer, int *s, const char *lang, const char *seg);
int *UdmUniSegmentByType(UDM_AGENT *Indexer, int *s, int type, int ch);
int UdmUniSegmenterFind(UDM_AGENT *Indexer, const char *lang, const char *seg);

/* Functions from section.c */
void UdmSectionListPrint(UDM_SECTIONLIST *SectionList);
int UdmSectionListAlloc(UDM_SECTIONLIST *List, size_t ncoords, size_t nsections);
void UdmSectionListFree(UDM_SECTIONLIST *List);
int UdmSectionListListAdd(UDM_SECTIONLISTLIST *List, UDM_SECTIONLIST *Item);
void UdmSectionListListInit(UDM_SECTIONLISTLIST *List);
void UdmSectionListListFree(UDM_SECTIONLISTLIST *List);
int UdmSectionListListMergeSorted(UDM_SECTIONLISTLIST *SrcList,
                                  UDM_SECTIONLIST *Dst, int opt);

/* Functions from urlidlist.c */
int UdmURLIdListJoin(UDM_URLID_LIST *urls, UDM_URLID_LIST *fl_urls);
int UdmURLIdListUnion(UDM_URLID_LIST *a, UDM_URLID_LIST *b);
int UdmURLIdListCopy(UDM_URLID_LIST *a, UDM_URLID_LIST *b);
int UdmURLIdListMerge(UDM_URLID_LIST *a, UDM_URLID_LIST *b);

/* Functions from coords.c */
void
UdmURLCRDListListInit(UDM_URLCRDLISTLIST *Lst);

int
UdmURLCRDListListAdd(UDM_URLCRDLISTLIST *LstLst, UDM_URLCRDLIST *List);

void
UdmURLCRDListListFree(UDM_URLCRDLISTLIST *Lst);

void
UdmURLCRDListSortByURLThenSecnoThenPos(UDM_URLCRDLIST *L);

void
UdmURLCRDListMergeMultiWord(UDM_URLCRDLIST *Phrase, size_t wordnum, size_t nparts);

#endif
