/*************************************************************************
* COPYRIGHT (C) 1999 - 2007  EDF R&D, CEA/DEN
* THIS LIBRARY IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
* IT UNDER THE TERMS OF THE GNU LESSER GENERAL PUBLIC LICENSE 
* AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
* EITHER VERSION 2.1 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
*  
* THIS LIBRARY IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
* WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
* MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
* LESSER GENERAL PUBLIC LICENSE FOR MORE DETAILS.
*
* YOU SHOULD HAVE RECEIVED A COPY OF THE GNU LESSER GENERAL PUBLIC LICENSE
* ALONG WITH THIS LIBRARY; IF NOT, WRITE TO THE FREE SOFTWARE FOUNDATION,
* INC., 59 TEMPLE PLACE, SUITE 330, BOSTON, MA 02111-1307 USA
*
*************************************************************************/

#include <stdlib.h>
#include <med.h>
#include <med_outils.h>

/*
 * - Nom de la fonction _MEDcstring
 * - Description : convertit une chaine de caracteres C en 
 *                 nouvelle chaine de caracteres sans blancs terminaux
 *                 Cette opration est ralise  partir du buffer source
 *                 dans le buffer destination dj allou de taille suppose
 *                 suffisante.
 * - Parametres :
 *     - source (IN)          : la chaine C
 *     - dest (OUT)           : la chaine C
 * - Resultat : la nouvelle chaine C en cas de succes, NULL sinon
 */
med_err _MEDcstring(char *source, char *dest)
{
  char *temoin;
  int longueur_source,long_reelle;
  int i;

  longueur_source = strlen(source);
  long_reelle     = longueur_source;

  if ( longueur_source <= 0 ) return -1;

  temoin = source+longueur_source-1;
  while (*temoin == ' ' && (temoin > source) )
    {
      temoin --;
      long_reelle--;
    }
  if ( *temoin == ' ') long_reelle = 0;
  ISCRUTE(long_reelle);

  for (i=0;i<long_reelle+1;i++)
    *(dest+i) = *(source+i);
  *(dest+long_reelle) = '\0';
  
  return 0;
}
