/*************************************************************************
* COPYRIGHT (C) 1999 - 2007  EDF R&D, CEA/DEN
* THIS LIBRARY IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
* IT UNDER THE TERMS OF THE GNU LESSER GENERAL PUBLIC LICENSE 
* AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
* EITHER VERSION 2.1 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
*  
* THIS LIBRARY IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
* WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
* MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
* LESSER GENERAL PUBLIC LICENSE FOR MORE DETAILS.
*
* YOU SHOULD HAVE RECEIVED A COPY OF THE GNU LESSER GENERAL PUBLIC LICENSE
* ALONG WITH THIS LIBRARY; IF NOT, WRITE TO THE FREE SOFTWARE FOUNDATION,
* INC., 59 TEMPLE PLACE, SUITE 330, BOSTON, MA 02111-1307 USA
*
*************************************************************************/

#include <med.h>
#include <med_config.h>
#include <med_outils.h>

#include <string.h>
#include <stdlib.h>

med_err
MEDpolyedreInfo(med_idt fid, char *maa,med_connectivite type_conn,med_int *nf,
		med_int *consize)
{
  med_idt root, maaid, entid,geoid, dataset=0;
  med_err ret = 0;
  char chemin[MED_TAILLE_MAA+MED_TAILLE_NOM+1];
  char nom_ent[MED_TAILLE_NOM_ENTITE+1];
  char nom_geo[MED_TAILLE_NOM_ENTITE+1];
  char nom_dataset[MED_TAILLE_NOM_ENTITE+1];
  med_int res = 0;
  med_entite_maillage type_ent;
  med_geometrie_element type_geo;

  /*
   * On inhibe le gestionnaire d'erreur HDF 5
   */
  _MEDmodeErreurVerrouiller();

  /*
   * Si le maillage n'existe pas => erreur
   */
  strcpy(chemin,MED_MAA);
  strcat(chemin,maa);
  if ((maaid = _MEDdatagroupOuvrir(fid,chemin)) < 0)
    return -1;

  /*
   * Acces au groupe HDF des entites (MED_MAILLE)
   */
  type_ent = MED_MAILLE;
  if ((ret = _MEDnomEntite(nom_ent,type_ent)) < 0)
    return -1;
  if ((entid = _MEDdatagroupOuvrir(maaid,nom_ent)) < 0)
    return -1;

  /*
   * Acces au groupe HDF du type geometrique MED_POLYEDRE
   */
  type_geo = MED_POLYEDRE;
  if ((ret = _MEDnomGeometrie(nom_geo,type_geo)) < 0)
    return -1;
  if ((geoid = _MEDdatagroupOuvrir(entid,nom_geo)) < 0)
    return -1;
  
   /*
    * Ouverture du dataset HDF correspondant au mode de connectivite 
    * S'il n'existe pas => erreur
    * Sinon lecture de l'attribut HDF "TAI" qui designe la taille
    * du tableau des connectivites et de l'attribut "TTI" qui
    * designe la taille du tableau "indexf"
    */ 
   switch(type_conn)
     {
     case MED_NOD :
       strcpy(nom_dataset,MED_NOM_NOD);
       break;

     case MED_DESC :
       strcpy(nom_dataset,MED_NOM_DES);
       break;
       
     default :
       return -1;
     }

   if ((dataset = _MEDdatasetOuvrir(geoid,nom_dataset)) < 0)
     return -1;
   if ((ret = _MEDattrEntierLire(dataset,MED_NOM_TAI,consize)) < 0)
     return -1;
   if ((ret = _MEDdatasetFermer(dataset)) < 0)
     return -1;

   if ((dataset = _MEDdatasetOuvrir(geoid,nom_dataset)) < 0)
     return -1;
   if ((ret = _MEDattrEntierLire(dataset,MED_NOM_TTI,nf)) < 0)
     return -1;
   if ((ret = _MEDdatasetFermer(dataset)) < 0)
     return -1;

   /*
    * On ferme tout
    */
   if (geoid > 0)
     if ((ret = _MEDdatagroupFermer(geoid)) < 0)
       return -1;
   if (entid > 0)
     if ((ret = _MEDdatagroupFermer(entid)) < 0)
       return -1;
   if ((ret = _MEDdatagroupFermer(maaid)) < 0)
     return -1; 

  return ret;
}
