/******************************** LICENSE ********************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 ******************************** LICENSE ********************************/

/*!
    \file OpenGLFboItem.h
    \brief Definition of OpenGLFboItem.
    \author Graphics Section, ECMWF

    Started: May 2004
*/


#ifndef _OpenGLCore_H
#define _OpenGLCore_H

#define GL_GLEXT_PROTOTYPES

#include <GL/gl.h>

namespace magics 
{

class OpenGLFboItem;
class OpenGLTextureItem;


class OpenGLCore
{
public:		
	enum RenderMode {InvalidMode, FboMode, BackBufferMode};

	OpenGLCore();
	~OpenGLCore();

	static OpenGLCore* instance();

	void init(int,int);
	void initMag();
	void buildFb();
	void bgToFb();
	void bgToFb(int,int,int,int);
	void fbToBg();

	int width()  {return width_;};
	int height() {return height_;};

	OpenGLFboItem*  fboBg() {return fboBg_;}
	OpenGLFboItem*  fboFb() {return fboFb_;}
	OpenGLFboItem*  fboMag() {return fboMag_;}
	
	OpenGLTextureItem*  texBg() {return texBg_;}
	OpenGLTextureItem*  texFb() {return texFb_;}
	OpenGLTextureItem*  texMag() {return texMag_;}

	OpenGLCore::RenderMode renderMode() {return renderMode_;}	
	
protected:
	static OpenGLCore* instance_;

	OpenGLFboItem* 	fboBg_;
	OpenGLFboItem* 	fboFb_;	
	OpenGLFboItem* 	fboMag_;

	OpenGLTextureItem*  texBg_;
	OpenGLTextureItem*  texFb_;
	OpenGLTextureItem*  texMag_;
	
	int width_;
	int height_;
	RenderMode renderMode_;	

};


}

#endif
