/******************************** LICENSE ********************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 ******************************** LICENSE ********************************/

/*! \file OpenGLCallback.h
    \brief Definition of the OpenGLCallback.
    \author Graphics Section, ECMWF
    
    Started: July 2008    
*/

#ifndef OpenGLCallback_H
#define OpenGLCallback_H

#include <magics.h>

namespace OpenGLWidget
{
	enum CallbackType {ActivateCallback,ValueChangedCallback,FocusChangedCallback,TimeoutCallback};
};


namespace magics 
{

typedef void(*pt2f)(void*,void*);

class OpenGLCallback
{
public:			
	OpenGLCallback(pt2f f,void *obj,OpenGLWidget::CallbackType type) 
	{
		set(f,obj,type);
	}
		
	void set(pt2f f,void *obj,OpenGLWidget::CallbackType type)
	{
		function_=f;
		object_=obj;
		type_=type;
	}	
	
	void execute(void* data) 
	{
		function_(object_,data);
	}
	
	OpenGLWidget::CallbackType type() {return type_;};			

protected:
	OpenGLWidget::CallbackType type_;
	pt2f function_;
	void* object_;
};

}

#endif
