/******************************** LICENSE ********************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 ******************************** LICENSE ********************************/

/*!
    \file OpenGLBaseRenderObject.cc
    \brief Definition of a Tree template class.
    \author Graphics Section, ECMWF

    Started: November 2008
*/

#include <iostream>
#include <vector>
#include <map>

#include <OpenGLBaseRenderObject.h>

using namespace std;
using namespace magics;


OpenGLBaseRenderObject::OpenGLBaseRenderObject(string name) : name_(name)
{
	//pickObject_=0;	
}

OpenGLBaseRenderObject::~OpenGLBaseRenderObject()
{	
	//delete pickObject_;				
}

void OpenGLBaseRenderObject::window(float x, float y, float w, float h)
{
	win_.set(x, y,w,h);
}

bool OpenGLBaseRenderObject::checkPointInWindow(float x,float y)
{	
	return win_.checkPointInBox(x,y);
}

OpenGLDplItem* OpenGLBaseRenderObject::addDpl(mglDplType type)
{
	return dpl_.add(type);
}	

OpenGLDplItem* OpenGLBaseRenderObject::addPreTransformDpl()
{
	return preTransformDpl_.add();
}	

OpenGLDplItem* OpenGLBaseRenderObject::addPostTransformDpl()
{
	return postTransformDpl_.add();
}	
