/*
*   pam_abl - a PAM module and program for automatic blacklisting of hosts and users
*
*   Copyright (C) 2005 Andy Armstrong andy@hexten.net
*   Copyright (C) 2009 Chris Tasma pam-abl@deksai.com
*
*   This program is free software: you can redistribute it and/or modify
*   it under the terms of the GNU General Public License as published by
*   the Free Software Foundation, either version 2 of the License, or
*   (at your option) any later version.
*
*   This program is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU General Public License for more details.
*
*   You should have received a copy of the GNU General Public License
*   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "pam_abl.h"

void log_out(int pri, const char *format, ...) {
    va_list ap;

    va_start(ap, format);
#if defined(TEST) || defined(TOOLS)
    vfprintf(stderr, format, ap);
    fprintf(stderr, "\n");
#else
    openlog(MODULE_NAME, LOG_CONS | LOG_PID, LOG_AUTHPRIV);
    vsyslog(pri, format, ap);
    closelog();
#endif
    va_end(ap);
}

#if !defined(TOOLS)
void log_pam_error(const abl_args *args, int err, const char *what) {
    log_out(LOG_ERR, "%s (%d) while %s", pam_strerror(args->pamh, err), err, what);
}
#endif

void log_sys_error(int err, const char *what) {
    log_out(LOG_ERR, "%s (%d) while %s", strerror(err), err, what);
}

void log_db_error(int err, const char *what) {
    log_out(LOG_ERR, "%s (%d) while %s", db_strerror(err), err, what);
}

void log_info(const char *format, ...) {
    va_list ap;

    va_start(ap, format);
#if defined(TEST) || defined(TOOLS)
    fprintf(stderr, "INFO: ");
    vfprintf(stderr, format, ap);
    fprintf(stderr, "\n");
#else
    openlog(MODULE_NAME, LOG_CONS | LOG_PID, LOG_AUTHPRIV);
    vsyslog(LOG_INFO, format, ap);
    closelog();
#endif
    va_end(ap);
}

void log_warning(const abl_args *args, const char *format, ...) {
    va_list ap;

    va_start(ap, format);
    if (!args->no_warn) {
#if defined(TEST) || defined(TOOLS)
        fprintf(stderr, "WARNING: ");
        vfprintf(stderr, format, ap);
        fprintf(stderr, "\n");
#else
        openlog(MODULE_NAME, LOG_CONS | LOG_PID, LOG_AUTHPRIV);
        vsyslog(LOG_WARNING, format, ap);
        closelog();
#endif
    }
    va_end(ap);
}

void log_debug(const abl_args *args, const char *format, ...) {
    va_list ap;
    va_start(ap, format);
    if (NULL == args || args->debug) {
#if defined(TEST) || defined(TOOLS)
        fprintf(stderr, "DEBUG: ");
        vfprintf(stderr, format, ap);
        fprintf(stderr, "\n");
#else
        openlog(MODULE_NAME, LOG_CONS | LOG_PID, LOG_AUTHPRIV);
        vsyslog(LOG_DEBUG, format, ap);
        closelog();
#endif
    }
    va_end(ap);
}

