/***************************************************************************
                          sendmessage.h  -  description
                             -------------------
    begin                : Wed Jan 31 2001
    copyright            : (C) 2001 by Frank Schwanz
    email                : schwanz@fh-brandenburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SENDMESSAGE_H
#define SENDMESSAGE_H

#include <qobject.h>
#include <qstring.h>
#include <kprocess.h>

/**send a Message via smbclient to a netbiosname
  *@author Frank Schwanz
  */

class SendMessage:public QObject
{
Q_OBJECT private:
  KProcess * proc;		// The Process
  QString out;
  QString err;
  QString netname;
  QString message;
public:
    SendMessage (QObject * parent, const QString & the_netname,
		 const QString & the_message);
   ~SendMessage ();
  void start ();
  public slots:			// Public slots
  /** Liest den Output ein */
  void slotStdout (KProcess * p, char *buffer, int n);
  /** Liest den Output ein */
  void slotStderr (KProcess * p, char *buffer, int n);
  void slotWritten (KProcess *);
  /** Wird aufgerufen wenn der Process sich beendet */
  void onProcExit (KProcess * killedproc);
    signals:void isExited (SendMessage * sm, QString errors);
};

#endif
