/***************************************************************************
                           controlinterface.cpp
                           --------------------
    begin                : Sun Nov 21 2004
    copyright            : (C) 2004 by Dirk Ziegelmeier
    email                : dziegel@gmx.de
 ***************************************************************************/

/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include <kdebug.h>
#include "controlinterface.h"
#include "controlinterface.moc"

Control::Control(const QString& _uiName, const QString& _internalName, ControlType _type)
    : QObject(),
      uiName(_uiName),
      internalName(_internalName),
      advanced(false),
      controlType(_type)
{
}

Control::~Control()
{
}

IntegerControl::IntegerControl(const QString& uiName, const QString& internalName)
    : Control(uiName, internalName, Control_Int)
{
}

IntegerControl::~IntegerControl()
{
}

bool IntegerControl::setValue(int value)
{
    static bool inhibitRecursion = false;

    if(!inhibitRecursion) {
        inhibitRecursion = true;
        bool rc = doSetValue(value);
        if(rc) {
            emit changed(value);
        }
        inhibitRecursion = false;
        return rc;
    }

    return false;
}

BooleanControl::BooleanControl(const QString& uiName, const QString& internalName)
    : Control(uiName, internalName, Control_Bool)
{
}

BooleanControl::~BooleanControl()
{
}

bool BooleanControl::setValue(bool value)
{
    static bool inhibitRecursion = false;

    if(!inhibitRecursion) {
        inhibitRecursion = true;
        bool rc = doSetValue(value);
        if(rc) {
            emit changed(value);
        }
        inhibitRecursion = false;
        return rc;
    }

    return false;
}

MenuControl::MenuControl(const QString& uiName, const QString& internalName)
    : Control(uiName, internalName, Control_Menu)
{
}

MenuControl::~MenuControl()
{
}

bool MenuControl::setValue(const QString& value)
{
    static bool inhibitRecursion = false;

    if(!inhibitRecursion) {
        inhibitRecursion = true;
        bool rc = doSetValue(value);
        if(rc) {
            emit changed(value);
        }
        inhibitRecursion = false;
        return rc;
    }

    return false;
}

ButtonControl::ButtonControl(const QString& uiName, const QString& internalName)
    : Control(uiName, internalName, Control_Button)
{
}

ButtonControl::~ButtonControl()
{
}
