/***************************************************************************
                           tomsmocomp.cpp
                           --------------
    begin                : Sat Jul 10 2004
    copyright            : (C) 2004 by Dirk Ziegelmeier
    email                : dziegel@gmx.de
***************************************************************************/

/*
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 */

#include <qspinbox.h>
#include <qcheckbox.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qpushbutton.h>

#include <kdebug.h>
#include <klocale.h>
#include <kconfig.h>

#include "tomsmocomp.h"
#include "dscalerfiltertomsmocomp.h"

TomsMoCompPlugin::TomsMoCompPlugin(Kdetv *ktv, const QString& cfgkey, QObject *parent, const char* name)
    : KdetvFilterPlugin(ktv, cfgkey, parent, name)
{
    DScalerFilterTomsMoComp* f = new DScalerFilterTomsMoComp();
    _filter = f;

    f->SearchEffort  = _cfg->readNumEntry("SearchEffort", SEARCHEFFORT_DEFAULT);
    f->UseStrangeBob = _cfg->readBoolEntry("Use StrangeBob", USESTRANGEBOB_DEFAULT);
}

TomsMoCompPlugin::~TomsMoCompPlugin()
{
    delete _filter;
}

QWidget* TomsMoCompPlugin::configWidget(QWidget* parent, const char* name)
{
    DScalerFilterTomsMoComp* f = static_cast<DScalerFilterTomsMoComp*>(_filter);

    QFrame *w = new QFrame(parent, name);
    w->setMargin(4);
    QGridLayout *g = new QGridLayout(w, 3, 2);

    g->addWidget(new QLabel(i18n("Search effort:"), w), 0, 0);
    _spSearchEffort = new QSpinBox(0, 25, 1, w, "SearchEffortSpin");
    _spSearchEffort->setValue(f->SearchEffort);
    g->addWidget(_spSearchEffort, 0, 1);

    _cbStrangeBob = new QCheckBox(i18n("Use strange bob"), w, "StrangeBobCB");
    _cbStrangeBob->setChecked(f->UseStrangeBob);
    g->addWidget(_cbStrangeBob, 1, 0);

    QButton* b = new QPushButton(i18n("Defaults"), w, "Defaults");
    connect(b, SIGNAL( clicked() ),
            this, SLOT( defaults() ));
    g->addWidget(b, 2, 1);

    return w;
}

void TomsMoCompPlugin::defaults()
{
    DScalerFilterTomsMoComp* f = static_cast<DScalerFilterTomsMoComp*>(_filter);

    f->SearchEffort  = SEARCHEFFORT_DEFAULT;
    f->UseStrangeBob = USESTRANGEBOB_DEFAULT;

    _spSearchEffort->setValue(f->SearchEffort);
    _cbStrangeBob->setChecked(f->UseStrangeBob);
}

void TomsMoCompPlugin::saveConfig()
{
    DScalerFilterTomsMoComp* f = static_cast<DScalerFilterTomsMoComp*>(_filter);

    f->SearchEffort  = _spSearchEffort->value();
    f->UseStrangeBob = _cbStrangeBob->isChecked();

    _cfg->writeEntry("SearchEffort",   f->SearchEffort);
    _cfg->writeEntry("Use StrangeBob", f->UseStrangeBob);
    _cfg->sync();
}

extern "C" {
    TomsMoCompPlugin* create_tomsmocomp(Kdetv* ktv)
    {
        return new TomsMoCompPlugin(ktv, "deinterlace-tomsmocomp", 0, "TomsMoComp deinterlacefilter");
    }
}

#include "tomsmocomp.moc"
