// -*- c++ -*-

/*
 * Copyright (C) 2004 Dirk Ziegelmeier <dziegel@gmx.de>
 *
 *   This program is free software; you can redistribute it and/or modify 
 *   it under the terms of the GNU General Public License as published by 
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 */

#ifndef SCREENSAVER_H
#define SCREENSAVER_H

#include <kscreensaver.h>
#include <settingsdialogpage.h>

#include "saverconfigwidget.h"

class Kdetv;
class KdetvWidget;

class KdetvSaver : public KScreenSaver
{
    Q_OBJECT

public:
    KdetvSaver( WId drawable );
    virtual ~KdetvSaver();

protected slots:
    void applySettings();

protected:
    KdetvWidget* _screen;
};

//----------------------------------------------

class SaverConfigWidgetImpl : public SaverConfigWidget, public SettingsDialogPage
{
    Q_OBJECT
	
public: 
    SaverConfigWidgetImpl(QWidget*, KConfig*, Kdetv*);
    ~SaverConfigWidgetImpl();


public slots:
    virtual void setup();
    virtual void apply();
    virtual void defaults();

    
private:
    KConfig*  _h;
    Kdetv* _ktv;
};

//----------------------------------------------

class KdetvSaverSetup : public QObject,
			   public SettingsDialogPageFactory
{
    Q_OBJECT

public:
    KdetvSaverSetup( QObject *parent, const char *name );
    virtual ~KdetvSaverSetup();

    QPtrList<SettingsDialogPage>* getPages();

    KDialogBase* _dlg;
    KdetvWidget* _screen;
};

#endif // SCREENSAVER_H
