/*
 *  Copyright (C) 2010 Tuomo Penttinen, all rights reserved.
 *
 *  Author: Tuomo Penttinen <tp@herqq.org>
 *
 *  This file is part of an application named HUpnpSimpleTestApp
 *  used for demonstrating how to use the Herqq UPnP (HUPnP) library.
 *
 *  HUpnpSimpleTestApp is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  HUpnpSimpleTestApp is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with HUpnpSimpleTestApp. If not, see <http://www.gnu.org/licenses/>.
 */

#include "allowedvaluelist_input.h"
#include "ui_allowedvaluelist_input.h"

AllowedValueListInput::AllowedValueListInput(
    const QStringList& values, QWidget* parent) :
        IDataHolder(parent),
            m_ui(new Ui::AllowedValueListInput)
{
    m_ui->setupUi(this);
    m_ui->argumentValuescomboBox->addItems(values);
}

AllowedValueListInput::~AllowedValueListInput()
{
    delete m_ui;
}

void AllowedValueListInput::changeEvent(QEvent* e)
{
    QWidget::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        m_ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

QVariant AllowedValueListInput::data() const
{
    return m_ui->argumentValuescomboBox->currentText();
}
