///////
   //    _Url.h
   //    _Url Class declaration
   //
   //    Class to interface with Url table of mysql Database
   //    This inherits from the Url class.
   //
   //    Copyright (c) 1999-2004 Comune di Prato - Prato - Italy
   //    Some Portions Copyright (c) 1995-2000 The ht://Dig Group <www.htdig.org>
   //    Some Portions Copyright (c) 2008 Devise.IT srl <http://www.devise.it/>
   //    Author: Gabriele Bartolini - Prato - Italy <angusgb@users.sourceforge.net>
   //
   //    For copyright details, see the file COPYING in your distribution
   //    or the GNU General Public License version 2 or later 
   //    <http://www.gnu.org/copyleft/gpl.html>
   //
   //    $Id: _Url.h,v 1.25 2008-11-16 18:28:52 angusgb Exp $
   //
   //    G.Bartolini
   //    started: 05.07.1999
///////

#ifndef __URL_H
#define __URL_H

#include <string>
#include "_Server.h"
#include "URL.h"
#include "HtDateTime.h"

class _Url : public URL
{
   public:
   
      // Construction / Destruction
      _Url();
      _Url(const std::string &url);
      _Url(const _Url &url);
      _Url(const std::string &ref, _Url &parent);
      virtual ~_Url();

      enum Url_ConnStatus
      {
         Url_OK,
         Url_NoHeader,
         Url_NoHost,
         Url_NoPort,
         Url_NoConnection,
         Url_ConnectionDown,
         Url_ServiceNotValid,
         Url_ServerError,
         Url_OtherError
      };

      enum Url_DocType
      {
            Url_Undefined,
            Url_Not_Public,
            Url_Not_Html,
            Url_XHtml_11_Strict,
            Url_XHtml_10_Strict,
            Url_XHtml_10_Transitional,
            Url_XHtml_10_Frameset,
            Url_Html_401_Strict,
            Url_Html_401_Transitional,
            Url_Html_401_Frameset,
            Url_Html_40_Strict,
            Url_Html_40_Transitional,
            Url_Html_40_Frameset,
			Url_Html_ISO_IEC_15445_2000,
			Url_Html_32,
			Url_Html_20,
			Url_Html_20_Level2,
			Url_Html_20_Level1,
			Url_Html_20_Strict,
			Url_Html_20_Strict_Level1,
            Url_Unknown
      };

      enum Url_DocTypeVersion
      {
            Url_Doctype_Undefined,
            Url_Doctype_Strict,
            Url_Doctype_Transitional,
            Url_Doctype_Frameset
      };

///////
   //    Public Interface
///////

      void Reset();
      
///////
   //    Interface with protected methods
///////

      void SetID (unsigned int ID) { IDUrl = ID; }
      void SetIDServer (unsigned int ID) { IDServer = ID; }
      void SetHTTPContentType (const std::string &Ct);
      void SetContentType (const char* Ct);
      void SetTransferEncoding (const std::string &Te) { TransferEncoding = Te; }
      void SetLastModified (HtDateTime *d);
      void SetLastAccess (HtDateTime *d) { LastAccess = d; }
      void SetSize (long s) { Size = s; }
      void SetStatusCode (unsigned int sc) { StatusCode = sc; }
      void SetReasonPhrase (const std::string &rp) { ReasonPhrase = rp; }
      void SetLocation (const std::string &l) { Location = l; }
      void SetContentLanguage (const std::string &cl) { ContentLanguage = cl; }
      void SetServer (_Server *s) { pServer = s; }
      void SetConnStatus (Url_ConnStatus s) { ConnStatus = s; }

      void RetrieveConnStatus (std::string &) const; // Insert into a string the value
                                          // for the ConnStatus
                                          // (converts a Url_ConnStatus
                                          // value into a std::string).

                                       
      void RetrieveDocType (std::string &) const; // Insert into a string the value
                                          // for the DocType
                                          // (converts a Url_DocType
                                          // value into a std::string).

                                       
      int SetConnStatus (const std::string &Status);   // Set the Url_ConnStatus value
                                          // depending on the Status value
      
      int SetDocType (const std::string &DocType);   // Set the Url_DocType value
                                          // depending on the DocType value
      

      // Info regarding the web page
      void SetTitle (const std::string &t) { Title = t; }
      void SetContents (const char* const c);
      void ReleaseContents();
      void SetCharset (const std::string &c) { Charset = c; }
      void SetDocType (Url_DocType d) { DocType = d; }
      void SetDescription (const std::string &d) { Description = d; }
      void SetKeywords (const std::string &k) { Keywords = k; }
#ifdef HTDIG_NOTIFICATION
      void SetHtDigEmail (const std::string &k) { HtDigEmail = k; }
      void SetHtDigEmailSubject (const std::string &k) { HtDigEmailSubject = k; }
      void SetHtDigNotificationDate (const std::string &k) { HtDigNotificationDate = k; }
#endif
      
      unsigned int GetID () const { return IDUrl; }
      unsigned int GetIDServer () const { return IDServer; }
      const std::string &GetHTTPContentType () const { return HTTPContentType; }
      const std::string &GetHTTPCharset () const { return HTTPCharset; }
      const std::string &GetContentType () const { return ContentType; }
      const std::string &GetTransferEncoding () const { return TransferEncoding; }
      const HtDateTime *GetLastModified () const;
      const HtDateTime *GetLastAccess () const { return LastAccess; }
      long GetSize() const { return Size; }
      unsigned int GetStatusCode() const { return StatusCode; }
      const std::string &GetReasonPhrase() const { return ReasonPhrase; }
      const std::string &GetLocation() const { return Location; }
      const std::string &GetContentLanguage() const { return ContentLanguage; }
      const _Server *GetServer() const { return pServer; }
      const std::string &GetTitle() const { return Title; }
      const std::string* const GetContents() const { return Contents; }
      const std::string &GetCharset() const { return Charset; }
      Url_DocType GetDocType() const { return DocType; }
      Url_ConnStatus GetConnStatus() const { return ConnStatus; }
      void HideLastModified() { _HideLastModified = true; }
      const std::string &GetDescription() const { return Description; }
      const std::string &GetKeywords() const { return Keywords; }
      const bool isDocTypeStrict() const { return DocTypeVersion == Url_Doctype_Strict; }
      const bool isDocTypeTransitional() const { return DocTypeVersion == Url_Doctype_Transitional; }
      const bool isDocTypeFrameset() const { return DocTypeVersion == Url_Doctype_Frameset; }
      const bool isDocTypeObsolete() const { return DocTypeObsolete; }
      const bool isDocTypeValid() const { return DocType != Url_Undefined &&
      	DocType != Url_Unknown; }
      	
#ifdef HTDIG_NOTIFICATION
      const std::string &GetHtDigEmail() const { return HtDigEmail; }
      const std::string &GetHtDigEmailSubject() const { return HtDigEmailSubject; }
      const std::string &GetHtDigHtDigNotificationDate()
          const { return HtDigNotificationDate; }
#endif



///////
   //    Static Methods
///////

      static unsigned int GetTotUrls () { return TotUrls; }
      static unsigned int IncrementTotUrls () { return ++TotUrls; }
      
   protected:
   
      // It inherits every attribute from the Url class

      unsigned int      IDUrl;
      unsigned int      IDServer;
      std::string            HTTPContentType;
      std::string            ContentType;
      std::string            TransferEncoding;
      HtDateTime        *LastModified;
      HtDateTime        *LastAccess;
      long              Size;
      unsigned int      StatusCode;
      std::string            ReasonPhrase;
      std::string            Location;
      _Server           *pServer;
      std::string            Title;      // Web Page title
      Url_ConnStatus    ConnStatus;
      std::string            ContentLanguage;  // Language code given by the server
      const std::string*     Contents;   // Contents of the retrieved URL
      std::string            HTTPCharset;
      std::string            Charset;
      Url_DocType       DocType;
      Url_DocTypeVersion DocTypeVersion;
      bool				DocTypeObsolete;
      std::string            Description;
      std::string            Keywords;
#ifdef HTDIG_NOTIFICATION
      std::string            HtDigEmail;
      std::string            HtDigEmailSubject;
      std::string            HtDigNotificationDate;
#endif

      // In certain cases it is useful to hide the LastModified value
      // like for not found documents, etc ...
      bool              _HideLastModified;

///////
   //    Static variable storing the number of Url "crawled"
   //    It's designed for assigning the IDUrl, in a incremental way
///////

      static unsigned int TotUrls;
};

#endif
