/*
 * GPG Keys 
 * cgpgproc.h
 * (c) 2001 Peter Mathiasson <peter@mathiasson.nu>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2, as
 * published by the Free Software Foundation
 */

#ifndef __CGPGPROC_H__
#define __CGPGPROC_H__

#include <qobject.h>
#include <qstring.h>
#include <qprocess.h>

class QStringList;

class CGPGProc : public QObject
{
    
    Q_OBJECT

public:
    CGPGProc( QObject *parent = 0 );
    bool import( const QString importData );

    static int run( QObject *parent, const QStringList args, const QString stdin = QString::null,
                    bool terminal = FALSE );

    enum {
        RUNFAILED,
        OK,
        ERROR,
        ALREADYRUNNING
    };

    int owner;

signals:
    void message( QString msg, int timeout );

private:
    QProcess *proc;

};

#endif // __CGPGPROC_H__
