using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

#region Google_Health specific imports
using Google.GData.Client;
using Google.GData.Health;
using Google.GData.Tools;
#endregion

namespace Google_HealthApplication
{
    public partial class Form1 : Form
    {

        private String googleAuthToken = null;
        private HealthService healthService = null;

        public Form1()
        {
            InitializeComponent();

            this.healthService = new HealthService("GoogleHealthSample");

            if (this.googleAuthToken == null)
            {
                GoogleClientLogin loginDialog = new GoogleClientLogin(this.healthService, "youremailhere@gmail.com");
                loginDialog.ShowDialog();

                this.googleAuthToken = loginDialog.AuthenticationToken;

                if (this.googleAuthToken != null)
                {
                    this.healthService.SetAuthenticationToken(this.googleAuthToken);
                    this.Text = "Successfully logged in";

                    HealthQuery query = new HealthQuery(HealthQuery.ProfileListFeed);
                    this.listView.Clear();

                    HealthFeed feed = this.healthService.Query(query);

                    if (feed != null && feed.Entries.Count > 0)
                    {
                        foreach (HealthEntry entry in feed.Entries)
                        {
                            ListViewItem item = new ListViewItem(entry.Title.Text);
                            item.Tag = entry;
                            this.listView.Items.Add(item);
                        }
                    }
                    this.listView.Update();
                }
            }
        }
    }
}