//
// File: PanelResultat.h
// Created by: Éric Laly <elaly@free.fr>
// Created on: Thu Nov  9 10:00:46 2006
//

#ifndef _PANELRESULTAT_H_
#define _PANELRESULTAT_H_
#include <wx/wx.h>
#include "PanelCadres.h"
#include "PanelSaisieParametresSignature.h"
#include "PanelParametresSortie.h"
#include "PanelChoixImages.h"
#include "ThreadTraitement.h"

class PanelResultat : public wxPanel
{
	public:
		PanelResultat(PanelCadres *panelcadres, PanelSaisieParametresSignature *panelsaisieparametresignature,
                                    PanelChoixImages *panelchoiximage, PanelParametresSortie *panelparametressortie,
                                    wxWindow* parent, int id);
		 ~PanelResultat();
        void GaugeAvancementGlobalSetValue(int valeur);	
        void GaugeAvancementLocalSetValue(int valeur);	
        void GaugeAvancementGlobalSetRange(int valeur);	
        void GaugeAvancementLocalSetRange(int valeur);	
        void TraitementTermine();
        void SetLabelAvancementGlobal(wxString label);
        void SetLabelAvancementLocal(wxString label);
        void SetLabelNomFichierTraite(wxString label);
        bool TraitementEnCours();    
    
	private:
        PanelCadres *panel_cadres;
        PanelSaisieParametresSignature* panel_signature;
        PanelChoixImages* panel_choix_images;
        PanelParametresSortie* panel_parametres_sortie;
		ThreadTraitement *thread_traitement;

        bool traitement_en_cours;
        wxWindow *mon_parent;
        
		void on_click_button_encadrer(wxCommandEvent& event);
		void on_click_button_annuler(wxCommandEvent& event);

	
	protected:
        wxBoxSizer* sizer_panel_resultat;
        wxStaticBox* sizer_avancement_local_staticbox;
        wxStaticBox* sizer_avancement_global_staticbox;
        wxGauge* gauge_avancement_global;
        wxGauge* gauge_avancement_local;
        wxPanel* notebook_panel_principal_pane_parametres_sortie;
        wxStaticText* label_avancement_global;
        wxStaticText* label_avancement_local;
        wxStaticText* label_nom_fichier_traite;
        wxButton* button_encadrer;
        wxButton* button_annuler;
};


#endif	//_PANELRESULTAT_H_
