/*
 * DEVICE dependent I/O
 */

#include	"defs.h"
#include	"emit.h"
#include	"global.h"
#include	"ps.h"
#ifdef KPATHSEA
#include	<kpathsea/tex-file.h>
#endif

static void copyfile();
static void createpipe();

void
dev_copyfile(str)
char *str;
{
    EMIT(outfp, "%%%%BeginFile: %s\n", str);
    copyfile(str, FALSE);
    EMIT(outfp, "%%%%EndFile\n");
}

void
ps_add_include(str)
char *str;
{
    int found;
    char newf[PATHLEN];

    if (found = ps_searchfile(str, newf)) {
	add_include_spec(found == SEARCH_ORIG ? str : newf, dev_copyfile);
    } else
	Warning("File %s not found", str);
}

void
ps_add_setup(str)
char *str;
{
    int found;
    char newf[PATHLEN];

    if (found = ps_searchfile(str, newf)) {
	add_setup_spec(found == SEARCH_ORIG ? str : newf, dev_copyfile);
    } else
	Warning("File %s not found", str);
}

void
ps_copyfigfile(str)
char *str;
{
    int found;
    char newf[PATHLEN];

    if (found = ps_searchfile(str, newf)) {
	EMIT(outfp, "%%%%BeginDocument: %s\n", str);
	copyfile(found == SEARCH_ORIG ? str : newf, G_removecomments);
	EMIT(outfp, "%%%%EndDocument\n");
    } else
	Warning("File %s not found", str);
}

ps_searchfile(f, newf)
char *f, *newf;
{
    char *filename;

    if (f[0] == '/') {
	if (access(f, R_OK) == 0)
	    return SEARCH_ORIG;
    } else {
	if (dvidirpath[0] != '\0') {
	    (void)strcpy(newf, dvidirpath);
	    (void)strcat(newf, f);
	    if (access(newf, R_OK) == 0)
		return SEARCH_NEW;
	}
#ifdef KPATHSEA
	filename = kpsearch_file(f, f, kpse_tex_ps_header_format);
	if (filename != NULL) {
	    (void)strcpy(newf, filename);
	    return SEARCH_NEW;
	}
#else
	if (access(f, R_OK) == 0)
	    return SEARCH_ORIG;
#endif
	(void)strcpy(newf, dvi2lib);
	(void)strcat(newf, "/");
	(void)strcat(newf, f);
	if (access(newf, R_OK) == 0)
	    return SEARCH_NEW;
    }
    return SEARCH_FAIL;
}

void
ps_createpipe(str)
char *str;
{
    EMIT(outfp, "%%%%BeginDocument: %s\n", str);
    createpipe(str, G_removecomments);
    EMIT(outfp, "%%%%EndDocument\n");
}

void
dev_copystring(str)
char *str;
{
    EMIT(outfp, "%s\n", str);
}

void
ps_string(str)
char *str;
{
    int i;
    int instring = 0;
    int lastc = 0;

    i = 0 ;
    while (*str) {
	if (i > 65 && *str == ' ' && instring == 0) {
	    EMITC('\n');
	    i = 0;
	} else {
	    EMITC(*str);
	    i++;
	}
	if (*str == '(' && lastc != '\\')
	    instring = 1;
	else if (*str == ')' && lastc != '\\')
	    instring = 0;
	lastc = *str;
	str++;
    }
}

pschar(c)
int c;
{
    if (c < ' ' || c >= 0177)
	EMITO(c);
    else if (c == '(' || c == ')' || c == '\\') {
	EMITC('\\');
	EMITC(c);
    } else
	EMITC(c);
}

codetopsstr(code, n)
int code, n;
{
    EMITC('(');
    c2pstr(code, n);
    EMITS(") ");
}

c2pstr(code, n)
int code, n;
{
    if (n > 0) {
	c2pstr(code>>8, n-1);
	pschar(code&0xff);
    }
}


cpfile(spfp, remcom, fn)
FILE *spfp;
BOOLEAN remcom;
char *fn;
{
    int t, pt;

    if ((t = getc(spfp)) == 0x80) {
	copy_type1_pfb(spfp, fn);
    } else if (remcom) {
	for (pt = '\n'; t != EOF; t = getc(spfp)) {
	    if (t == '%' && pt == '\n') {
		while ((t = getc(spfp)) != EOF)	/* remove comments */
		    if (t == '\n')
			break;
	    } else {
		EMITC(t);
		pt = t;
	    }
	}
    } else
	for (; t != EOF; t = getc(spfp))
	    EMITC(t);
}

/*-->copyfile*/   /* copy a file straight through to output */
/*********************************************************************/
/***************************** copyfile ******************************/
/*********************************************************************/
static void
copyfile(fn, remcom)
char *fn;
BOOLEAN remcom;
{
    FILE *spfp;

    if ((spfp = fopen(fn,"r")) == NULL) {
	Warning("Unable to open file %s", fn);
	return;
    }
    if (!G_quiet)
	(void)fprintf(stderr, "[%s", fn);
    cpfile(spfp, remcom, fn);
    (void)fclose(spfp);
    if (!G_quiet) {
	(void)fprintf(stderr, "] ");
	(void)fflush(stderr);
    }
}

/*-->createpipe*/   /* create pipe  */
/*********************************************************************/
/***************************** createpipe ******************************/
/*********************************************************************/
static void
createpipe(fn, remcom)
char *fn;
BOOLEAN remcom;
{
    FILE *spfp;
    int t, pt;

#ifdef MSDOS
    Warning("MSDOS does not have pipes");
    return;
#else
    if ((spfp = BINARYPOPEN(fn)) != NULL) {
	Warning("Unable to create pipe %s", fn);
	return;
    }
    if (!G_quiet)
	(void)fprintf(stderr, "[%s", fn);
    cpfile(spfp, remcom, fn);
    (void)pclose(spfp);
    if (!G_quiet) {
	(void)fprintf(stderr, "] ");
	(void)fflush(stderr);
    }
#endif
}
