/*
    DrMIPS - Educational MIPS simulator
    Copyright (C) 2013-2014 Bruno Nova <ei08109@fe.up.pt>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

package org.feup.brunonova.drmips.gui;

/**
 * Find/replace dialog.
 * 
 * @author Bruno Nova
 */
public class DlgFindReplace extends javax.swing.JDialog {
	/** The parent window of this dialog. */
	private final FrmSimulator parent;
	
	/**
	 * Creates new form DlgFindReplace
	 * @param parent The simulator's main window.
	 */
	public DlgFindReplace(FrmSimulator parent) {
		super(parent, false);
		initComponents();
		translate();
		this.parent = parent;
		getRootPane().setDefaultButton(cmdFind);
		Util.centerWindow(this);
		Util.enableCloseWindowWithEscape(this);
	}

	/**
	 * This method is called from within the constructor to initialize the form.
	 * WARNING: Do NOT modify this code. The content of this method is always
	 * regenerated by the Form Editor.
	 */
	@SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jPanel1 = new javax.swing.JPanel();
        lblFind = new javax.swing.JLabel();
        txtFind = new javax.swing.JTextField();
        lblReplace = new javax.swing.JLabel();
        txtReplace = new javax.swing.JTextField();
        chkMatchCase = new javax.swing.JCheckBox();
        chkBackwards = new javax.swing.JCheckBox();
        jPanel2 = new javax.swing.JPanel();
        cmdFind = new javax.swing.JButton();
        cmdReplace = new javax.swing.JButton();
        cmdReplaceAll = new javax.swing.JButton();
        cmdClose = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.DO_NOTHING_ON_CLOSE);
        setResizable(false);
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                formWindowClosing(evt);
            }
        });

        lblFind.setLabelFor(txtFind);
        lblFind.setText("find:");

        lblReplace.setLabelFor(txtReplace);
        lblReplace.setText("replace:");

        chkMatchCase.setText("match_case");

        chkBackwards.setText("backwards");

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(lblReplace)
                            .addComponent(lblFind))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(txtFind)
                            .addComponent(txtReplace)))
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(chkBackwards)
                            .addComponent(chkMatchCase))
                        .addGap(0, 223, Short.MAX_VALUE)))
                .addContainerGap())
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(lblFind)
                    .addComponent(txtFind, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(lblReplace)
                    .addComponent(txtReplace, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(chkMatchCase)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(chkBackwards)
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        getContentPane().add(jPanel1, java.awt.BorderLayout.CENTER);

        cmdFind.setText("find");
        cmdFind.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cmdFindActionPerformed(evt);
            }
        });
        jPanel2.add(cmdFind);

        cmdReplace.setText("replace");
        cmdReplace.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cmdReplaceActionPerformed(evt);
            }
        });
        jPanel2.add(cmdReplace);

        cmdReplaceAll.setText("replace_all");
        cmdReplaceAll.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cmdReplaceAllActionPerformed(evt);
            }
        });
        jPanel2.add(cmdReplaceAll);

        cmdClose.setText("close");
        cmdClose.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cmdCloseActionPerformed(evt);
            }
        });
        jPanel2.add(cmdClose);

        getContentPane().add(jPanel2, java.awt.BorderLayout.SOUTH);

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void cmdFindActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cmdFindActionPerformed
		parent.find(txtFind.getText(), chkMatchCase.isSelected(), !chkBackwards.isSelected());
    }//GEN-LAST:event_cmdFindActionPerformed

    private void formWindowClosing(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_formWindowClosing
		close();
    }//GEN-LAST:event_formWindowClosing

    private void cmdCloseActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cmdCloseActionPerformed
		close();
    }//GEN-LAST:event_cmdCloseActionPerformed

    private void cmdReplaceActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cmdReplaceActionPerformed
		parent.replace(txtFind.getText(), txtReplace.getText(), chkMatchCase.isSelected(), !chkBackwards.isSelected());
    }//GEN-LAST:event_cmdReplaceActionPerformed

    private void cmdReplaceAllActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cmdReplaceAllActionPerformed
		parent.replaceAll(txtFind.getText(), txtReplace.getText(), chkMatchCase.isSelected(), !chkBackwards.isSelected());
    }//GEN-LAST:event_cmdReplaceAllActionPerformed

	/**
	 * Translates the dialog's strings.
	 */
	protected final void translate() {
		setTitle(Lang.t("find_replace"));
		Lang.tButton(cmdFind, "find");
		Lang.tButton(cmdClose, "close");
		Lang.tButton(cmdReplace, "replace");
		Lang.tButton(cmdReplaceAll, "replace_all");
		lblFind.setText(Lang.t("find") + ":");
		lblReplace.setText(Lang.t("replace") + ":");
		chkMatchCase.setText(Lang.t("match_case"));
		chkBackwards.setText(Lang.t("backwards"));
		pack();
	}
	
	/**
	 * Closes the window.
	 */
	private void close() {
		parent.clearFind();
		setVisible(false);
	}
	
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JCheckBox chkBackwards;
    private javax.swing.JCheckBox chkMatchCase;
    private javax.swing.JButton cmdClose;
    private javax.swing.JButton cmdFind;
    private javax.swing.JButton cmdReplace;
    private javax.swing.JButton cmdReplaceAll;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JLabel lblFind;
    private javax.swing.JLabel lblReplace;
    private javax.swing.JTextField txtFind;
    private javax.swing.JTextField txtReplace;
    // End of variables declaration//GEN-END:variables
}
