// $Id: Ellipsoids.cxx 672 2007-09-02 15:47:45Z Larry $
//
// module Ellipsoids.cxx - part of DRAWxtl V5.4
// Coded using the FLTK 1.1.6 widget set
//
//     Larry W. Finger, Martin Kroeker and Brian Toby
//
// initial version generated by Fast Light User Interface Designer (fluid) version 1.0104
//
// routines contained within this file:
//
// Ellipsoids::Ellipsoids - constructor for screen
// Ellipsoids::show - routine to display the screen
//

#include "Ellipsoids.h"
void Load_Color_Combo(Flu_Combo_List * ot);
void New_Ellipsoid_Add_cb(class Fl_Widget *,int * action);
void New_Ellipsoid_Input_cb(class Fl_Widget *,void *);
void Modify_Ellipsoids_cb(Fl_Widget * a, void * b);

Ellipsoids::Ellipsoids(void)
{
  Fl_Window* w;
  static int one = 1;
  static int zero = 0;
  static int two = 2;
  int y;

  { Fl_Window* o = Ellips_Window = new Fl_Window(100, 100, 400, 510, "Edit Ellipsoid Parameters");
    w = o;
    o->callback((Fl_Callback*)Edit_Ellipsoid_Close_cb);
    o->user_data((void*)(this));
    y = 20;
    { Fl_Text_Editor* o = Color_Input = new Fl_Text_Editor(65, y, 250, 160,
        "Atom            Ellipsoid Color          ");
      o->labelfont(1);
      o->labelsize(12);
      o->textfont(5);
    }
    y += 160;
    { Instr1 = new Fl_Output(75, y,250,0,
            "Highlight or double-click text above to edit");
      Instr1->align(FL_ALIGN_BOTTOM);
      Instr = new Fl_Output(75, y,250,0,"Press 'Add' to replace "
            "selected line - 'Remove' to delete it");
      Instr->hide();
      Instr->align(FL_ALIGN_BOTTOM);
    }
   y += 40;
    { Flu_Combo_List * o = Atom_Combo = new Flu_Combo_List(30, y, 160,25,"Atom");
      o->align(FL_ALIGN_TOP);
      o->labelfont(1);
    }
    { Flu_Combo_List * o = Color_Combo = new Flu_Combo_List(210, y,160,25,"Color");
      o->align(FL_ALIGN_TOP);
      o->callback((Fl_Callback*)New_Ellipsoid_Input_cb);
      o->labelfont(1);
    }
    y += 40;
    { Fl_Button * om = New_Ellipsoid_Add = new Fl_Button( 75, y, 70, 25, "Add");
      om->callback((Fl_Callback*)New_Ellipsoid_Add_cb,&one);
      om->tooltip("When active, press to transfer data in boxes to window above");
      om->deactivate();
      Fl_Button * mm  = New_Ellipsoid_Remove = new Fl_Button( 165, y, 70, 25, "Remove");
      mm->callback((Fl_Callback*)New_Ellipsoid_Add_cb,&zero);
      mm->tooltip("When active, press to remove highlighted line.");
      mm->deactivate();
      Fl_Button * pm = New_Ellipsoid_Convert = new Fl_Button( 255, y, 70, 25, "Convert");
      pm->callback((Fl_Callback*)New_Ellipsoid_Add_cb,&two);
      pm->tooltip("When active, press to convert atom in boxes from ellipsoid to sphere");
      pm->deactivate();
    }
    y += 35;
    Instr2 = new Fl_Output( 5, y, 390,0,
            "Changes are temporary until \"Apply\" or \"Save\" is pressed.");
    Instr2->hide();
    Instr2->align(FL_ALIGN_BOTTOM);
    y += 45;
    { Draw_Fl_Input* o = Probability = new Draw_Fl_Input( 40, y, 150, 25, "Ellipsoid Probability");
      o->labelfont(1);
      o->align(FL_ALIGN_TOP);
    }
    { Draw_Fl_Input* o = Axis_Width = new Draw_Fl_Input(210, y, 150, 25, "Principle Axis Width");
      o->labelfont(1);
      o->align(FL_ALIGN_TOP);
    }
    y += 50;
    { Flu_Combo_List* o = Axis_Color = new Flu_Combo_List( 50, y, 150, 25, "Axis Color");
      o->labelfont(1);
      Load_Color_Combo(o);
      o->align(FL_ALIGN_TOP);
    }
    { Flu_Combo_List* o = Cutout_Color = new Flu_Combo_List(210, y, 150, 25, "Cutout Color");
      o->labelfont(1);
      Load_Color_Combo(o);
      o->align(FL_ALIGN_TOP);
    }
    y += 40;
    { Fl_Check_Button* o = Show_Ellipsoids = new Fl_Check_Button(50, y, 125, 25, "Show Ellipsoids");
      o->down_box(FL_DOWN_BOX);
    }
    { Fl_Check_Button* o = Use_Cutouts = new Fl_Check_Button(210, y, 125, 25, "Include Cutouts");
      o->down_box(FL_DOWN_BOX);
      o->callback((Fl_Callback*)Include_Cutouts_cb);
    }
    y += 30;
    { Fl_Button* o = new Fl_Button(50, y, 80, 30, "Close");
      o->tooltip("Close this window and discard all changes.");
      o->callback((Fl_Callback*)Edit_Ellipsoid_Close_cb);
    }
    { Fl_Button* o = new Fl_Button(150, y, 80, 30, "Apply");
      o->tooltip("Apply current contents of top box to drawing, but leave this window open.");
      o->callback((Fl_Callback*)Edit_Ellipsoid_Save_cb,&zero);
    }
    { Fl_Button* o = new Fl_Button(250, y, 80, 30, "Save");
      o->tooltip("Apply current contents of top box to drawing, then close this window.");
      o->callback((Fl_Callback*)Edit_Ellipsoid_Save_cb,&one);
    }
    w->end();
  }
}

void Ellipsoids::show(void)
{
  Ellips_Window->show();
  ColorInputBuf = new Fl_Text_Buffer;
  Color_Input->buffer(ColorInputBuf);
  ColorInputBuf->add_modify_callback((Fl_Text_Modify_Cb)Modify_Ellipsoids_cb,(void*)NULL);
}
