import urllib
from re import compile

from dosage.helpers import BasicScraper, indirectStarter


class Zapiro(BasicScraper):
    baseUrl = 'http://www.mg.co.za/zapiro/default.aspx'
    imageUrl = 'http://www.mg.co.za/zapiro/imagePage.aspx?YearId=%s|MonthId=%s|DayId=%s'
    imageSearch = compile(r'<img src=(http://www.mg.co.za/ContentImages/\d+/\d{2}-...\d{2}x\.gif) border=0 />')
    prevSearch = compile(r'href="((?:/zapiro/)?[iI]magePage.aspx\?YearId=\d{4}\|MonthId=\d{1,2}\|DayId=\d{1,2})"')
    latestSearch = compile(r'<a href="(imagePage.aspx\?YearId=\d{4}\|MonthId=\d{1,2}\|DayId=\d{1,2})">')
    help = 'Index format: yyyy-mm-dd'

    starter = indirectStarter('http://www.mg.co.za/zapiro/default.aspx', compile(r'<a href="(imagePage.aspx\?YearId=\d{4}\|MonthId=\d{1,2}\|DayId=\d{1,2})">'))

    def setStrip(self, index):
        self.currentUrl = self.imageUrl % tuple(map(int, index.split('-')))

    def namer(cls, imageUrl, pageUrl):
        values = [a.split('=') for a in urllib.splitquery(pageUrl)[-1].split('|')]
        d = dict([(name, int(value)) for name, value in values])
        return 'zapiro-%(YearId)02d%(MonthId)02d%(DayId)02d' % d


class ZombieHunters(BasicScraper):
    latestUrl = 'http://www.thezombiehunters.com/'
    imageUrl = 'http://www.thezombiehunters.com/index.php?strip_id=%s'
    imageSearch = compile(r'"(.+?strips/.+?)"')
    prevSearch = compile(r'"(.+?)">\r\n.+?Pre')
    help = 'Index format: n(unpadded)'
