from re import compile

from dosage.helpers import BasicScraper


class GUComics(BasicScraper):
    latestUrl = 'http://www.gucomics.com/comic/'
    imageUrl = 'http://www.gucomics.com/comic/?cdate=%s'
    imageSearch = compile(r'<IMG src="(/comics/\d{4}/gu_.*?)"')
    prevSearch = compile(r'<A href="(/comic/\?cdate=\d+)"><IMG src="/images/cnav_prev')
    help = 'Index format: yyyymmdd'


class GenrezvousPoint(BasicScraper):
    latestUrl = 'http://www.iccomics.com/chapters/genrezvouspoint/index.php?id=120'
    imageUrl = 'http://www.iccomics.com/chapters/genrezvouspoint/index.php?id=%s'
    imageSearch = compile(r'src="(.*?gp-comics/.*?)"')
    prevSearch = compile(r'</a><a href="(.+?index.php\?id=.*?)".*?navbar_03')
    help = 'Index format: n (unpadded)'


class GirlGenius(BasicScraper):
    latestUrl = 'http://girlgeniusonline.com/comic.php'
    imageUrl = 'http://www.girlgeniusonline.com/comic.php\?date=%s'
    imageSearch = compile(r"(/ggmain/strips/.+?)'")
    prevSearch = compile(r"</a> <a href=.+?(/comic.php\?date=.+?)'.+?Previous")
    help = 'Index format: yyyymmdd'


class GirlsWithSlingshots(BasicScraper):
    latestUrl = 'http://www.daniellecorsetto.com/gws.html'
    imageUrl = 'http://www.daniellecorsetto.com/GWS%s.html'
    imageSearch = compile(r'<img src="(images/gws/GWS\d{3}.jpg)"')
    prevSearch = compile(r'<a href="(GWS\d{3}.html)" onMouseOver="imgOn\(\'img2\'\)"')
    help = 'Index format: nnn'


class Girly(BasicScraper):
    latestUrl = 'http://go-girly.com/'
    imageUrl = 'http://go-girly.com/go/%s'
    imageSearch = compile(r'"(http://comics.go-girly.com/.*?)"')
    prevSearch = compile(r"<a href=\'(/go/.*?)\'.+?nav_girly_prev.gif")
    help = 'Index format: nnn'


class GlueMeat(BasicScraper):
    latestUrl = 'http://www.gluemeat.com/'
    imageUrl = 'http://www.gluemeat.com/archives/%s.html'
    imageSearch = compile(r'<img.+?src="(http://www.gluemeat.com/comics/\d{8}\..+?)"')
    prevSearch = compile(r'(?:<a|<link rel="prev") href="(http://www.gluemeat.com/archives/\d{6}\.html)"(?!>Comment on this comic)(?:.+?</a> \]</font>)?')
    help = 'Index format: nnnnnn'


class Goats(BasicScraper):
    latestUrl = 'http://www.goats.com/'
    imageUrl = 'http://www.goats.com/archive/%s.html'
    imageSearch = compile(r'<img.+?src="(/comix/.+?)"')
    prevSearch = compile(r'<a href="(/archive/\d{6}.html)" class="button" title="go back">')
    help = 'Index format: yymmdd'


class GoneWithTheBlastwave(BasicScraper):
    latestUrl = 'http://www.blastwavecomic.com/'
    imageUrl = 'http://www.blastwavecomic.com/index.php?strip_id=%s'
    imageSearch = compile(r'<img.+?src="(istrip_files/strips/\d{8}\..+?)"')
    prevSearch = compile(r'<a href="/(index.php\?strip_id=\d+)"><img src="images/previous.jpg"')
    help = 'Index format: n'


class GunnerkrigCourt(BasicScraper):                                                                     
    latestUrl = 'http://www.gunnerkrigg.com/index2.php'
    imageUrl = 'http://www.gunnerkrigg.com/archive_page.php\?comicID=%s'
    imageSearch = compile(r'<img src="(.+?//comics/.+?)"')
    prevSearch = compile(r'<.+?(/archive_page.php\?comicID=.+?)".+?prev')
    help = 'Index format: n'
