// This code conforms with the UFC specification version 1.4
// and was automatically generated by FFC version 0.9.2.
//
// This code was generated with the option '-l dolfin' and
// contains DOLFIN-specific wrappers that depend on DOLFIN.
// 
// This code was generated with the following parameters:
// 
//   cache_dir:                      ''
//   convert_exceptions_to_warnings: False
//   cpp_optimize:                   False
//   epsilon:                        1e-14
//   form_postfix:                   True
//   format:                         'dolfin'
//   log_level:                      10
//   log_prefix:                     ''
//   optimize:                       False
//   output_dir:                     '.'
//   precision:                      15
//   quadrature_degree:              'auto'
//   quadrature_rule:                'auto'
//   representation:                 'auto'
//   split:                          False

#ifndef __FORMS_H
#define __FORMS_H

#include <cmath>
#include <stdexcept>
#include <fstream>
#include <ufc.h>

/// This class defines the interface for a finite element.

class forms_finite_element_0: public ufc::finite_element
{
public:

  /// Constructor
  forms_finite_element_0() : ufc::finite_element()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~forms_finite_element_0()
  {
    // Do nothing
  }

  /// Return a string identifying the finite element
  virtual const char* signature() const
  {
    return "FiniteElement('Nedelec 1st kind H(curl)', Cell('triangle', 1, Space(2)), 3)";
  }

  /// Return the cell shape
  virtual ufc::shape cell_shape() const
  {
    return ufc::triangle;
  }

  /// Return the dimension of the finite element function space
  virtual unsigned int space_dimension() const
  {
    return 15;
  }

  /// Return the rank of the value space
  virtual unsigned int value_rank() const
  {
    return 1;
  }

  /// Return the dimension of the value space for axis i
  virtual unsigned int value_dimension(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return 2;
        break;
      }
    }
    
    return 0;
  }

  /// Evaluate basis function i at given point in cell
  virtual void evaluate_basis(unsigned int i,
                              double* values,
                              const double* coordinates,
                              const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    const double K_00 =  J_11 / detJ;
    const double K_01 = -J_01 / detJ;
    const double K_10 = -J_10 / detJ;
    const double K_11 =  J_00 / detJ;
    
    // Compute constants
    const double C0 = x[1][0] + x[2][0];
    const double C1 = x[1][1] + x[2][1];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J_01*(C1 - 2.0*coordinates[1]) + J_11*(2.0*coordinates[0] - C0)) / detJ;
    double Y = (J_00*(2.0*coordinates[1] - C1) + J_10*(C0 - 2.0*coordinates[0])) / detJ;
    
    // Reset values.
    values[0] = 0.000000000000000;
    values[1] = 0.000000000000000;
    
    // Map degree of freedom to element degree of freedom
    const unsigned int dof = i;
    
    // Array of basisvalues.
    double basisvalues[10] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
    
    // Declare helper variables.
    unsigned int rr = 0;
    unsigned int ss = 0;
    unsigned int tt = 0;
    double tmp5 = 0.000000000000000;
    double tmp6 = 0.000000000000000;
    double tmp7 = 0.000000000000000;
    double tmp0 = (1.000000000000000 + Y + 2.000000000000000*X)/2.000000000000000;
    double tmp1 = (1.000000000000000 - Y)/2.000000000000000;
    double tmp2 = tmp1*tmp1;
    
    // Compute basisvalues.
    basisvalues[0] = 1.000000000000000;
    basisvalues[1] = tmp0;
    for (unsigned int r = 1; r < 3; r++)
    {
      rr = (r + 1)*((r + 1) + 1)/2;
      ss = r*(r + 1)/2;
      tt = (r - 1)*((r - 1) + 1)/2;
      tmp5 = (1.000000000000000 + 2.000000000000000*r)/(1.000000000000000 + r);
      basisvalues[rr] = (basisvalues[ss]*tmp0*tmp5 - basisvalues[tt]*tmp2*r/(1.000000000000000 + r));
    }// end loop over 'r'
    for (unsigned int r = 0; r < 3; r++)
    {
      rr = (r + 1)*(r + 1 + 1)/2 + 1;
      ss = r*(r + 1)/2;
      basisvalues[rr] = basisvalues[ss]*(0.500000000000000 + r + Y*(1.500000000000000 + r));
    }// end loop over 'r'
    for (unsigned int r = 0; r < 2; r++)
    {
      for (unsigned int s = 1; s < 3 - r; s++)
      {
        rr = (r + s + 1)*(r + s + 1 + 1)/2 + s + 1;
        ss = (r + s)*(r + s + 1)/2 + s;
        tt = (r + s - 1)*(r + s - 1 + 1)/2 + s - 1;
        tmp5 = (2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
        tmp6 = (1.000000000000000 + 4.000000000000000*r*r + 4.000000000000000*r)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
        tmp7 = (1.000000000000000 + s + 2.000000000000000*r)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*s/((1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
        basisvalues[rr] = (basisvalues[ss]*(tmp6 + Y*tmp5) - basisvalues[tt]*tmp7);
      }// end loop over 's'
    }// end loop over 'r'
    for (unsigned int r = 0; r < 4; r++)
    {
      for (unsigned int s = 0; s < 4 - r; s++)
      {
        rr = (r + s)*(r + s + 1)/2 + s;
        basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s));
      }// end loop over 's'
    }// end loop over 'r'
    
    // Table(s) of coefficients.
    static const double coefficients0[15][10] = \
    {{0.000000000000000, 0.000000000000000, 0.000000000000000, -0.169533172561123, 0.084179378712684, -0.116642368703960, 0.000000000000000, -0.146820034222103, 0.072901480439975, -0.101015254455221},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.078246079643595, -0.168358757425368, 0.349927106111882, 0.000000000000000, 0.067763092717894, -0.145802960879951, 0.303045763365662},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, -0.039123039821798, -0.084179378712684, -0.349927106111882, 0.000000000000000, -0.033881546358947, -0.072901480439976, -0.303045763365663},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.169533172561123, 0.084179378712684, 0.116642368703960, 0.000000000000000, 0.146820034222103, 0.072901480439975, 0.101015254455221},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, -0.078246079643595, -0.168358757425368, -0.349927106111882, 0.000000000000000, -0.067763092717894, -0.145802960879951, -0.303045763365663},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.039123039821798, -0.084179378712684, 0.349927106111882, 0.000000000000000, 0.033881546358947, -0.072901480439975, 0.303045763365663},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.382536389368687, 0.303045763365663, 0.311046316543896, 0.000000000000000, -0.090350790290525, -0.145802960879951, -0.202030508910442},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, -0.765072778737375, 0.000000000000000, -0.155523158271948, 0.000000000000000, 0.180701580581050, 0.000000000000000, 0.101015254455221},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.382536389368688, -0.303045763365664, 0.311046316543896, 0.000000000000000, -0.090350790290525, 0.145802960879951, -0.202030508910442},
    {3.999999999999862, 0.000000000000000, 0.000000000000000, -0.368855556781646, -0.476190476190460, -1.649572197684589, 0.000000000000000, -0.319438282499959, -0.412393049421147, 0.571428571428550},
    {0.000000000000000, 3.999999999999862, 0.000000000000000, -0.677630927178916, 1.807956714911334, 0.000000000000000, 0.000000000000000, -0.586845597326944, -1.262690680690219, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 3.999999999999863, 0.130410132739319, -0.841793787126813, 0.933138949631657, 0.000000000000000, 0.112938487863151, -0.729014804399730, -2.020305089104351},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.952380952380918, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.824786098842294, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 1.355261854357829, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.173691194653886, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.683587574253624, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.458029608799459, 0.000000000000000}};
    
    static const double coefficients1[15][10] = \
    {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.321678327423669, -0.134687005940295, 0.097201973919967, 0.260579710864614, -0.129879261042630, 0.097687983789567, -0.063134534034513},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, -0.165186168136480, 0.235702260395516, -0.272165526975908, -0.120267558860592, 0.146820034222104, -0.224536559755125, 0.176776695296637},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.060858061945019, 0.000000000000000, 0.213844342623928, 0.060133779430296, 0.039528470752104, 0.112268279877563, -0.138895974875929},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.491211499984792, 0.218866384652979, 0.213844342623928, -0.260579710864614, 0.016940773179474, -0.024786503349592, 0.037880720420708},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, -0.243432247780074, -0.404061017820885, -0.622092633087791, 0.120267558860591, 0.079056941504209, 0.078733598875174, -0.126269068069027},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.099981101766815, -0.084179378712684, 0.563771448735811, -0.060133779430296, 0.073410017111052, -0.185169760317538, 0.164149788489734},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.169533172561123, 0.084179378712684, 0.116642368703961, 0.160356745147455, 0.067763092717894, 0.032076651393589, -0.075761440841416},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, -0.382536389368688, 0.067343502970148, -0.077761579135974, -0.320713490294909, 0.090350790290525, -0.064153302787179, 0.050507627227611},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.213003216807565, -0.218866384652980, 0.194403947839935, 0.160356745147455, -0.158113883008420, 0.177879612273541, -0.126269068069027},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.614759261302741, 0.476190476190461, -0.549857399228195, 0.566946709513820, 0.159719141249981, -0.453632354363262, 0.357142857142845},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 1.054092553389421, 1.166423687039569, -0.336717514850724, 1.041547612244083, 0.684653196881436, -0.580837713117501, 0.218704441319919},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, -0.347760353971521, 0.336717514850723, 1.360827634879499, -0.200445931434311, 0.621161683247337, 0.597792139607781, -0.883883476483157},
    {3.999999999999861, 0.000000000000000, 0.000000000000000, -1.598374079387130, 0.476190476190459, -0.549857399228198, 0.000000000000000, -0.638876564999920, 0.412393049421147, -0.142857142857137},
    {0.000000000000000, 3.999999999999858, 0.000000000000000, 0.677630927178914, -0.524890659167804, 0.000000000000000, -2.083095224488168, 0.586845597326944, -0.101015254455218, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 3.999999999999862, 0.825930840682368, 0.841793787126812, -1.788516320127341, 0.000000000000000, -1.129384878631528, 0.729014804399730, -0.252538136138043}};
    
    // Compute value(s).
    for (unsigned int r = 0; r < 10; r++)
    {
      values[0] += coefficients0[dof][r]*basisvalues[r];
      values[1] += coefficients1[dof][r]*basisvalues[r];
    }// end loop over 'r'
    
    // Using covariant Piola transform to map values back to the physical element.
    const double tmp_ref0 = values[0];
    const double tmp_ref1 = values[1];
    values[0] = (K_00*tmp_ref0 + K_10*tmp_ref1);
    values[1] = (K_01*tmp_ref0 + K_11*tmp_ref1);
  }

  /// Evaluate all basis functions at given point in cell
  virtual void evaluate_basis_all(double* values,
                                  const double* coordinates,
                                  const ufc::cell& c) const
  {
    // Helper variable to hold values of a single dof.
    double dof_values[2] = {0.000000000000000, 0.000000000000000};
    
    // Loop dofs and call evaluate_basis.
    for (unsigned int r = 0; r < 15; r++)
    {
      evaluate_basis(r, dof_values, coordinates, c);
      for (unsigned int s = 0; s < 2; s++)
      {
        values[r*2 + s] = dof_values[s];
      }// end loop over 's'
    }// end loop over 'r'
  }

  /// Evaluate order n derivatives of basis function i at given point in cell
  virtual void evaluate_basis_derivatives(unsigned int i,
                                          unsigned int n,
                                          double* values,
                                          const double* coordinates,
                                          const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    const double K_00 =  J_11 / detJ;
    const double K_01 = -J_01 / detJ;
    const double K_10 = -J_10 / detJ;
    const double K_11 =  J_00 / detJ;
    
    // Compute constants
    const double C0 = x[1][0] + x[2][0];
    const double C1 = x[1][1] + x[2][1];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J_01*(C1 - 2.0*coordinates[1]) + J_11*(2.0*coordinates[0] - C0)) / detJ;
    double Y = (J_00*(2.0*coordinates[1] - C1) + J_10*(C0 - 2.0*coordinates[0])) / detJ;
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    }// end loop over 'r'
    
    // Declare pointer to two dimensional array that holds combinations of derivatives and initialise
    unsigned int **combinations = new unsigned int *[num_derivatives];
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      combinations[row] = new unsigned int [n];
      for (unsigned int col = 0; col < n; col++)
        combinations[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations[row][col] + 1 > 1)
            combinations[row][col] = 0;
          else
          {
            combinations[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[2][2] = {{K_00, K_01}, {K_10, K_11}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double **transform = new double *[num_derivatives];
    
    for (unsigned int j = 0; j < num_derivatives; j++)
    {
      transform[j] = new double [num_derivatives];
      for (unsigned int k = 0; k < num_derivatives; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      for (unsigned int col = 0; col < num_derivatives; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations[col][k]][combinations[row][k]];
      }
    }
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < 2*num_derivatives; r++)
    {
      values[r] = 0.000000000000000;
    }// end loop over 'r'
    
    // Map degree of freedom to element degree of freedom
    const unsigned int dof = i;
    
    // Array of basisvalues.
    double basisvalues[10] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
    
    // Declare helper variables.
    unsigned int rr = 0;
    unsigned int ss = 0;
    unsigned int tt = 0;
    double tmp5 = 0.000000000000000;
    double tmp6 = 0.000000000000000;
    double tmp7 = 0.000000000000000;
    double tmp0 = (1.000000000000000 + Y + 2.000000000000000*X)/2.000000000000000;
    double tmp1 = (1.000000000000000 - Y)/2.000000000000000;
    double tmp2 = tmp1*tmp1;
    
    // Compute basisvalues.
    basisvalues[0] = 1.000000000000000;
    basisvalues[1] = tmp0;
    for (unsigned int r = 1; r < 3; r++)
    {
      rr = (r + 1)*((r + 1) + 1)/2;
      ss = r*(r + 1)/2;
      tt = (r - 1)*((r - 1) + 1)/2;
      tmp5 = (1.000000000000000 + 2.000000000000000*r)/(1.000000000000000 + r);
      basisvalues[rr] = (basisvalues[ss]*tmp0*tmp5 - basisvalues[tt]*tmp2*r/(1.000000000000000 + r));
    }// end loop over 'r'
    for (unsigned int r = 0; r < 3; r++)
    {
      rr = (r + 1)*(r + 1 + 1)/2 + 1;
      ss = r*(r + 1)/2;
      basisvalues[rr] = basisvalues[ss]*(0.500000000000000 + r + Y*(1.500000000000000 + r));
    }// end loop over 'r'
    for (unsigned int r = 0; r < 2; r++)
    {
      for (unsigned int s = 1; s < 3 - r; s++)
      {
        rr = (r + s + 1)*(r + s + 1 + 1)/2 + s + 1;
        ss = (r + s)*(r + s + 1)/2 + s;
        tt = (r + s - 1)*(r + s - 1 + 1)/2 + s - 1;
        tmp5 = (2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
        tmp6 = (1.000000000000000 + 4.000000000000000*r*r + 4.000000000000000*r)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
        tmp7 = (1.000000000000000 + s + 2.000000000000000*r)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*s/((1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
        basisvalues[rr] = (basisvalues[ss]*(tmp6 + Y*tmp5) - basisvalues[tt]*tmp7);
      }// end loop over 's'
    }// end loop over 'r'
    for (unsigned int r = 0; r < 4; r++)
    {
      for (unsigned int s = 0; s < 4 - r; s++)
      {
        rr = (r + s)*(r + s + 1)/2 + s;
        basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s));
      }// end loop over 's'
    }// end loop over 'r'
    
    // Table(s) of coefficients.
    static const double coefficients0[15][10] = \
    {{0.000000000000000, 0.000000000000000, 0.000000000000000, -0.169533172561123, 0.084179378712684, -0.116642368703960, 0.000000000000000, -0.146820034222103, 0.072901480439975, -0.101015254455221},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.078246079643595, -0.168358757425368, 0.349927106111882, 0.000000000000000, 0.067763092717894, -0.145802960879951, 0.303045763365662},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, -0.039123039821798, -0.084179378712684, -0.349927106111882, 0.000000000000000, -0.033881546358947, -0.072901480439976, -0.303045763365663},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.169533172561123, 0.084179378712684, 0.116642368703960, 0.000000000000000, 0.146820034222103, 0.072901480439975, 0.101015254455221},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, -0.078246079643595, -0.168358757425368, -0.349927106111882, 0.000000000000000, -0.067763092717894, -0.145802960879951, -0.303045763365663},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.039123039821798, -0.084179378712684, 0.349927106111882, 0.000000000000000, 0.033881546358947, -0.072901480439975, 0.303045763365663},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.382536389368687, 0.303045763365663, 0.311046316543896, 0.000000000000000, -0.090350790290525, -0.145802960879951, -0.202030508910442},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, -0.765072778737375, 0.000000000000000, -0.155523158271948, 0.000000000000000, 0.180701580581050, 0.000000000000000, 0.101015254455221},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.382536389368688, -0.303045763365664, 0.311046316543896, 0.000000000000000, -0.090350790290525, 0.145802960879951, -0.202030508910442},
    {3.999999999999862, 0.000000000000000, 0.000000000000000, -0.368855556781646, -0.476190476190460, -1.649572197684589, 0.000000000000000, -0.319438282499959, -0.412393049421147, 0.571428571428550},
    {0.000000000000000, 3.999999999999862, 0.000000000000000, -0.677630927178916, 1.807956714911334, 0.000000000000000, 0.000000000000000, -0.586845597326944, -1.262690680690219, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 3.999999999999863, 0.130410132739319, -0.841793787126813, 0.933138949631657, 0.000000000000000, 0.112938487863151, -0.729014804399730, -2.020305089104351},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.952380952380918, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.824786098842294, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 1.355261854357829, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.173691194653886, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.683587574253624, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.458029608799459, 0.000000000000000}};
    
    static const double coefficients1[15][10] = \
    {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.321678327423669, -0.134687005940295, 0.097201973919967, 0.260579710864614, -0.129879261042630, 0.097687983789567, -0.063134534034513},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, -0.165186168136480, 0.235702260395516, -0.272165526975908, -0.120267558860592, 0.146820034222104, -0.224536559755125, 0.176776695296637},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.060858061945019, 0.000000000000000, 0.213844342623928, 0.060133779430296, 0.039528470752104, 0.112268279877563, -0.138895974875929},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.491211499984792, 0.218866384652979, 0.213844342623928, -0.260579710864614, 0.016940773179474, -0.024786503349592, 0.037880720420708},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, -0.243432247780074, -0.404061017820885, -0.622092633087791, 0.120267558860591, 0.079056941504209, 0.078733598875174, -0.126269068069027},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.099981101766815, -0.084179378712684, 0.563771448735811, -0.060133779430296, 0.073410017111052, -0.185169760317538, 0.164149788489734},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.169533172561123, 0.084179378712684, 0.116642368703961, 0.160356745147455, 0.067763092717894, 0.032076651393589, -0.075761440841416},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, -0.382536389368688, 0.067343502970148, -0.077761579135974, -0.320713490294909, 0.090350790290525, -0.064153302787179, 0.050507627227611},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.213003216807565, -0.218866384652980, 0.194403947839935, 0.160356745147455, -0.158113883008420, 0.177879612273541, -0.126269068069027},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.614759261302741, 0.476190476190461, -0.549857399228195, 0.566946709513820, 0.159719141249981, -0.453632354363262, 0.357142857142845},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 1.054092553389421, 1.166423687039569, -0.336717514850724, 1.041547612244083, 0.684653196881436, -0.580837713117501, 0.218704441319919},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, -0.347760353971521, 0.336717514850723, 1.360827634879499, -0.200445931434311, 0.621161683247337, 0.597792139607781, -0.883883476483157},
    {3.999999999999861, 0.000000000000000, 0.000000000000000, -1.598374079387130, 0.476190476190459, -0.549857399228198, 0.000000000000000, -0.638876564999920, 0.412393049421147, -0.142857142857137},
    {0.000000000000000, 3.999999999999858, 0.000000000000000, 0.677630927178914, -0.524890659167804, 0.000000000000000, -2.083095224488168, 0.586845597326944, -0.101015254455218, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 3.999999999999862, 0.825930840682368, 0.841793787126812, -1.788516320127341, 0.000000000000000, -1.129384878631528, 0.729014804399730, -0.252538136138043}};
    
    // Tables of derivatives of the polynomial base (transpose).
    static const double dmats0[10][10] = \
    {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {4.898979485566355, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 9.486832980505142, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {3.999999999999999, 0.000000000000000, 7.071067811865475, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {5.291502622129176, 0.000000000000000, -2.993325909419151, 13.662601021279464, 0.000000000000000, 0.611010092660779, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 4.381780460041331, 0.000000000000000, 0.000000000000000, 12.521980673998822, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {3.464101615137755, 0.000000000000000, 7.838367176906168, 0.000000000000000, 0.000000000000000, 8.400000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
    
    static const double dmats1[10][10] = \
    {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {2.449489742783177, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {4.242640687119284, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {2.581988897471610, 4.743416490252571, -0.912870929175277, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {1.999999999999999, 6.123724356957947, 3.535533905932737, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {-2.309401076758502, 0.000000000000000, 8.164965809277261, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {2.645751311064589, 5.184592558726288, -1.496662954709576, 6.831300510639734, -1.058300524425837, 0.305505046330389, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {2.236067977499788, 2.190890230020665, 2.529822128134705, 8.082903768654763, 6.260990336999409, -1.807392228230128, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {1.732050807568877, -5.091168824543142, 3.919183588453084, 0.000000000000000, 9.699484522385713, 4.200000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {5.000000000000000, 0.000000000000000, -2.828427124746192, 0.000000000000000, 0.000000000000000, 12.124355652982143, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
    
    // Compute reference derivatives.
    // Declare pointer to array of derivatives on FIAT element.
    double *derivatives = new double[2*num_derivatives];
    for (unsigned int r = 0; r < 2*num_derivatives; r++)
    {
      derivatives[r] = 0.000000000000000;
    }// end loop over 'r'
    
    // Declare derivative matrix (of polynomial basis).
    double dmats[10][10] = \
    {{1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000}};
    
    // Declare (auxiliary) derivative matrix (of polynomial basis).
    double dmats_old[10][10] = \
    {{1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000}};
    
    // Loop possible derivatives.
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      // Resetting dmats values to compute next derivative.
      for (unsigned int t = 0; t < 10; t++)
      {
        for (unsigned int u = 0; u < 10; u++)
        {
          dmats[t][u] = 0.000000000000000;
          if (t == u)
          {
          dmats[t][u] = 1.000000000000000;
          }
          
        }// end loop over 'u'
      }// end loop over 't'
      
      // Looping derivative order to generate dmats.
      for (unsigned int s = 0; s < n; s++)
      {
        // Updating dmats_old with new values and resetting dmats.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats_old[t][u] = dmats[t][u];
            dmats[t][u] = 0.000000000000000;
          }// end loop over 'u'
        }// end loop over 't'
        
        // Update dmats using an inner product.
        if (combinations[r][s] == 0)
        {
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            for (unsigned int tu = 0; tu < 10; tu++)
            {
              dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
            }// end loop over 'tu'
          }// end loop over 'u'
        }// end loop over 't'
        }
        
        if (combinations[r][s] == 1)
        {
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            for (unsigned int tu = 0; tu < 10; tu++)
            {
              dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
            }// end loop over 'tu'
          }// end loop over 'u'
        }// end loop over 't'
        }
        
      }// end loop over 's'
      for (unsigned int s = 0; s < 10; s++)
      {
        for (unsigned int t = 0; t < 10; t++)
        {
          derivatives[r] += coefficients0[dof][s]*dmats[s][t]*basisvalues[t];
          derivatives[num_derivatives + r] += coefficients1[dof][s]*dmats[s][t]*basisvalues[t];
        }// end loop over 't'
      }// end loop over 's'
      
      // Using covariant Piola transform to map values back to the physical element
      const double tmp_ref0 = derivatives[r];
      const double tmp_ref1 = derivatives[num_derivatives + r];
      derivatives[r] = (K_00*tmp_ref0 + K_10*tmp_ref1);
      derivatives[num_derivatives + r] = (K_01*tmp_ref0 + K_11*tmp_ref1);
    }// end loop over 'r'
    
    // Transform derivatives back to physical element
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      for (unsigned int s = 0; s < num_derivatives; s++)
      {
        values[r] += transform[r][s]*derivatives[s];
        values[num_derivatives + r] += transform[r][s]*derivatives[num_derivatives + s];
      }// end loop over 's'
    }// end loop over 'r'
    
    // Delete pointer to array of derivatives on FIAT element
    delete [] derivatives;
    
    // Delete pointer to array of combinations of derivatives and transform
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      delete [] combinations[r];
    }// end loop over 'r'
    delete [] combinations;
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      delete [] transform[r];
    }// end loop over 'r'
    delete [] transform;
  }

  /// Evaluate order n derivatives of all basis functions at given point in cell
  virtual void evaluate_basis_derivatives_all(unsigned int n,
                                              double* values,
                                              const double* coordinates,
                                              const ufc::cell& c) const
  {
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    }// end loop over 'r'
    
    // Helper variable to hold values of a single dof.
    double *dof_values = new double[2*num_derivatives];
    for (unsigned int r = 0; r < 2*num_derivatives; r++)
    {
      dof_values[r] = 0.000000000000000;
    }// end loop over 'r'
    
    // Loop dofs and call evaluate_basis_derivatives.
    for (unsigned int r = 0; r < 15; r++)
    {
      evaluate_basis_derivatives(r, n, dof_values, coordinates, c);
      for (unsigned int s = 0; s < 2*num_derivatives; s++)
      {
        values[r*2*num_derivatives + s] = dof_values[s];
      }// end loop over 's'
    }// end loop over 'r'
    
    // Delete pointer.
    delete [] dof_values;
  }

  /// Evaluate linear functional for dof i on the function f
  virtual double evaluate_dof(unsigned int i,
                              const ufc::function& f,
                              const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[2];
    
    // Declare variable for physical coordinates.
    double y[2];
    double result;
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];switch (i)
    {
    case 0:
      {
        y[0] = 0.750000000000000*x[1][0] + 0.250000000000000*x[2][0];
      y[1] = 0.750000000000000*x[1][1] + 0.250000000000000*x[2][1];
      f.evaluate(vals, y, c);
      result = (-1.0)*(J_00*vals[0] + J_10*vals[1]) + (J_01*vals[0] + J_11*vals[1]);
      return result;
        break;
      }
    case 1:
      {
        y[0] = 0.500000000000000*x[1][0] + 0.500000000000000*x[2][0];
      y[1] = 0.500000000000000*x[1][1] + 0.500000000000000*x[2][1];
      f.evaluate(vals, y, c);
      result = (-1.0)*(J_00*vals[0] + J_10*vals[1]) + (J_01*vals[0] + J_11*vals[1]);
      return result;
        break;
      }
    case 2:
      {
        y[0] = 0.250000000000000*x[1][0] + 0.750000000000000*x[2][0];
      y[1] = 0.250000000000000*x[1][1] + 0.750000000000000*x[2][1];
      f.evaluate(vals, y, c);
      result = (-1.0)*(J_00*vals[0] + J_10*vals[1]) + (J_01*vals[0] + J_11*vals[1]);
      return result;
        break;
      }
    case 3:
      {
        y[0] = 0.750000000000000*x[0][0] + 0.250000000000000*x[2][0];
      y[1] = 0.750000000000000*x[0][1] + 0.250000000000000*x[2][1];
      f.evaluate(vals, y, c);
      result = (J_01*vals[0] + J_11*vals[1]);
      return result;
        break;
      }
    case 4:
      {
        y[0] = 0.500000000000000*x[0][0] + 0.500000000000000*x[2][0];
      y[1] = 0.500000000000000*x[0][1] + 0.500000000000000*x[2][1];
      f.evaluate(vals, y, c);
      result = (J_01*vals[0] + J_11*vals[1]);
      return result;
        break;
      }
    case 5:
      {
        y[0] = 0.250000000000000*x[0][0] + 0.750000000000000*x[2][0];
      y[1] = 0.250000000000000*x[0][1] + 0.750000000000000*x[2][1];
      f.evaluate(vals, y, c);
      result = (J_01*vals[0] + J_11*vals[1]);
      return result;
        break;
      }
    case 6:
      {
        y[0] = 0.750000000000000*x[0][0] + 0.250000000000000*x[1][0];
      y[1] = 0.750000000000000*x[0][1] + 0.250000000000000*x[1][1];
      f.evaluate(vals, y, c);
      result = (J_00*vals[0] + J_10*vals[1]);
      return result;
        break;
      }
    case 7:
      {
        y[0] = 0.500000000000000*x[0][0] + 0.500000000000000*x[1][0];
      y[1] = 0.500000000000000*x[0][1] + 0.500000000000000*x[1][1];
      f.evaluate(vals, y, c);
      result = (J_00*vals[0] + J_10*vals[1]);
      return result;
        break;
      }
    case 8:
      {
        y[0] = 0.250000000000000*x[0][0] + 0.750000000000000*x[1][0];
      y[1] = 0.250000000000000*x[0][1] + 0.750000000000000*x[1][1];
      f.evaluate(vals, y, c);
      result = (J_00*vals[0] + J_10*vals[1]);
      return result;
        break;
      }
    case 9:
      {
        result = 0.0;
      double X_9[36][2] = {{0.823156067319, 0.148078599668}, {0.0287653330126, 0.148078599668}, {0.369529924372, 0.0293164271598}, {0.0390907007328, 0.76923386203}, {0.0278110821154, 0.92694567132}, {0.366569507766, 0.558671518772}, {0.550703627938, 0.336984690281}, {0.14431148695, 0.148078599668}, {0.00246669715267, 0.92694567132}, {0.0606792682628, 0.92694567132}, {0.707609913381, 0.148078599668}, {0.00779187470129, 0.76923386203}, {0.640628436741, 0.336984690281}, {0.806254331245, 0.0293164271598}, {0.273318962107, 0.558671518772}, {0.087850454976, 0.76923386203}, {0.222974263269, 0.76923386203}, {0.0705876315276, 0.92694567132}, {0.0123750604174, 0.92694567132}, {0.191675437237, 0.76923386203}, {0.0327753666145, 0.0293164271598}, {0.142915682994, 0.76923386203}, {0.112311681781, 0.336984690281}, {0.0149015633667, 0.558671518772}, {0.168009519121, 0.558671518772}, {0.252403568077, 0.336984690281}, {0.601153648468, 0.0293164271598}, {0.527603095743, 0.148078599668}, {0.410611741642, 0.336984690281}, {0.164429241595, 0.0293164271598}, {0.0747589734626, 0.558671518772}, {0.937908206226, 0.0293164271598}, {0.324318304589, 0.148078599668}, {0.426426917862, 0.558671518772}, {0.0452432465649, 0.92694567132}, {0.022386872978, 0.336984690281}};
      int D_9[36][1] = {{0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}};
      double W_9[36][1] = {{0.00821012828325}, {0.00821012828325}, {0.0119624829871}, {0.0056064144375}, {0.00144559962225}, {0.0125840795694}, {0.0179578758575}, {0.0172882391377}, {0.000529299521057}, {0.00111455709092}, {0.0172882391377}, {0.00266246789938}, {0.00852813657368}, {0.00922307258049}, {0.0163217665744}, {0.00727161547759}, {0.00266246789938}, {0.000529299521057}, {0.00111455709092}, {0.0056064144375}, {0.00438000703533}, {0.00727161547759}, {0.0179578758575}, {0.00597613827346}, {0.0163217665744}, {0.023291672331}, {0.0119624829871}, {0.0224231420448}, {0.023291672331}, {0.00922307258049}, {0.0125840795694}, {0.00438000703533}, {0.0224231420448}, {0.00597613827346}, {0.00144559962225}, {0.00852813657368}};
      double copy_9[2];
      // Loop over points.
      for (unsigned int r = 0; r < 36; r++)
      {
        // Evaluate basis functions for affine mapping
        const double w0 = 1.0 - X_9[r][0] - X_9[r][1];
        const double w1 = X_9[r][0];
        const double w2 = X_9[r][1];
        
        // Compute affine mapping y = F(X)
        y[0] = w0*x[0][0] + w1*x[1][0] + w2*x[2][0];
        y[1] = w0*x[0][1] + w1*x[1][1] + w2*x[2][1];
        // Evaluate function at physical point.
        f.evaluate(vals, y, c);
        // Map function to reference element.
        copy_9[0] = J_00*vals[0] + J_10*vals[1];
        copy_9[1] = J_01*vals[0] + J_11*vals[1];
        // Loop over directions.
        for (unsigned int s = 0; s < 1; s++)
        {
          result += copy_9[D_9[r][s]]*W_9[r][s];
        }// end loop over 's'
      }// end loop over 'r'
      return result;
        break;
      }
    case 10:
      {
        result = 0.0;
      double X_10[36][2] = {{0.823156067319, 0.148078599668}, {0.0287653330126, 0.148078599668}, {0.369529924372, 0.0293164271598}, {0.0390907007328, 0.76923386203}, {0.0278110821154, 0.92694567132}, {0.366569507766, 0.558671518772}, {0.550703627938, 0.336984690281}, {0.14431148695, 0.148078599668}, {0.00246669715267, 0.92694567132}, {0.0606792682628, 0.92694567132}, {0.707609913381, 0.148078599668}, {0.00779187470129, 0.76923386203}, {0.640628436741, 0.336984690281}, {0.806254331245, 0.0293164271598}, {0.273318962107, 0.558671518772}, {0.087850454976, 0.76923386203}, {0.222974263269, 0.76923386203}, {0.0705876315276, 0.92694567132}, {0.0123750604174, 0.92694567132}, {0.191675437237, 0.76923386203}, {0.0327753666145, 0.0293164271598}, {0.142915682994, 0.76923386203}, {0.112311681781, 0.336984690281}, {0.0149015633667, 0.558671518772}, {0.168009519121, 0.558671518772}, {0.252403568077, 0.336984690281}, {0.601153648468, 0.0293164271598}, {0.527603095743, 0.148078599668}, {0.410611741642, 0.336984690281}, {0.164429241595, 0.0293164271598}, {0.0747589734626, 0.558671518772}, {0.937908206226, 0.0293164271598}, {0.324318304589, 0.148078599668}, {0.426426917862, 0.558671518772}, {0.0452432465649, 0.92694567132}, {0.022386872978, 0.336984690281}};
      int D_10[36][1] = {{0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}};
      double W_10[36][1] = {{0.0159756941744}, {-0.0159756941744}, {-0.00678703358623}, {-0.00209542400951}, {-6.17269708946e-05}, {0.0089949353583}, {0.0192838239128}, {-0.0238542037517}, {-8.83197279225e-05}, {0.000131875132445}, {0.0238542037517}, {-0.00140335236045}, {0.0129148084988}, {0.014499997977}, {0.00421027151037}, {-0.000980807938907}, {0.00140335236045}, {8.83197279225e-05}, {-0.000131875132445}, {0.00209542400951}, {-0.00971097319454}, {0.000980807938907}, {-0.0192838239128}, {-0.00602410954055}, {-0.00421027151037}, {-0.00902620543637}, {0.00678703358623}, {0.0111654692844}, {0.00902620543637}, {-0.014499997977}, {-0.0089949353583}, {0.00971097319454}, {-0.0111654692844}, {0.00602410954055}, {6.17269708946e-05}, {-0.0129148084988}};
      double copy_10[2];
      // Loop over points.
      for (unsigned int r = 0; r < 36; r++)
      {
        // Evaluate basis functions for affine mapping
        const double w0 = 1.0 - X_10[r][0] - X_10[r][1];
        const double w1 = X_10[r][0];
        const double w2 = X_10[r][1];
        
        // Compute affine mapping y = F(X)
        y[0] = w0*x[0][0] + w1*x[1][0] + w2*x[2][0];
        y[1] = w0*x[0][1] + w1*x[1][1] + w2*x[2][1];
        // Evaluate function at physical point.
        f.evaluate(vals, y, c);
        // Map function to reference element.
        copy_10[0] = J_00*vals[0] + J_10*vals[1];
        copy_10[1] = J_01*vals[0] + J_11*vals[1];
        // Loop over directions.
        for (unsigned int s = 0; s < 1; s++)
        {
          result += copy_10[D_10[r][s]]*W_10[r][s];
        }// end loop over 's'
      }// end loop over 'r'
      return result;
        break;
      }
    case 11:
      {
        result = 0.0;
      double X_11[36][2] = {{0.823156067319, 0.148078599668}, {0.0287653330126, 0.148078599668}, {0.369529924372, 0.0293164271598}, {0.0390907007328, 0.76923386203}, {0.0278110821154, 0.92694567132}, {0.366569507766, 0.558671518772}, {0.550703627938, 0.336984690281}, {0.14431148695, 0.148078599668}, {0.00246669715267, 0.92694567132}, {0.0606792682628, 0.92694567132}, {0.707609913381, 0.148078599668}, {0.00779187470129, 0.76923386203}, {0.640628436741, 0.336984690281}, {0.806254331245, 0.0293164271598}, {0.273318962107, 0.558671518772}, {0.087850454976, 0.76923386203}, {0.222974263269, 0.76923386203}, {0.0705876315276, 0.92694567132}, {0.0123750604174, 0.92694567132}, {0.191675437237, 0.76923386203}, {0.0327753666145, 0.0293164271598}, {0.142915682994, 0.76923386203}, {0.112311681781, 0.336984690281}, {0.0149015633667, 0.558671518772}, {0.168009519121, 0.558671518772}, {0.252403568077, 0.336984690281}, {0.601153648468, 0.0293164271598}, {0.527603095743, 0.148078599668}, {0.410611741642, 0.336984690281}, {0.164429241595, 0.0293164271598}, {0.0747589734626, 0.558671518772}, {0.937908206226, 0.0293164271598}, {0.324318304589, 0.148078599668}, {0.426426917862, 0.558671518772}, {0.0452432465649, 0.92694567132}, {0.022386872978, 0.336984690281}};
      int D_11[36][1] = {{0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}};
      double W_11[36][1] = {{-0.00645290853773}, {-0.00645290853773}, {-0.015429623211}, {0.010368330848}, {0.00364071931307}, {0.0120307444266}, {0.000278192558146}, {-0.0135880247038}, {0.00133303229957}, {0.00280699404177}, {-0.0135880247038}, {0.00492388644484}, {0.000132112736967}, {-0.0118962371707}, {0.0156040814239}, {0.0134479025608}, {0.00492388644484}, {0.00133303229957}, {0.00280699404177}, {0.010368330848}, {-0.0056494841656}, {0.0134479025608}, {0.000278192558146}, {0.00571336122195}, {0.0156040814239}, {0.0003608205091}, {-0.015429623211}, {-0.0176239005959}, {0.0003608205091}, {-0.0118962371707}, {0.0120307444266}, {-0.0056494841656}, {-0.0176239005959}, {0.00571336122195}, {0.00364071931307}, {0.000132112736967}};
      double copy_11[2];
      // Loop over points.
      for (unsigned int r = 0; r < 36; r++)
      {
        // Evaluate basis functions for affine mapping
        const double w0 = 1.0 - X_11[r][0] - X_11[r][1];
        const double w1 = X_11[r][0];
        const double w2 = X_11[r][1];
        
        // Compute affine mapping y = F(X)
        y[0] = w0*x[0][0] + w1*x[1][0] + w2*x[2][0];
        y[1] = w0*x[0][1] + w1*x[1][1] + w2*x[2][1];
        // Evaluate function at physical point.
        f.evaluate(vals, y, c);
        // Map function to reference element.
        copy_11[0] = J_00*vals[0] + J_10*vals[1];
        copy_11[1] = J_01*vals[0] + J_11*vals[1];
        // Loop over directions.
        for (unsigned int s = 0; s < 1; s++)
        {
          result += copy_11[D_11[r][s]]*W_11[r][s];
        }// end loop over 's'
      }// end loop over 'r'
      return result;
        break;
      }
    case 12:
      {
        result = 0.0;
      double X_12[36][2] = {{0.823156067319, 0.148078599668}, {0.0287653330126, 0.148078599668}, {0.369529924372, 0.0293164271598}, {0.0390907007328, 0.76923386203}, {0.0278110821154, 0.92694567132}, {0.366569507766, 0.558671518772}, {0.550703627938, 0.336984690281}, {0.14431148695, 0.148078599668}, {0.00246669715267, 0.92694567132}, {0.0606792682628, 0.92694567132}, {0.707609913381, 0.148078599668}, {0.00779187470129, 0.76923386203}, {0.640628436741, 0.336984690281}, {0.806254331245, 0.0293164271598}, {0.273318962107, 0.558671518772}, {0.087850454976, 0.76923386203}, {0.222974263269, 0.76923386203}, {0.0705876315276, 0.92694567132}, {0.0123750604174, 0.92694567132}, {0.191675437237, 0.76923386203}, {0.0327753666145, 0.0293164271598}, {0.142915682994, 0.76923386203}, {0.112311681781, 0.336984690281}, {0.0149015633667, 0.558671518772}, {0.168009519121, 0.558671518772}, {0.252403568077, 0.336984690281}, {0.601153648468, 0.0293164271598}, {0.527603095743, 0.148078599668}, {0.410611741642, 0.336984690281}, {0.164429241595, 0.0293164271598}, {0.0747589734626, 0.558671518772}, {0.937908206226, 0.0293164271598}, {0.324318304589, 0.148078599668}, {0.426426917862, 0.558671518772}, {0.0452432465649, 0.92694567132}, {0.022386872978, 0.336984690281}};
      int D_12[36][1] = {{1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}};
      double W_12[36][1] = {{0.00821012828325}, {0.00821012828325}, {0.0119624829871}, {0.0056064144375}, {0.00144559962225}, {0.0125840795694}, {0.0179578758575}, {0.0172882391377}, {0.000529299521057}, {0.00111455709092}, {0.0172882391377}, {0.00266246789938}, {0.00852813657368}, {0.00922307258049}, {0.0163217665744}, {0.00727161547759}, {0.00266246789938}, {0.000529299521057}, {0.00111455709092}, {0.0056064144375}, {0.00438000703533}, {0.00727161547759}, {0.0179578758575}, {0.00597613827346}, {0.0163217665744}, {0.023291672331}, {0.0119624829871}, {0.0224231420448}, {0.023291672331}, {0.00922307258049}, {0.0125840795694}, {0.00438000703533}, {0.0224231420448}, {0.00597613827346}, {0.00144559962225}, {0.00852813657368}};
      double copy_12[2];
      // Loop over points.
      for (unsigned int r = 0; r < 36; r++)
      {
        // Evaluate basis functions for affine mapping
        const double w0 = 1.0 - X_12[r][0] - X_12[r][1];
        const double w1 = X_12[r][0];
        const double w2 = X_12[r][1];
        
        // Compute affine mapping y = F(X)
        y[0] = w0*x[0][0] + w1*x[1][0] + w2*x[2][0];
        y[1] = w0*x[0][1] + w1*x[1][1] + w2*x[2][1];
        // Evaluate function at physical point.
        f.evaluate(vals, y, c);
        // Map function to reference element.
        copy_12[0] = J_00*vals[0] + J_10*vals[1];
        copy_12[1] = J_01*vals[0] + J_11*vals[1];
        // Loop over directions.
        for (unsigned int s = 0; s < 1; s++)
        {
          result += copy_12[D_12[r][s]]*W_12[r][s];
        }// end loop over 's'
      }// end loop over 'r'
      return result;
        break;
      }
    case 13:
      {
        result = 0.0;
      double X_13[36][2] = {{0.823156067319, 0.148078599668}, {0.0287653330126, 0.148078599668}, {0.369529924372, 0.0293164271598}, {0.0390907007328, 0.76923386203}, {0.0278110821154, 0.92694567132}, {0.366569507766, 0.558671518772}, {0.550703627938, 0.336984690281}, {0.14431148695, 0.148078599668}, {0.00246669715267, 0.92694567132}, {0.0606792682628, 0.92694567132}, {0.707609913381, 0.148078599668}, {0.00779187470129, 0.76923386203}, {0.640628436741, 0.336984690281}, {0.806254331245, 0.0293164271598}, {0.273318962107, 0.558671518772}, {0.087850454976, 0.76923386203}, {0.222974263269, 0.76923386203}, {0.0705876315276, 0.92694567132}, {0.0123750604174, 0.92694567132}, {0.191675437237, 0.76923386203}, {0.0327753666145, 0.0293164271598}, {0.142915682994, 0.76923386203}, {0.112311681781, 0.336984690281}, {0.0149015633667, 0.558671518772}, {0.168009519121, 0.558671518772}, {0.252403568077, 0.336984690281}, {0.601153648468, 0.0293164271598}, {0.527603095743, 0.148078599668}, {0.410611741642, 0.336984690281}, {0.164429241595, 0.0293164271598}, {0.0747589734626, 0.558671518772}, {0.937908206226, 0.0293164271598}, {0.324318304589, 0.148078599668}, {0.426426917862, 0.558671518772}, {0.0452432465649, 0.92694567132}, {0.022386872978, 0.336984690281}};
      int D_13[36][1] = {{1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}};
      double W_13[36][1] = {{0.0159756941744}, {-0.0159756941744}, {-0.00678703358623}, {-0.00209542400951}, {-6.17269708946e-05}, {0.0089949353583}, {0.0192838239128}, {-0.0238542037517}, {-8.83197279225e-05}, {0.000131875132445}, {0.0238542037517}, {-0.00140335236045}, {0.0129148084988}, {0.014499997977}, {0.00421027151037}, {-0.000980807938907}, {0.00140335236045}, {8.83197279225e-05}, {-0.000131875132445}, {0.00209542400951}, {-0.00971097319454}, {0.000980807938907}, {-0.0192838239128}, {-0.00602410954055}, {-0.00421027151037}, {-0.00902620543637}, {0.00678703358623}, {0.0111654692844}, {0.00902620543637}, {-0.014499997977}, {-0.0089949353583}, {0.00971097319454}, {-0.0111654692844}, {0.00602410954055}, {6.17269708946e-05}, {-0.0129148084988}};
      double copy_13[2];
      // Loop over points.
      for (unsigned int r = 0; r < 36; r++)
      {
        // Evaluate basis functions for affine mapping
        const double w0 = 1.0 - X_13[r][0] - X_13[r][1];
        const double w1 = X_13[r][0];
        const double w2 = X_13[r][1];
        
        // Compute affine mapping y = F(X)
        y[0] = w0*x[0][0] + w1*x[1][0] + w2*x[2][0];
        y[1] = w0*x[0][1] + w1*x[1][1] + w2*x[2][1];
        // Evaluate function at physical point.
        f.evaluate(vals, y, c);
        // Map function to reference element.
        copy_13[0] = J_00*vals[0] + J_10*vals[1];
        copy_13[1] = J_01*vals[0] + J_11*vals[1];
        // Loop over directions.
        for (unsigned int s = 0; s < 1; s++)
        {
          result += copy_13[D_13[r][s]]*W_13[r][s];
        }// end loop over 's'
      }// end loop over 'r'
      return result;
        break;
      }
    case 14:
      {
        result = 0.0;
      double X_14[36][2] = {{0.823156067319, 0.148078599668}, {0.0287653330126, 0.148078599668}, {0.369529924372, 0.0293164271598}, {0.0390907007328, 0.76923386203}, {0.0278110821154, 0.92694567132}, {0.366569507766, 0.558671518772}, {0.550703627938, 0.336984690281}, {0.14431148695, 0.148078599668}, {0.00246669715267, 0.92694567132}, {0.0606792682628, 0.92694567132}, {0.707609913381, 0.148078599668}, {0.00779187470129, 0.76923386203}, {0.640628436741, 0.336984690281}, {0.806254331245, 0.0293164271598}, {0.273318962107, 0.558671518772}, {0.087850454976, 0.76923386203}, {0.222974263269, 0.76923386203}, {0.0705876315276, 0.92694567132}, {0.0123750604174, 0.92694567132}, {0.191675437237, 0.76923386203}, {0.0327753666145, 0.0293164271598}, {0.142915682994, 0.76923386203}, {0.112311681781, 0.336984690281}, {0.0149015633667, 0.558671518772}, {0.168009519121, 0.558671518772}, {0.252403568077, 0.336984690281}, {0.601153648468, 0.0293164271598}, {0.527603095743, 0.148078599668}, {0.410611741642, 0.336984690281}, {0.164429241595, 0.0293164271598}, {0.0747589734626, 0.558671518772}, {0.937908206226, 0.0293164271598}, {0.324318304589, 0.148078599668}, {0.426426917862, 0.558671518772}, {0.0452432465649, 0.92694567132}, {0.022386872978, 0.336984690281}};
      int D_14[36][1] = {{1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}};
      double W_14[36][1] = {{-0.00645290853773}, {-0.00645290853773}, {-0.015429623211}, {0.010368330848}, {0.00364071931307}, {0.0120307444266}, {0.000278192558146}, {-0.0135880247038}, {0.00133303229957}, {0.00280699404177}, {-0.0135880247038}, {0.00492388644484}, {0.000132112736967}, {-0.0118962371707}, {0.0156040814239}, {0.0134479025608}, {0.00492388644484}, {0.00133303229957}, {0.00280699404177}, {0.010368330848}, {-0.0056494841656}, {0.0134479025608}, {0.000278192558146}, {0.00571336122195}, {0.0156040814239}, {0.0003608205091}, {-0.015429623211}, {-0.0176239005959}, {0.0003608205091}, {-0.0118962371707}, {0.0120307444266}, {-0.0056494841656}, {-0.0176239005959}, {0.00571336122195}, {0.00364071931307}, {0.000132112736967}};
      double copy_14[2];
      // Loop over points.
      for (unsigned int r = 0; r < 36; r++)
      {
        // Evaluate basis functions for affine mapping
        const double w0 = 1.0 - X_14[r][0] - X_14[r][1];
        const double w1 = X_14[r][0];
        const double w2 = X_14[r][1];
        
        // Compute affine mapping y = F(X)
        y[0] = w0*x[0][0] + w1*x[1][0] + w2*x[2][0];
        y[1] = w0*x[0][1] + w1*x[1][1] + w2*x[2][1];
        // Evaluate function at physical point.
        f.evaluate(vals, y, c);
        // Map function to reference element.
        copy_14[0] = J_00*vals[0] + J_10*vals[1];
        copy_14[1] = J_01*vals[0] + J_11*vals[1];
        // Loop over directions.
        for (unsigned int s = 0; s < 1; s++)
        {
          result += copy_14[D_14[r][s]]*W_14[r][s];
        }// end loop over 's'
      }// end loop over 'r'
      return result;
        break;
      }
    }
    
    return 0.000000000000000;
  }

  /// Evaluate linear functionals for all dofs on the function f
  virtual void evaluate_dofs(double* values,
                             const ufc::function& f,
                             const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[2];
    
    // Declare variable for physical coordinates.
    double y[2];
    double result;
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];y[0] = 0.750000000000000*x[1][0] + 0.250000000000000*x[2][0];
    y[1] = 0.750000000000000*x[1][1] + 0.250000000000000*x[2][1];
    f.evaluate(vals, y, c);
    result = (-1.0)*(J_00*vals[0] + J_10*vals[1]) + (J_01*vals[0] + J_11*vals[1]);
    values[0] = result;
    y[0] = 0.500000000000000*x[1][0] + 0.500000000000000*x[2][0];
    y[1] = 0.500000000000000*x[1][1] + 0.500000000000000*x[2][1];
    f.evaluate(vals, y, c);
    result = (-1.0)*(J_00*vals[0] + J_10*vals[1]) + (J_01*vals[0] + J_11*vals[1]);
    values[1] = result;
    y[0] = 0.250000000000000*x[1][0] + 0.750000000000000*x[2][0];
    y[1] = 0.250000000000000*x[1][1] + 0.750000000000000*x[2][1];
    f.evaluate(vals, y, c);
    result = (-1.0)*(J_00*vals[0] + J_10*vals[1]) + (J_01*vals[0] + J_11*vals[1]);
    values[2] = result;
    y[0] = 0.750000000000000*x[0][0] + 0.250000000000000*x[2][0];
    y[1] = 0.750000000000000*x[0][1] + 0.250000000000000*x[2][1];
    f.evaluate(vals, y, c);
    result = (J_01*vals[0] + J_11*vals[1]);
    values[3] = result;
    y[0] = 0.500000000000000*x[0][0] + 0.500000000000000*x[2][0];
    y[1] = 0.500000000000000*x[0][1] + 0.500000000000000*x[2][1];
    f.evaluate(vals, y, c);
    result = (J_01*vals[0] + J_11*vals[1]);
    values[4] = result;
    y[0] = 0.250000000000000*x[0][0] + 0.750000000000000*x[2][0];
    y[1] = 0.250000000000000*x[0][1] + 0.750000000000000*x[2][1];
    f.evaluate(vals, y, c);
    result = (J_01*vals[0] + J_11*vals[1]);
    values[5] = result;
    y[0] = 0.750000000000000*x[0][0] + 0.250000000000000*x[1][0];
    y[1] = 0.750000000000000*x[0][1] + 0.250000000000000*x[1][1];
    f.evaluate(vals, y, c);
    result = (J_00*vals[0] + J_10*vals[1]);
    values[6] = result;
    y[0] = 0.500000000000000*x[0][0] + 0.500000000000000*x[1][0];
    y[1] = 0.500000000000000*x[0][1] + 0.500000000000000*x[1][1];
    f.evaluate(vals, y, c);
    result = (J_00*vals[0] + J_10*vals[1]);
    values[7] = result;
    y[0] = 0.250000000000000*x[0][0] + 0.750000000000000*x[1][0];
    y[1] = 0.250000000000000*x[0][1] + 0.750000000000000*x[1][1];
    f.evaluate(vals, y, c);
    result = (J_00*vals[0] + J_10*vals[1]);
    values[8] = result;
    result = 0.0;
    double X_9[36][2] = {{0.823156067319, 0.148078599668}, {0.0287653330126, 0.148078599668}, {0.369529924372, 0.0293164271598}, {0.0390907007328, 0.76923386203}, {0.0278110821154, 0.92694567132}, {0.366569507766, 0.558671518772}, {0.550703627938, 0.336984690281}, {0.14431148695, 0.148078599668}, {0.00246669715267, 0.92694567132}, {0.0606792682628, 0.92694567132}, {0.707609913381, 0.148078599668}, {0.00779187470129, 0.76923386203}, {0.640628436741, 0.336984690281}, {0.806254331245, 0.0293164271598}, {0.273318962107, 0.558671518772}, {0.087850454976, 0.76923386203}, {0.222974263269, 0.76923386203}, {0.0705876315276, 0.92694567132}, {0.0123750604174, 0.92694567132}, {0.191675437237, 0.76923386203}, {0.0327753666145, 0.0293164271598}, {0.142915682994, 0.76923386203}, {0.112311681781, 0.336984690281}, {0.0149015633667, 0.558671518772}, {0.168009519121, 0.558671518772}, {0.252403568077, 0.336984690281}, {0.601153648468, 0.0293164271598}, {0.527603095743, 0.148078599668}, {0.410611741642, 0.336984690281}, {0.164429241595, 0.0293164271598}, {0.0747589734626, 0.558671518772}, {0.937908206226, 0.0293164271598}, {0.324318304589, 0.148078599668}, {0.426426917862, 0.558671518772}, {0.0452432465649, 0.92694567132}, {0.022386872978, 0.336984690281}};
    int D_9[36][1] = {{0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}};
    double W_9[36][1] = {{0.00821012828325}, {0.00821012828325}, {0.0119624829871}, {0.0056064144375}, {0.00144559962225}, {0.0125840795694}, {0.0179578758575}, {0.0172882391377}, {0.000529299521057}, {0.00111455709092}, {0.0172882391377}, {0.00266246789938}, {0.00852813657368}, {0.00922307258049}, {0.0163217665744}, {0.00727161547759}, {0.00266246789938}, {0.000529299521057}, {0.00111455709092}, {0.0056064144375}, {0.00438000703533}, {0.00727161547759}, {0.0179578758575}, {0.00597613827346}, {0.0163217665744}, {0.023291672331}, {0.0119624829871}, {0.0224231420448}, {0.023291672331}, {0.00922307258049}, {0.0125840795694}, {0.00438000703533}, {0.0224231420448}, {0.00597613827346}, {0.00144559962225}, {0.00852813657368}};
    double copy_9[2];
    // Loop over points.
    for (unsigned int r = 0; r < 36; r++)
    {
      // Evaluate basis functions for affine mapping
      const double w0 = 1.0 - X_9[r][0] - X_9[r][1];
      const double w1 = X_9[r][0];
      const double w2 = X_9[r][1];
      
      // Compute affine mapping y = F(X)
      y[0] = w0*x[0][0] + w1*x[1][0] + w2*x[2][0];
      y[1] = w0*x[0][1] + w1*x[1][1] + w2*x[2][1];
      // Evaluate function at physical point.
      f.evaluate(vals, y, c);
      // Map function to reference element.
      copy_9[0] = J_00*vals[0] + J_10*vals[1];
      copy_9[1] = J_01*vals[0] + J_11*vals[1];
      // Loop over directions.
      for (unsigned int s = 0; s < 1; s++)
      {
        result += copy_9[D_9[r][s]]*W_9[r][s];
      }// end loop over 's'
    }// end loop over 'r'
    values[9] = result;
    result = 0.0;
    double X_10[36][2] = {{0.823156067319, 0.148078599668}, {0.0287653330126, 0.148078599668}, {0.369529924372, 0.0293164271598}, {0.0390907007328, 0.76923386203}, {0.0278110821154, 0.92694567132}, {0.366569507766, 0.558671518772}, {0.550703627938, 0.336984690281}, {0.14431148695, 0.148078599668}, {0.00246669715267, 0.92694567132}, {0.0606792682628, 0.92694567132}, {0.707609913381, 0.148078599668}, {0.00779187470129, 0.76923386203}, {0.640628436741, 0.336984690281}, {0.806254331245, 0.0293164271598}, {0.273318962107, 0.558671518772}, {0.087850454976, 0.76923386203}, {0.222974263269, 0.76923386203}, {0.0705876315276, 0.92694567132}, {0.0123750604174, 0.92694567132}, {0.191675437237, 0.76923386203}, {0.0327753666145, 0.0293164271598}, {0.142915682994, 0.76923386203}, {0.112311681781, 0.336984690281}, {0.0149015633667, 0.558671518772}, {0.168009519121, 0.558671518772}, {0.252403568077, 0.336984690281}, {0.601153648468, 0.0293164271598}, {0.527603095743, 0.148078599668}, {0.410611741642, 0.336984690281}, {0.164429241595, 0.0293164271598}, {0.0747589734626, 0.558671518772}, {0.937908206226, 0.0293164271598}, {0.324318304589, 0.148078599668}, {0.426426917862, 0.558671518772}, {0.0452432465649, 0.92694567132}, {0.022386872978, 0.336984690281}};
    int D_10[36][1] = {{0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}};
    double W_10[36][1] = {{0.0159756941744}, {-0.0159756941744}, {-0.00678703358623}, {-0.00209542400951}, {-6.17269708946e-05}, {0.0089949353583}, {0.0192838239128}, {-0.0238542037517}, {-8.83197279225e-05}, {0.000131875132445}, {0.0238542037517}, {-0.00140335236045}, {0.0129148084988}, {0.014499997977}, {0.00421027151037}, {-0.000980807938907}, {0.00140335236045}, {8.83197279225e-05}, {-0.000131875132445}, {0.00209542400951}, {-0.00971097319454}, {0.000980807938907}, {-0.0192838239128}, {-0.00602410954055}, {-0.00421027151037}, {-0.00902620543637}, {0.00678703358623}, {0.0111654692844}, {0.00902620543637}, {-0.014499997977}, {-0.0089949353583}, {0.00971097319454}, {-0.0111654692844}, {0.00602410954055}, {6.17269708946e-05}, {-0.0129148084988}};
    double copy_10[2];
    // Loop over points.
    for (unsigned int r = 0; r < 36; r++)
    {
      // Evaluate basis functions for affine mapping
      const double w0 = 1.0 - X_10[r][0] - X_10[r][1];
      const double w1 = X_10[r][0];
      const double w2 = X_10[r][1];
      
      // Compute affine mapping y = F(X)
      y[0] = w0*x[0][0] + w1*x[1][0] + w2*x[2][0];
      y[1] = w0*x[0][1] + w1*x[1][1] + w2*x[2][1];
      // Evaluate function at physical point.
      f.evaluate(vals, y, c);
      // Map function to reference element.
      copy_10[0] = J_00*vals[0] + J_10*vals[1];
      copy_10[1] = J_01*vals[0] + J_11*vals[1];
      // Loop over directions.
      for (unsigned int s = 0; s < 1; s++)
      {
        result += copy_10[D_10[r][s]]*W_10[r][s];
      }// end loop over 's'
    }// end loop over 'r'
    values[10] = result;
    result = 0.0;
    double X_11[36][2] = {{0.823156067319, 0.148078599668}, {0.0287653330126, 0.148078599668}, {0.369529924372, 0.0293164271598}, {0.0390907007328, 0.76923386203}, {0.0278110821154, 0.92694567132}, {0.366569507766, 0.558671518772}, {0.550703627938, 0.336984690281}, {0.14431148695, 0.148078599668}, {0.00246669715267, 0.92694567132}, {0.0606792682628, 0.92694567132}, {0.707609913381, 0.148078599668}, {0.00779187470129, 0.76923386203}, {0.640628436741, 0.336984690281}, {0.806254331245, 0.0293164271598}, {0.273318962107, 0.558671518772}, {0.087850454976, 0.76923386203}, {0.222974263269, 0.76923386203}, {0.0705876315276, 0.92694567132}, {0.0123750604174, 0.92694567132}, {0.191675437237, 0.76923386203}, {0.0327753666145, 0.0293164271598}, {0.142915682994, 0.76923386203}, {0.112311681781, 0.336984690281}, {0.0149015633667, 0.558671518772}, {0.168009519121, 0.558671518772}, {0.252403568077, 0.336984690281}, {0.601153648468, 0.0293164271598}, {0.527603095743, 0.148078599668}, {0.410611741642, 0.336984690281}, {0.164429241595, 0.0293164271598}, {0.0747589734626, 0.558671518772}, {0.937908206226, 0.0293164271598}, {0.324318304589, 0.148078599668}, {0.426426917862, 0.558671518772}, {0.0452432465649, 0.92694567132}, {0.022386872978, 0.336984690281}};
    int D_11[36][1] = {{0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}};
    double W_11[36][1] = {{-0.00645290853773}, {-0.00645290853773}, {-0.015429623211}, {0.010368330848}, {0.00364071931307}, {0.0120307444266}, {0.000278192558146}, {-0.0135880247038}, {0.00133303229957}, {0.00280699404177}, {-0.0135880247038}, {0.00492388644484}, {0.000132112736967}, {-0.0118962371707}, {0.0156040814239}, {0.0134479025608}, {0.00492388644484}, {0.00133303229957}, {0.00280699404177}, {0.010368330848}, {-0.0056494841656}, {0.0134479025608}, {0.000278192558146}, {0.00571336122195}, {0.0156040814239}, {0.0003608205091}, {-0.015429623211}, {-0.0176239005959}, {0.0003608205091}, {-0.0118962371707}, {0.0120307444266}, {-0.0056494841656}, {-0.0176239005959}, {0.00571336122195}, {0.00364071931307}, {0.000132112736967}};
    double copy_11[2];
    // Loop over points.
    for (unsigned int r = 0; r < 36; r++)
    {
      // Evaluate basis functions for affine mapping
      const double w0 = 1.0 - X_11[r][0] - X_11[r][1];
      const double w1 = X_11[r][0];
      const double w2 = X_11[r][1];
      
      // Compute affine mapping y = F(X)
      y[0] = w0*x[0][0] + w1*x[1][0] + w2*x[2][0];
      y[1] = w0*x[0][1] + w1*x[1][1] + w2*x[2][1];
      // Evaluate function at physical point.
      f.evaluate(vals, y, c);
      // Map function to reference element.
      copy_11[0] = J_00*vals[0] + J_10*vals[1];
      copy_11[1] = J_01*vals[0] + J_11*vals[1];
      // Loop over directions.
      for (unsigned int s = 0; s < 1; s++)
      {
        result += copy_11[D_11[r][s]]*W_11[r][s];
      }// end loop over 's'
    }// end loop over 'r'
    values[11] = result;
    result = 0.0;
    double X_12[36][2] = {{0.823156067319, 0.148078599668}, {0.0287653330126, 0.148078599668}, {0.369529924372, 0.0293164271598}, {0.0390907007328, 0.76923386203}, {0.0278110821154, 0.92694567132}, {0.366569507766, 0.558671518772}, {0.550703627938, 0.336984690281}, {0.14431148695, 0.148078599668}, {0.00246669715267, 0.92694567132}, {0.0606792682628, 0.92694567132}, {0.707609913381, 0.148078599668}, {0.00779187470129, 0.76923386203}, {0.640628436741, 0.336984690281}, {0.806254331245, 0.0293164271598}, {0.273318962107, 0.558671518772}, {0.087850454976, 0.76923386203}, {0.222974263269, 0.76923386203}, {0.0705876315276, 0.92694567132}, {0.0123750604174, 0.92694567132}, {0.191675437237, 0.76923386203}, {0.0327753666145, 0.0293164271598}, {0.142915682994, 0.76923386203}, {0.112311681781, 0.336984690281}, {0.0149015633667, 0.558671518772}, {0.168009519121, 0.558671518772}, {0.252403568077, 0.336984690281}, {0.601153648468, 0.0293164271598}, {0.527603095743, 0.148078599668}, {0.410611741642, 0.336984690281}, {0.164429241595, 0.0293164271598}, {0.0747589734626, 0.558671518772}, {0.937908206226, 0.0293164271598}, {0.324318304589, 0.148078599668}, {0.426426917862, 0.558671518772}, {0.0452432465649, 0.92694567132}, {0.022386872978, 0.336984690281}};
    int D_12[36][1] = {{1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}};
    double W_12[36][1] = {{0.00821012828325}, {0.00821012828325}, {0.0119624829871}, {0.0056064144375}, {0.00144559962225}, {0.0125840795694}, {0.0179578758575}, {0.0172882391377}, {0.000529299521057}, {0.00111455709092}, {0.0172882391377}, {0.00266246789938}, {0.00852813657368}, {0.00922307258049}, {0.0163217665744}, {0.00727161547759}, {0.00266246789938}, {0.000529299521057}, {0.00111455709092}, {0.0056064144375}, {0.00438000703533}, {0.00727161547759}, {0.0179578758575}, {0.00597613827346}, {0.0163217665744}, {0.023291672331}, {0.0119624829871}, {0.0224231420448}, {0.023291672331}, {0.00922307258049}, {0.0125840795694}, {0.00438000703533}, {0.0224231420448}, {0.00597613827346}, {0.00144559962225}, {0.00852813657368}};
    double copy_12[2];
    // Loop over points.
    for (unsigned int r = 0; r < 36; r++)
    {
      // Evaluate basis functions for affine mapping
      const double w0 = 1.0 - X_12[r][0] - X_12[r][1];
      const double w1 = X_12[r][0];
      const double w2 = X_12[r][1];
      
      // Compute affine mapping y = F(X)
      y[0] = w0*x[0][0] + w1*x[1][0] + w2*x[2][0];
      y[1] = w0*x[0][1] + w1*x[1][1] + w2*x[2][1];
      // Evaluate function at physical point.
      f.evaluate(vals, y, c);
      // Map function to reference element.
      copy_12[0] = J_00*vals[0] + J_10*vals[1];
      copy_12[1] = J_01*vals[0] + J_11*vals[1];
      // Loop over directions.
      for (unsigned int s = 0; s < 1; s++)
      {
        result += copy_12[D_12[r][s]]*W_12[r][s];
      }// end loop over 's'
    }// end loop over 'r'
    values[12] = result;
    result = 0.0;
    double X_13[36][2] = {{0.823156067319, 0.148078599668}, {0.0287653330126, 0.148078599668}, {0.369529924372, 0.0293164271598}, {0.0390907007328, 0.76923386203}, {0.0278110821154, 0.92694567132}, {0.366569507766, 0.558671518772}, {0.550703627938, 0.336984690281}, {0.14431148695, 0.148078599668}, {0.00246669715267, 0.92694567132}, {0.0606792682628, 0.92694567132}, {0.707609913381, 0.148078599668}, {0.00779187470129, 0.76923386203}, {0.640628436741, 0.336984690281}, {0.806254331245, 0.0293164271598}, {0.273318962107, 0.558671518772}, {0.087850454976, 0.76923386203}, {0.222974263269, 0.76923386203}, {0.0705876315276, 0.92694567132}, {0.0123750604174, 0.92694567132}, {0.191675437237, 0.76923386203}, {0.0327753666145, 0.0293164271598}, {0.142915682994, 0.76923386203}, {0.112311681781, 0.336984690281}, {0.0149015633667, 0.558671518772}, {0.168009519121, 0.558671518772}, {0.252403568077, 0.336984690281}, {0.601153648468, 0.0293164271598}, {0.527603095743, 0.148078599668}, {0.410611741642, 0.336984690281}, {0.164429241595, 0.0293164271598}, {0.0747589734626, 0.558671518772}, {0.937908206226, 0.0293164271598}, {0.324318304589, 0.148078599668}, {0.426426917862, 0.558671518772}, {0.0452432465649, 0.92694567132}, {0.022386872978, 0.336984690281}};
    int D_13[36][1] = {{1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}};
    double W_13[36][1] = {{0.0159756941744}, {-0.0159756941744}, {-0.00678703358623}, {-0.00209542400951}, {-6.17269708946e-05}, {0.0089949353583}, {0.0192838239128}, {-0.0238542037517}, {-8.83197279225e-05}, {0.000131875132445}, {0.0238542037517}, {-0.00140335236045}, {0.0129148084988}, {0.014499997977}, {0.00421027151037}, {-0.000980807938907}, {0.00140335236045}, {8.83197279225e-05}, {-0.000131875132445}, {0.00209542400951}, {-0.00971097319454}, {0.000980807938907}, {-0.0192838239128}, {-0.00602410954055}, {-0.00421027151037}, {-0.00902620543637}, {0.00678703358623}, {0.0111654692844}, {0.00902620543637}, {-0.014499997977}, {-0.0089949353583}, {0.00971097319454}, {-0.0111654692844}, {0.00602410954055}, {6.17269708946e-05}, {-0.0129148084988}};
    double copy_13[2];
    // Loop over points.
    for (unsigned int r = 0; r < 36; r++)
    {
      // Evaluate basis functions for affine mapping
      const double w0 = 1.0 - X_13[r][0] - X_13[r][1];
      const double w1 = X_13[r][0];
      const double w2 = X_13[r][1];
      
      // Compute affine mapping y = F(X)
      y[0] = w0*x[0][0] + w1*x[1][0] + w2*x[2][0];
      y[1] = w0*x[0][1] + w1*x[1][1] + w2*x[2][1];
      // Evaluate function at physical point.
      f.evaluate(vals, y, c);
      // Map function to reference element.
      copy_13[0] = J_00*vals[0] + J_10*vals[1];
      copy_13[1] = J_01*vals[0] + J_11*vals[1];
      // Loop over directions.
      for (unsigned int s = 0; s < 1; s++)
      {
        result += copy_13[D_13[r][s]]*W_13[r][s];
      }// end loop over 's'
    }// end loop over 'r'
    values[13] = result;
    result = 0.0;
    double X_14[36][2] = {{0.823156067319, 0.148078599668}, {0.0287653330126, 0.148078599668}, {0.369529924372, 0.0293164271598}, {0.0390907007328, 0.76923386203}, {0.0278110821154, 0.92694567132}, {0.366569507766, 0.558671518772}, {0.550703627938, 0.336984690281}, {0.14431148695, 0.148078599668}, {0.00246669715267, 0.92694567132}, {0.0606792682628, 0.92694567132}, {0.707609913381, 0.148078599668}, {0.00779187470129, 0.76923386203}, {0.640628436741, 0.336984690281}, {0.806254331245, 0.0293164271598}, {0.273318962107, 0.558671518772}, {0.087850454976, 0.76923386203}, {0.222974263269, 0.76923386203}, {0.0705876315276, 0.92694567132}, {0.0123750604174, 0.92694567132}, {0.191675437237, 0.76923386203}, {0.0327753666145, 0.0293164271598}, {0.142915682994, 0.76923386203}, {0.112311681781, 0.336984690281}, {0.0149015633667, 0.558671518772}, {0.168009519121, 0.558671518772}, {0.252403568077, 0.336984690281}, {0.601153648468, 0.0293164271598}, {0.527603095743, 0.148078599668}, {0.410611741642, 0.336984690281}, {0.164429241595, 0.0293164271598}, {0.0747589734626, 0.558671518772}, {0.937908206226, 0.0293164271598}, {0.324318304589, 0.148078599668}, {0.426426917862, 0.558671518772}, {0.0452432465649, 0.92694567132}, {0.022386872978, 0.336984690281}};
    int D_14[36][1] = {{1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}};
    double W_14[36][1] = {{-0.00645290853773}, {-0.00645290853773}, {-0.015429623211}, {0.010368330848}, {0.00364071931307}, {0.0120307444266}, {0.000278192558146}, {-0.0135880247038}, {0.00133303229957}, {0.00280699404177}, {-0.0135880247038}, {0.00492388644484}, {0.000132112736967}, {-0.0118962371707}, {0.0156040814239}, {0.0134479025608}, {0.00492388644484}, {0.00133303229957}, {0.00280699404177}, {0.010368330848}, {-0.0056494841656}, {0.0134479025608}, {0.000278192558146}, {0.00571336122195}, {0.0156040814239}, {0.0003608205091}, {-0.015429623211}, {-0.0176239005959}, {0.0003608205091}, {-0.0118962371707}, {0.0120307444266}, {-0.0056494841656}, {-0.0176239005959}, {0.00571336122195}, {0.00364071931307}, {0.000132112736967}};
    double copy_14[2];
    // Loop over points.
    for (unsigned int r = 0; r < 36; r++)
    {
      // Evaluate basis functions for affine mapping
      const double w0 = 1.0 - X_14[r][0] - X_14[r][1];
      const double w1 = X_14[r][0];
      const double w2 = X_14[r][1];
      
      // Compute affine mapping y = F(X)
      y[0] = w0*x[0][0] + w1*x[1][0] + w2*x[2][0];
      y[1] = w0*x[0][1] + w1*x[1][1] + w2*x[2][1];
      // Evaluate function at physical point.
      f.evaluate(vals, y, c);
      // Map function to reference element.
      copy_14[0] = J_00*vals[0] + J_10*vals[1];
      copy_14[1] = J_01*vals[0] + J_11*vals[1];
      // Loop over directions.
      for (unsigned int s = 0; s < 1; s++)
      {
        result += copy_14[D_14[r][s]]*W_14[r][s];
      }// end loop over 's'
    }// end loop over 'r'
    values[14] = result;
  }

  /// Interpolate vertex values from dof values
  virtual void interpolate_vertex_values(double* vertex_values,
                                         const double* dof_values,
                                         const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    const double K_00 =  J_11 / detJ;
    const double K_01 = -J_01 / detJ;
    const double K_10 = -J_10 / detJ;
    const double K_11 =  J_00 / detJ;
    // Evaluate function and change variables
    vertex_values[0] = dof_values[3]*K_10*3.0 + dof_values[4]*(K_10*(-3.0)) + dof_values[5]*K_10 + dof_values[6]*K_00*3.0 + dof_values[7]*(K_00*(-3.0)) + dof_values[8]*K_00;
    vertex_values[2] = dof_values[0]*K_10*3.0 + dof_values[1]*(K_10*(-3.0)) + dof_values[2]*K_10 + dof_values[6]*(K_00 + K_10) + dof_values[7]*(K_00*(-3.0) + K_10*(-3.0)) + dof_values[8]*(K_00*3.0 + K_10*3.0) + dof_values[9]*(K_10*(-1.70974345792e-14)) + dof_values[10]*(K_10*(-1.64868119157e-14)) + dof_values[11]*(K_10*(2.44249065418e-14)) + dof_values[12]*(K_10*(1.72639680329e-14)) + dof_values[13]*(K_10*(-1.01409075317e-14)) + dof_values[14]*(K_10*(2.21489493413e-14));
    vertex_values[4] = dof_values[0]*(K_00*(-1.0)) + dof_values[1]*K_00*3.0 + dof_values[2]*(K_00*(-3.0)) + dof_values[3]*(K_00 + K_10) + dof_values[4]*(K_00*(-3.0) + K_10*(-3.0)) + dof_values[5]*(K_00*3.0 + K_10*3.0) + dof_values[10]*(K_00*(-1.1854532055e-14)) + dof_values[11]*(K_00*(1.59872115546e-14)) + dof_values[12]*(K_00*(1.57977901428e-14)) + dof_values[14]*(K_00*(1.68449442414e-14));
    vertex_values[1] = dof_values[3]*K_11*3.0 + dof_values[4]*(K_11*(-3.0)) + dof_values[5]*K_11 + dof_values[6]*K_01*3.0 + dof_values[7]*(K_01*(-3.0)) + dof_values[8]*K_01;
    vertex_values[3] = dof_values[0]*K_11*3.0 + dof_values[1]*(K_11*(-3.0)) + dof_values[2]*K_11 + dof_values[6]*(K_01 + K_11) + dof_values[7]*(K_01*(-3.0) + K_11*(-3.0)) + dof_values[8]*(K_01*3.0 + K_11*3.0) + dof_values[9]*(K_11*(-1.70974345792e-14)) + dof_values[10]*(K_11*(-1.64868119157e-14)) + dof_values[11]*(K_11*(2.44249065418e-14)) + dof_values[12]*(K_11*(1.72639680329e-14)) + dof_values[13]*(K_11*(-1.01409075317e-14)) + dof_values[14]*(K_11*(2.21489493413e-14));
    vertex_values[5] = dof_values[0]*(K_01*(-1.0)) + dof_values[1]*K_01*3.0 + dof_values[2]*(K_01*(-3.0)) + dof_values[3]*(K_01 + K_11) + dof_values[4]*(K_01*(-3.0) + K_11*(-3.0)) + dof_values[5]*(K_01*3.0 + K_11*3.0) + dof_values[10]*(K_01*(-1.1854532055e-14)) + dof_values[11]*(K_01*(1.59872115546e-14)) + dof_values[12]*(K_01*(1.57977901428e-14)) + dof_values[14]*(K_01*(1.68449442414e-14));
  }

  /// Return the number of sub elements (for a mixed element)
  virtual unsigned int num_sub_elements() const
  {
    return 0;
  }

  /// Create a new finite element for sub element i (for a mixed element)
  virtual ufc::finite_element* create_sub_element(unsigned int i) const
  {
    return 0;
  }

};

/// This class defines the interface for a local-to-global mapping of
/// degrees of freedom (dofs).

class forms_dof_map_0: public ufc::dof_map
{
private:

  unsigned int _global_dimension;
public:

  /// Constructor
  forms_dof_map_0() : ufc::dof_map()
  {
    _global_dimension = 0;
  }

  /// Destructor
  virtual ~forms_dof_map_0()
  {
    // Do nothing
  }

  /// Return a string identifying the dof map
  virtual const char* signature() const
  {
    return "FFC dofmap for FiniteElement('Nedelec 1st kind H(curl)', Cell('triangle', 1, Space(2)), 3)";
  }

  /// Return true iff mesh entities of topological dimension d are needed
  virtual bool needs_mesh_entities(unsigned int d) const
  {
    switch (d)
    {
    case 0:
      {
        return false;
        break;
      }
    case 1:
      {
        return true;
        break;
      }
    case 2:
      {
        return true;
        break;
      }
    }
    
    return false;
  }

  /// Initialize dof map for mesh (return true iff init_cell() is needed)
  virtual bool init_mesh(const ufc::mesh& m)
  {
    _global_dimension = 3.000000000000000*m.num_entities[1] + 6.000000000000000*m.num_entities[2];
    return false;
  }

  /// Initialize dof map for given cell
  virtual void init_cell(const ufc::mesh& m,
                         const ufc::cell& c)
  {
    // Do nothing
  }

  /// Finish initialization of dof map for cells
  virtual void init_cell_finalize()
  {
    // Do nothing
  }

  /// Return the dimension of the global finite element function space
  virtual unsigned int global_dimension() const
  {
    return _global_dimension;
  }

  /// Return the dimension of the local finite element function space for a cell
  virtual unsigned int local_dimension(const ufc::cell& c) const
  {
    return 15;
  }

  /// Return the maximum dimension of the local finite element function space
  virtual unsigned int max_local_dimension() const
  {
    return 15;
  }

  // Return the geometric dimension of the coordinates this dof map provides
  virtual unsigned int geometric_dimension() const
  {
    return 2;
  }

  /// Return the number of dofs on each cell facet
  virtual unsigned int num_facet_dofs() const
  {
    return 3;
  }

  /// Return the number of dofs associated with each cell entity of dimension d
  virtual unsigned int num_entity_dofs(unsigned int d) const
  {
    switch (d)
    {
    case 0:
      {
        return 0;
        break;
      }
    case 1:
      {
        return 3;
        break;
      }
    case 2:
      {
        return 6;
        break;
      }
    }
    
    return 0;
  }

  /// Tabulate the local-to-global mapping of dofs on a cell
  virtual void tabulate_dofs(unsigned int* dofs,
                             const ufc::mesh& m,
                             const ufc::cell& c) const
  {
    unsigned int offset = 0;
    dofs[0] = offset + 3*c.entity_indices[1][0];
    dofs[1] = offset + 3*c.entity_indices[1][0] + 1;
    dofs[2] = offset + 3*c.entity_indices[1][0] + 2;
    dofs[3] = offset + 3*c.entity_indices[1][1];
    dofs[4] = offset + 3*c.entity_indices[1][1] + 1;
    dofs[5] = offset + 3*c.entity_indices[1][1] + 2;
    dofs[6] = offset + 3*c.entity_indices[1][2];
    dofs[7] = offset + 3*c.entity_indices[1][2] + 1;
    dofs[8] = offset + 3*c.entity_indices[1][2] + 2;
    offset += 3*m.num_entities[1];
    dofs[9] = offset + 6*c.entity_indices[2][0];
    dofs[10] = offset + 6*c.entity_indices[2][0] + 1;
    dofs[11] = offset + 6*c.entity_indices[2][0] + 2;
    dofs[12] = offset + 6*c.entity_indices[2][0] + 3;
    dofs[13] = offset + 6*c.entity_indices[2][0] + 4;
    dofs[14] = offset + 6*c.entity_indices[2][0] + 5;
    offset += 6*m.num_entities[2];
  }

  /// Tabulate the local-to-local mapping from facet dofs to cell dofs
  virtual void tabulate_facet_dofs(unsigned int* dofs,
                                   unsigned int facet) const
  {
    switch (facet)
    {
    case 0:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 2;
        break;
      }
    case 1:
      {
        dofs[0] = 3;
      dofs[1] = 4;
      dofs[2] = 5;
        break;
      }
    case 2:
      {
        dofs[0] = 6;
      dofs[1] = 7;
      dofs[2] = 8;
        break;
      }
    }
    
  }

  /// Tabulate the local-to-local mapping of dofs on entity (d, i)
  virtual void tabulate_entity_dofs(unsigned int* dofs,
                                    unsigned int d, unsigned int i) const
  {
    if (d > 2)
    {
    throw std::runtime_error("d is larger than dimension (2)");
    }
    
    switch (d)
    {
    case 0:
      {
        
        break;
      }
    case 1:
      {
        if (i > 2)
      {
      throw std::runtime_error("i is larger than number of entities (2)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 0;
        dofs[1] = 1;
        dofs[2] = 2;
          break;
        }
      case 1:
        {
          dofs[0] = 3;
        dofs[1] = 4;
        dofs[2] = 5;
          break;
        }
      case 2:
        {
          dofs[0] = 6;
        dofs[1] = 7;
        dofs[2] = 8;
          break;
        }
      }
      
        break;
      }
    case 2:
      {
        if (i > 0)
      {
      throw std::runtime_error("i is larger than number of entities (0)");
      }
      
      dofs[0] = 9;
      dofs[1] = 10;
      dofs[2] = 11;
      dofs[3] = 12;
      dofs[4] = 13;
      dofs[5] = 14;
        break;
      }
    }
    
  }

  /// Tabulate the coordinates of all dofs on a cell
  virtual void tabulate_coordinates(double** coordinates,
                                    const ufc::cell& c) const
  {
    throw std::runtime_error("tabulate_coordinates is not defined for this element");
  }

  /// Return the number of sub dof maps (for a mixed element)
  virtual unsigned int num_sub_dof_maps() const
  {
    return 0;
  }

  /// Create a new dof_map for sub dof map i (for a mixed element)
  virtual ufc::dof_map* create_sub_dof_map(unsigned int i) const
  {
    return 0;
  }

};

/// This class defines the interface for the tabulation of the cell
/// tensor corresponding to the local contribution to a form from
/// the integral over a cell.

class forms_cell_integral_0_0: public ufc::cell_integral
{
public:

  /// Constructor
  forms_cell_integral_0_0() : ufc::cell_integral()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~forms_cell_integral_0_0()
  {
    // Do nothing
  }

  /// Tabulate the tensor for the contribution from a local cell
  virtual void tabulate_tensor(double* A,
                               const double * const * w,
                               const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    const double K_00 =  J_11 / detJ;
    const double K_01 = -J_01 / detJ;
    const double K_10 = -J_10 / detJ;
    const double K_11 =  J_00 / detJ;
    
    // Set scale factor
    const double det = std::abs(detJ);
    
    // Array of quadrature weights.
    static const double W9[9] = {0.055814420483044, 0.063678085099885, 0.019396383305959, 0.089303072772871, 0.101884936159816, 0.031034213289535, 0.055814420483044, 0.063678085099885, 0.019396383305959};
    // Quadrature points on the UFC reference element: (0.102717654809626, 0.088587959512704), (0.066554067839165, 0.409466864440735), (0.023931132287081, 0.787659461760847), (0.455706020243648, 0.088587959512704), (0.295266567779633, 0.409466864440735), (0.106170269119576, 0.787659461760847), (0.808694385677670, 0.088587959512704), (0.523979067720101, 0.409466864440735), (0.188409405952072, 0.787659461760847)
    
    // Value of basis functions at quadrature points.
    static const double FE0_C0_D01[9][15] = \
    {{-0.632234065853990, 0.369377026105216, -1.196660275103391, 1.296449122756283, -1.697807139909800, 0.532445218201100, -11.426457493477411, 6.426842939553933, -1.924139666119427, 15.455195878680136, -30.067092719183957, -20.307330137623453, 3.757367767214435, 5.855694380900625, 6.642150569022691},
    {0.450621756164914, -0.577937279558464, 2.590688581812694, -1.882758775773212, 3.442211318775064, -1.158551562204395, 0.796903885161166, 0.719388048157268, 0.412211200346585, 1.512840603385472, 13.087487897814908, 31.060959128440643, -8.101390385226292, -4.692272070760118, -14.321370196082501},
    {-1.192655641139571, 5.831683929129603, -7.711926871359260, 2.344465351065526, -8.135303348981516, 6.560117161433302, 1.305805420774100, -0.218779538961619, -0.622387040332541, -10.005666807247831, 14.254533902349667, -11.845055491477371, 6.515619652201035, -5.283737983003074, 11.518097099259176},
    {0.774293014515856, 0.356230878553262, -0.363260944923044, -0.936904214017931, -0.031008479549108, 0.525872144425121, -3.125877453985553, -1.460897317940603, -2.336979448116747, 21.753481575393568, 8.823558445973598, -17.573152862195549, -0.919867854918343, -8.693054425180039, -1.626111995020715},
    {0.477448099138991, -1.871813442906817, 1.571683456918455, -0.243641912178877, 1.404201068986588, -1.805489643878570, 2.751696286561099, -1.947833168970063, 1.124640016073982, -4.953099212471939, 11.283468211835487, 23.351354834298924, 1.322607522262884, 1.752118156030342, 2.338061869601068},
    {-1.557863562634432, 4.821705013333133, -8.739034756893357, 4.241770615992714, -10.189519120049706, 6.055127703535071, 0.557854636812219, -0.142289921252600, 0.049074125920322, -16.800382362921667, 2.162198010932868, -18.635344829245710, 15.182471020031903, 3.759618459329404, 26.839070533581950},
    {-2.678610564253820, 2.585898881373395, -0.651268689928748, 1.689173108347378, -0.607023969560514, 1.640706145835187, 2.184283718343520, -3.367799841109576, -5.740238097276844, 17.479039974312379, 28.290869309237408, -11.100952002814351, -5.597103477051093, 15.604877372526715, -9.894374559064063},
    {-1.535792455418660, -2.224120268932834, 0.081893663363046, 3.435541848947186, -1.575378518124226, -1.981643056891577, 3.451062904864583, -2.104202819904500, 0.581643048704933, -15.857639450848840, 1.325218870400110, 17.211032769027675, 10.746605429752066, 24.504967693732670, 18.997493935284655},
    {-2.186839233580498, 3.933465058821835, -9.827012123070039, 6.402843630371106, -12.365473852403065, 5.611007726279423, -0.352414762196558, 0.258836926550210, 0.558216677126290, -24.168980885657817, -10.984428211516780, -25.222735898205435, 23.849322387862763, 14.911555563727578, 42.160043967904706}};
    
    static const double FE0_C0_D10[9][15] = \
    {{1.056939042493390, -0.237646943455295, 0.444045870731801, -1.382161441497539, 0.888091741463598, -0.118823471727646, -5.686219396200567, 9.794642780663517, -4.108423384462949, 3.573259381418819, 13.828653962580205, 0.687996424255014, -1.839735709836679, -9.749182991626107, -3.252223990041419},
    {3.886163605112102, -2.153315797682687, 0.609045524921116, -3.418551231191869, 1.218091049842228, -1.076657898841342, 0.215260836456234, 2.823590868061775, -3.038851704518005, 6.623874624482231, 38.917674461947726, -5.147567575871692, 2.645215044525782, -29.197239764492778, 4.676123739202115},
    {5.210187989231535, -6.533789923273452, -2.100919145079839, 0.157626117485029, -4.201838290159678, -3.266894961636718, 0.747588743647821, -0.477616465511824, -0.269972278135993, -9.686008309452751, 18.181661254560563, -28.782363561176631, 30.364942040063717, -20.195293546730635, 53.678141067163779},
    {-0.162611199502076, 0.325222399004152, 0.162611199502076, -0.162611199502076, 0.325222399004153, 0.162611199502075, -0.788898005868808, 0.000000000000000, 0.788898005868807, 0.919867854918340, 8.954062466767155, 1.626111995020704, -1.839735709836683, 0.000000000000000, -3.252223990041408},
    {0.233806186960116, -0.467612373920231, -0.233806186960116, 0.233806186960115, -0.467612373920231, -0.233806186960115, 1.627056270487115, 0.000000000000000, -1.627056270487120, -1.322607522262901, 24.319054579701305, -2.338061869601077, 2.645215044525787, 0.000000000000000, 4.676123739202150},
    {2.683907053358281, -5.367814106716565, -2.683907053358285, 2.683907053358282, -5.367814106716567, -2.683907053358276, 0.508780510891902, 0.000000000000000, -0.508780510891906, -15.182471020031867, 8.084014481195208, -26.839070533581918, 30.364942040063724, 0.000000000000015, 53.678141067163793},
    {-1.382161441497540, 0.888091741463596, -0.118823471727648, 1.056939042493387, -0.237646943455296, 0.444045870731798, 4.108423384462947, -9.794642780663516, 5.686219396200567, -1.733523671582154, 4.079470970954089, 2.564227565786401, -1.839735709836666, 9.749182991626107, -3.252223990041385},
    {-3.418551231191871, 1.218091049842224, -1.076657898841348, 3.886163605112100, -2.153315797682692, 0.609045524921112, 3.038851704517997, -2.823590868061769, -0.215260836456231, -9.269089669008041, 9.720434697454873, 0.471443836669541, 2.645215044525801, 29.197239764492782, 4.676123739202188},
    {0.157626117485027, -4.201838290159678, -3.266894961636731, 5.210187989231533, -6.533789923273456, -2.100919145079833, 0.269972278135985, 0.477616465511832, -0.747588743647818, -20.678933730610979, -2.013632292170133, -24.895777505987205, 30.364942040063728, 20.195293546730653, 53.678141067163821}};
    
    static const double FE0_C1_D01[9][15] = \
    {{-0.510516657342672, 0.310384264876772, -1.264706782073487, -5.490738616611100, 9.746479379223295, -4.255740762612196, -1.620031306977773, 1.021033314685345, -0.155192132438385, -2.010019048653603, -8.842407886277099, -8.209009222194190, 4.143190854657893, 8.557180335749024, 13.487255161274049},
    {-0.167459978257963, -0.197737403497518, -0.015450092433247, -1.892773232490957, 1.649285181778646, 0.243488050712310, -0.281778772439969, 0.334919956515925, 0.098868701748760, -1.506582525257668, -2.900491905771612, 0.302774252395542, 1.076633640961487, 4.809980525161425, 5.896481441293312},
    {0.009000708090062, -0.240131766274676, 0.335176868516342, 2.972288156085074, -9.243823316333986, 6.271535160248912, 0.224111693469066, -0.018001416180125, 0.120065883137337, -0.628279507436772, 0.155896837160856, 2.491324743647326, -0.294285992158447, 1.418268214801889, 0.915638885566155},
    {-0.334595820830523, 2.342170745813690, -3.680554029135817, 0.791201089495778, 1.858739121728755, -2.649940211224543, -2.844064477059499, 0.669191641661055, -1.171085372906843, 4.731899477318732, -5.795369616786739, -26.767665666441403, 4.731899477318807, 12.888434799146284, 35.707256735380930},
    {0.067439059269078, -0.472073414883554, 0.741829651959870, 1.630231343643366, -1.017936035348686, -0.612295308294680, 0.573232003787172, -0.134878118538157, 0.236036707441777, -0.953732322520115, 1.168078770686892, 5.395124741526144, -0.953732322520110, 10.812373328759163, 16.030017585050420},
    {0.144707781969610, -1.012954473787287, 1.591785601665746, 4.007138995432280, -9.167333698624970, 5.160194703192692, 1.230016146741713, -0.289415563939224, 0.506477236893642, -2.046477078423476, 2.506412306219630, 11.576622557568662, -2.046477078423501, 4.931052160477027, 2.752521597934118},
    {2.831743882844405, 5.869166660332010, -3.105982409035373, 0.344698344486408, -0.048163401440233, -0.296534943046181, 2.660344803975029, -5.663487765688786, -2.934583330166012, 32.619272598880315, 49.047242791086909, -30.374227774875269, -15.824846495609551, -21.626991341243851, 20.547022469954303},
    {1.557763879892565, -0.118696534721359, 2.754535179449430, 2.328527907810686, -1.174305686283128, -1.154222221527555, 4.252950791981316, -3.115527759785130, 0.059348267360676, 8.476318725256441, 26.981261861694584, 16.764604146138741, -11.861299131040717, 0.506306821445029, 10.470731440102478},
    {0.442733470896053, -1.704617873776449, 3.010712949862041, 4.676772950923971, -8.766206850822160, 4.089433899898195, 2.601137483869872, -0.885466941792113, 0.852308936888223, -2.316908715285534, 7.668368658032675, 21.473513446724436, -4.946434098813199, 6.335255444086461, 2.560421622215955}};
    
    static const double FE0_C1_D10[9][15] = \
    {{0.833958106518302, -0.248476303243517, 0.672534306807886, -11.001093063709311, 6.463211600264672, -1.801027043505571, 1.185623460133059, -1.274654609893861, 0.320868953193127, 2.902470557355847, 7.633087345643959, 2.959112034763297, 14.370933873216357, -28.674688378021514, -16.954141867744301},
    {0.939553962878541, -0.598810235338618, -0.842870927797272, -4.986329567802174, -0.456138552432834, -2.429153465374070, -0.804073553784227, -0.676404983364706, 0.900756588865495, 0.219471090054826, -4.557874024778450, -8.670416865675588, 23.684538201754279, -19.188680347126208, 14.423243936475489},
    {1.735071387537212, -3.839398767855606, 1.856750694897591, 0.342715451608515, -3.605740383735679, -6.566189912683181, 0.518203953231019, -1.162305284522461, 3.073618129203788, -7.571963823740469, -9.920599912747461, 9.587951742888583, 28.501470494517491, -7.158031904839250, 40.515261231254861},
    {-2.062701124344243, 0.452423144535834, -0.504741673486155, 1.900089924842159, -0.127200745531676, 0.667352872988232, -1.678170401849600, 2.799280601262721, -0.889272395980795, -6.637915288518959, -12.757930778352742, 1.371190259714389, -0.919867854918352, 34.469924023472629, -1.626111995020727},
    {-1.806434196553170, 1.950063689451731, -0.451364683624029, 2.040240383513281, -2.417676063371958, 0.217558496663913, -0.315371304845040, 1.678076931893753, -1.942427575332159, 0.769294722648726, 2.223213039106663, 1.130850364202669, 1.322607522262884, 19.872628501487974, 2.338061869601062},
    {0.379339402530052, -2.035139895212040, 2.486718602008140, 2.304567650828230, -3.332674211504526, -5.170625655366422, 1.687419257715047, -0.436541206625855, 1.178638746823147, -4.521519892380695, 0.990764309785272, 17.702041008735314, 15.182471020031862, 6.102485861624640, 26.839070533581907},
    {9.618931622211786, -5.575119858801100, 1.682203571777940, 0.222980935975087, 0.010829359788231, -0.228488436076107, 4.429292337656080, -11.069297390557381, 6.871842856333641, 15.539880758990002, 25.121072003331612, -11.430802267194537, -16.210669583052987, -18.925505386395407, 13.701917877702973},
    {1.567778336610309, 1.674229602275060, 1.352495566532721, 2.946609642233563, -1.554505562344079, 1.451916452718387, 3.939608293383488, -3.499995851426471, -1.019334390240463, 14.634919622801080, 33.466989069359563, 6.224270907469419, -21.039323157228491, 10.008559417366557, -9.747120197273306},
    {-0.185089334123490, -0.596097906423990, 3.299294951046446, 3.475116601694330, -2.694391155417859, -3.957669839977421, 3.343590407339761, -0.684688819010622, -0.229384790416804, 0.250572940166041, 15.064999525416546, 25.207435468156206, 1.863471545546242, 13.037261641891416, 13.162879835908969}};
    
    // Reset values in the element tensor.
    for (unsigned int r = 0; r < 225; r++)
    {
      A[r] = 0.000000000000000;
    }// end loop over 'r'
    
    // Compute element tensor using UFL quadrature representation
    // Optimisations: ('simplify expressions', False), ('ignore zero tables', False), ('non zero columns', False), ('remove zero terms', False), ('ignore ones', False)
    
    // Loop quadrature points for integral.
    // Number of operations to compute element tensor for following IP loop = 105300
    for (unsigned int ip = 0; ip < 9; ip++)
    {
      
      // Number of operations for primary indices: 11700
      for (unsigned int j = 0; j < 15; j++)
      {
        for (unsigned int k = 0; k < 15; k++)
        {
          // Number of operations to compute entry: 52
          A[j*15 + k] += (((K_00*K_01*FE0_C0_D10[ip][j] + K_00*K_11*FE0_C1_D10[ip][j] + K_10*K_01*FE0_C0_D01[ip][j] + K_10*K_11*FE0_C1_D01[ip][j]) + ((K_01*K_00*FE0_C0_D10[ip][j] + K_01*K_10*FE0_C1_D10[ip][j] + K_11*K_00*FE0_C0_D01[ip][j] + K_11*K_10*FE0_C1_D01[ip][j]))*(-1.000000000000000)))*(((K_00*K_01*FE0_C0_D10[ip][k] + K_00*K_11*FE0_C1_D10[ip][k] + K_10*K_01*FE0_C0_D01[ip][k] + K_10*K_11*FE0_C1_D01[ip][k]) + ((K_01*K_00*FE0_C0_D10[ip][k] + K_01*K_10*FE0_C1_D10[ip][k] + K_11*K_00*FE0_C0_D01[ip][k] + K_11*K_10*FE0_C1_D01[ip][k]))*(-1.000000000000000)))*W9[ip]*det;
        }// end loop over 'k'
      }// end loop over 'j'
    }// end loop over 'ip'
  }

};

/// This class defines the interface for the tabulation of the cell
/// tensor corresponding to the local contribution to a form from
/// the integral over a cell.

class forms_cell_integral_1_0: public ufc::cell_integral
{
public:

  /// Constructor
  forms_cell_integral_1_0() : ufc::cell_integral()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~forms_cell_integral_1_0()
  {
    // Do nothing
  }

  /// Tabulate the tensor for the contribution from a local cell
  virtual void tabulate_tensor(double* A,
                               const double * const * w,
                               const ufc::cell& c) const
  {
    // Number of operations (multiply-add pairs) for Jacobian data:      11
    // Number of operations (multiply-add pairs) for geometry tensor:    8
    // Number of operations (multiply-add pairs) for tensor contraction: 777
    // Total number of operations (multiply-add pairs):                  796
    
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    const double K_00 =  J_11 / detJ;
    const double K_01 = -J_01 / detJ;
    const double K_10 = -J_10 / detJ;
    const double K_11 =  J_00 / detJ;
    
    // Set scale factor
    const double det = std::abs(detJ);
    
    // Compute geometry tensor
    const double G0_0_0 = det*(K_00*K_00 + K_01*K_01);
    const double G0_0_1 = det*(K_00*K_10 + K_01*K_11);
    const double G0_1_0 = det*(K_10*K_00 + K_11*K_01);
    const double G0_1_1 = det*(K_10*K_10 + K_11*K_11);
    
    // Compute element tensor
    A[0] = 0.021626984126984*G0_0_0 - 0.011160714285714*G0_0_1 - 0.011160714285714*G0_1_0 + 0.057341269841270*G0_1_1;
    A[1] = -0.029861111111111*G0_0_0 + 0.005952380952381*G0_0_1 + 0.009920634920635*G0_1_0 - 0.048710317460318*G0_1_1;
    A[2] = 0.017658730158730*G0_0_0 - 0.004712301587302*G0_0_1 - 0.004712301587302*G0_1_0 + 0.017658730158730*G0_1_1;
    A[3] = -0.015426587301587*G0_0_0 - 0.024479166666667*G0_0_1 + 0.009052579365079*G0_1_0 + 0.018601190476190*G0_1_1;
    A[4] = 0.017460317460317*G0_0_0 + 0.021676587301587*G0_0_1 - 0.005704365079365*G0_1_0 - 0.011904761904762*G0_1_1;
    A[5] = -0.023859126984127*G0_0_0 - 0.032663690476190*G0_0_1 + 0.006820436507936*G0_1_0 + 0.011160714285714*G0_1_1;
    A[6] = -0.013144841269841*G0_0_0 - 0.008804563492063*G0_0_1 + 0.030679563492063*G0_1_0 + 0.023859126984127*G0_1_1;
    A[7] = 0.027777777777778*G0_0_0 + 0.014136904761905*G0_0_1 - 0.072767857142857*G0_1_0 - 0.061111111111111*G0_1_1;
    A[8] = -0.020585317460317*G0_0_0 - 0.007068452380952*G0_0_1 + 0.058209325396825*G0_1_0 + 0.051140873015873*G0_1_1;
    A[9] = 0.043492679001552*G0_0_0 - 0.023149329145987*G0_0_1 - 0.062433039211905*G0_1_0 + 0.035074741130284*G0_1_1;
    A[10] = 0.065295566158349*G0_0_0 - 0.051549131177643*G0_0_1 - 0.127154523571521*G0_1_0 + 0.065295566158348*G0_1_1;
    A[11] = -0.016865079365079*G0_0_0 - 0.007440476190476*G0_0_1 + 0.071924603174601*G0_1_0 - 0.010912698412698*G0_1_1;
    A[12] = 0.035074741130284*G0_0_0 + 0.128373552536839*G0_0_1 - 0.011925411984296*G0_1_0 - 0.124866078423810*G0_1_1;
    A[13] = -0.100520805796404*G0_0_0 - 0.063147685692613*G0_0_1 + 0.070880055369259*G0_1_0 - 0.085056066443112*G0_1_1;
    A[14] = 0.062003968253966*G0_0_0 + 0.095982142857139*G0_0_1 - 0.021081349206348*G0_1_0 + 0.053075396825396*G0_1_1;
    A[15] = -0.029861111111111*G0_0_0 + 0.009920634920635*G0_0_1 + 0.005952380952381*G0_1_0 - 0.048710317460318*G0_1_1;
    A[16] = 0.068650793650793*G0_0_0 - 0.012896825396825*G0_0_1 - 0.012896825396825*G0_1_0 + 0.068650793650794*G0_1_1;
    A[17] = -0.048710317460317*G0_0_0 + 0.005952380952381*G0_0_1 + 0.009920634920635*G0_1_0 - 0.029861111111111*G0_1_1;
    A[18] = 0.017460317460317*G0_0_0 + 0.023164682539682*G0_0_1 - 0.004216269841270*G0_1_0 - 0.010416666666667*G0_1_1;
    A[19] = -0.043849206349206*G0_0_0 - 0.053273809523809*G0_0_1 + 0.009424603174603*G0_1_0 + 0.017857142857143*G0_1_1;
    A[20] = 0.061111111111111*G0_0_0 + 0.075248015873016*G0_0_1 - 0.011656746031746*G0_1_0 - 0.025297619047619*G0_1_1;
    A[21] = 0.010416666666667*G0_0_0 + 0.004216269841270*G0_0_1 - 0.023164682539683*G0_1_0 - 0.017460317460318*G0_1_1;
    A[22] = -0.017857142857143*G0_0_0 - 0.009424603174603*G0_0_1 + 0.053273809523810*G0_1_0 + 0.043849206349207*G0_1_1;
    A[23] = 0.025297619047619*G0_0_0 + 0.011656746031746*G0_0_1 - 0.075248015873016*G0_1_0 - 0.061111111111111*G0_1_1;
    A[24] = -0.078567420131836*G0_0_0 - 0.009820927516479*G0_0_1 + 0.136089995585501*G0_1_0 + 0.070149482260568*G0_1_1;
    A[25] = -0.053267435550232*G0_0_0 - 0.008591521862940*G0_0_1 + 0.183858567866929*G0_1_0 + 0.084196914256817*G0_1_1;
    A[26] = -0.004960317460317*G0_0_0 + 0.019841269841269*G0_0_1 - 0.162698412698407*G0_1_0 - 0.102182539682536*G0_1_1;
    A[27] = -0.070149482260567*G0_0_0 - 0.136089995585501*G0_0_1 + 0.009820927516479*G0_1_0 + 0.078567420131836*G0_1_1;
    A[28] = 0.046394218059879*G0_0_0 + 0.048971674618761*G0_0_1 - 0.012887282794411*G0_1_0 + 0.030929478706587*G0_1_1;
    A[29] = -0.124007936507931*G0_0_0 - 0.240575396825388*G0_0_1 + 0.017361111111110*G0_1_0 + 0.043650793650791*G0_1_1;
    A[30] = 0.017658730158730*G0_0_0 - 0.004712301587302*G0_0_1 - 0.004712301587302*G0_1_0 + 0.017658730158730*G0_1_1;
    A[31] = -0.048710317460317*G0_0_0 + 0.009920634920635*G0_0_1 + 0.005952380952381*G0_1_0 - 0.029861111111111*G0_1_1;
    A[32] = 0.057341269841270*G0_0_0 - 0.011160714285714*G0_0_1 - 0.011160714285714*G0_1_0 + 0.021626984126984*G0_1_1;
    A[33] = -0.023859126984127*G0_0_0 - 0.030679563492063*G0_0_1 + 0.008804563492063*G0_1_0 + 0.013144841269841*G0_1_1;
    A[34] = 0.061111111111111*G0_0_0 + 0.072767857142857*G0_0_1 - 0.014136904761905*G0_1_0 - 0.027777777777778*G0_1_1;
    A[35] = -0.051140873015873*G0_0_0 - 0.058209325396825*G0_0_1 + 0.007068452380952*G0_1_0 + 0.020585317460317*G0_1_1;
    A[36] = -0.018601190476191*G0_0_0 - 0.009052579365079*G0_0_1 + 0.024479166666667*G0_1_0 + 0.015426587301587*G0_1_1;
    A[37] = 0.011904761904762*G0_0_0 + 0.005704365079365*G0_0_1 - 0.021676587301587*G0_1_0 - 0.017460317460318*G0_1_1;
    A[38] = -0.011160714285714*G0_0_0 - 0.006820436507936*G0_0_1 + 0.032663690476191*G0_1_0 + 0.023859126984127*G0_1_1;
    A[39] = 0.124866078423811*G0_0_0 + 0.011925411984296*G0_0_1 - 0.128373552536839*G0_1_0 - 0.035074741130284*G0_1_1;
    A[40] = -0.003436608745176*G0_0_0 - 0.017183043725881*G0_0_1 - 0.051549131177644*G0_1_0 - 0.003436608745176*G0_1_1;
    A[41] = 0.100198412698409*G0_0_0 - 0.071924603174601*G0_0_1 + 0.102678571428568*G0_1_0 + 0.118055555555552*G0_1_1;
    A[42] = -0.035074741130284*G0_0_0 + 0.062433039211905*G0_0_1 + 0.023149329145987*G0_1_0 - 0.043492679001552*G0_1_1;
    A[43] = -0.023197109029940*G0_0_0 + 0.001288728279441*G0_0_1 + 0.032218206986027*G0_1_0 - 0.018042195912175*G0_1_1;
    A[44] = -0.062003968253966*G0_0_0 + 0.146081349206344*G0_0_1 + 0.040922619047618*G0_1_0 - 0.064980158730156*G0_1_1;
    A[45] = -0.015426587301587*G0_0_0 + 0.009052579365079*G0_0_1 - 0.024479166666667*G0_1_0 + 0.018601190476190*G0_1_1;
    A[46] = 0.017460317460317*G0_0_0 - 0.004216269841270*G0_0_1 + 0.023164682539682*G0_1_0 - 0.010416666666667*G0_1_1;
    A[47] = -0.023859126984127*G0_0_0 + 0.008804563492063*G0_0_1 - 0.030679563492063*G0_1_0 + 0.013144841269841*G0_1_1;
    A[48] = 0.021626984126984*G0_0_0 + 0.032787698412698*G0_0_1 + 0.032787698412698*G0_1_0 + 0.101289682539682*G0_1_1;
    A[49] = -0.029861111111111*G0_0_0 - 0.035813492063492*G0_0_1 - 0.039781746031746*G0_1_0 - 0.094444444444444*G0_1_1;
    A[50] = 0.017658730158730*G0_0_0 + 0.022371031746032*G0_0_1 + 0.022371031746032*G0_1_0 + 0.044742063492063*G0_1_1;
    A[51] = 0.020585317460317*G0_0_0 + 0.013516865079365*G0_0_1 + 0.078794642857143*G0_1_0 + 0.020585317460317*G0_1_1;
    A[52] = -0.027777777777778*G0_0_0 - 0.013640873015873*G0_0_1 - 0.100545634920635*G0_1_0 - 0.025297619047619*G0_1_1;
    A[53] = 0.013144841269841*G0_0_0 + 0.004340277777778*G0_0_1 + 0.043824404761905*G0_1_0 + 0.011160714285714*G0_1_1;
    A[54] = -0.078567420131836*G0_0_0 + 0.026656803259016*G0_0_1 - 0.152925871328038*G0_1_0 + 0.042089689356341*G0_1_1;
    A[55] = -0.035225239638057*G0_0_0 + 0.079471577232200*G0_0_1 + 0.021049228564204*G0_1_0 + 0.115985545149697*G0_1_1;
    A[56] = -0.045138888888887*G0_0_0 + 0.043402777777776*G0_0_1 + 0.005704365079365*G0_1_0 + 0.052083333333332*G0_1_1;
    A[57] = 0.035074741130284*G0_0_0 - 0.093298811406555*G0_0_1 + 0.047000153114580*G0_1_0 - 0.206239477846069*G0_1_1;
    A[58] = 0.100520805796404*G0_0_0 + 0.037373120103791*G0_0_1 + 0.171400861165664*G0_1_0 + 0.193309241916162*G0_1_1;
    A[59] = 0.062003968253966*G0_0_0 - 0.033978174603173*G0_0_1 + 0.083085317460315*G0_1_0 + 0.040178571428570*G0_1_1;
    A[60] = 0.017460317460317*G0_0_0 - 0.005704365079365*G0_0_1 + 0.021676587301587*G0_1_0 - 0.011904761904762*G0_1_1;
    A[61] = -0.043849206349206*G0_0_0 + 0.009424603174603*G0_0_1 - 0.053273809523809*G0_1_0 + 0.017857142857143*G0_1_1;
    A[62] = 0.061111111111111*G0_0_0 - 0.014136904761905*G0_0_1 + 0.072767857142857*G0_1_0 - 0.027777777777778*G0_1_1;
    A[63] = -0.029861111111111*G0_0_0 - 0.039781746031746*G0_0_1 - 0.035813492063492*G0_1_0 - 0.094444444444444*G0_1_1;
    A[64] = 0.068650793650793*G0_0_0 + 0.081547619047619*G0_0_1 + 0.081547619047619*G0_1_0 + 0.163095238095238*G0_1_1;
    A[65] = -0.048710317460317*G0_0_0 - 0.054662698412698*G0_0_1 - 0.058630952380952*G0_1_0 - 0.094444444444444*G0_1_1;
    A[66] = -0.025297619047619*G0_0_0 - 0.013640873015873*G0_0_1 - 0.100545634920635*G0_1_0 - 0.027777777777778*G0_1_1;
    A[67] = 0.017857142857143*G0_0_0 + 0.008432539682540*G0_0_1 + 0.071130952380952*G0_1_0 + 0.017857142857143*G0_1_1;
    A[68] = -0.010416666666667*G0_0_0 - 0.006200396825397*G0_0_1 - 0.033581349206349*G0_1_0 - 0.011904761904762*G0_1_1;
    A[69] = 0.148716902392404*G0_0_0 + 0.002805979290423*G0_0_1 + 0.294627825494385*G0_1_0;
    A[70] = -0.006873217490352*G0_0_0 - 0.047253370246173*G0_0_1 - 0.177844502562870*G0_1_0 - 0.103098262355287*G0_1_1;
    A[71] = 0.128968253968249*G0_0_0 - 0.091765873015870*G0_0_1 - 0.016369047619047*G0_1_0 - 0.178571428571422*G0_1_1;
    A[72] = -0.070149482260568*G0_0_0 + 0.065940513324934*G0_0_1 - 0.079970409777047*G0_1_0 + 0.134687005940290*G0_1_1;
    A[73] = -0.046394218059879*G0_0_0 + 0.002577456558882*G0_0_1 - 0.059281500854290*G0_1_0 - 0.041239304942115*G0_1_1;
    A[74] = -0.124007936507932*G0_0_0 + 0.116567460317456*G0_0_1 - 0.141369047619043*G0_1_0 + 0.142857142857138*G0_1_1;
    A[75] = -0.023859126984127*G0_0_0 + 0.006820436507936*G0_0_1 - 0.032663690476190*G0_1_0 + 0.011160714285714*G0_1_1;
    A[76] = 0.061111111111111*G0_0_0 - 0.011656746031746*G0_0_1 + 0.075248015873016*G0_1_0 - 0.025297619047619*G0_1_1;
    A[77] = -0.051140873015873*G0_0_0 + 0.007068452380952*G0_0_1 - 0.058209325396825*G0_1_0 + 0.020585317460317*G0_1_1;
    A[78] = 0.017658730158730*G0_0_0 + 0.022371031746032*G0_0_1 + 0.022371031746032*G0_1_0 + 0.044742063492063*G0_1_1;
    A[79] = -0.048710317460317*G0_0_0 - 0.058630952380952*G0_0_1 - 0.054662698412698*G0_1_0 - 0.094444444444444*G0_1_1;
    A[80] = 0.057341269841270*G0_0_0 + 0.068501984126984*G0_0_1 + 0.068501984126984*G0_1_0 + 0.101289682539682*G0_1_1;
    A[81] = 0.011160714285714*G0_0_0 + 0.004340277777778*G0_0_1 + 0.043824404761905*G0_1_0 + 0.013144841269841*G0_1_1;
    A[82] = -0.011904761904762*G0_0_0 - 0.006200396825397*G0_0_1 - 0.033581349206349*G0_1_0 - 0.010416666666667*G0_1_1;
    A[83] = 0.018601190476191*G0_0_0 + 0.009548611111111*G0_0_1 + 0.043080357142857*G0_1_0 + 0.018601190476190*G0_1_1;
    A[84] = -0.089791337293527*G0_0_0 - 0.015432886097325*G0_0_1 - 0.195015560684378*G0_1_0 - 0.042089689356341*G0_1_1;
    A[85] = -0.026633717775116*G0_0_0 - 0.010739402328676*G0_0_1 - 0.007302793583500*G0_1_0 - 0.012887282794411*G0_1_1;
    A[86] = -0.038194444444443*G0_0_0 + 0.035962301587300*G0_0_1 + 0.105406746031742*G0_1_0 + 0.126488095238091*G0_1_1;
    A[87] = -0.035074741130283*G0_0_0 - 0.097507780342189*G0_0_1 - 0.058224070276271*G0_1_0 - 0.164149788489728*G0_1_1;
    A[88] = 0.023197109029939*G0_0_0 + 0.024485837309380*G0_0_1 + 0.055415316015966*G0_1_0 + 0.074746240207583*G0_1_1;
    A[89] = -0.062003968253965*G0_0_0 - 0.208085317460310*G0_0_1 - 0.102926587301583*G0_1_0 - 0.313988095238084*G0_1_1;
    A[90] = -0.013144841269841*G0_0_0 + 0.030679563492063*G0_0_1 - 0.008804563492063*G0_1_0 + 0.023859126984127*G0_1_1;
    A[91] = 0.010416666666667*G0_0_0 - 0.023164682539683*G0_0_1 + 0.004216269841270*G0_1_0 - 0.017460317460318*G0_1_1;
    A[92] = -0.018601190476191*G0_0_0 + 0.024479166666667*G0_0_1 - 0.009052579365079*G0_1_0 + 0.015426587301587*G0_1_1;
    A[93] = 0.020585317460317*G0_0_0 + 0.078794642857143*G0_0_1 + 0.013516865079365*G0_1_0 + 0.020585317460317*G0_1_1;
    A[94] = -0.025297619047619*G0_0_0 - 0.100545634920635*G0_0_1 - 0.013640873015873*G0_1_0 - 0.027777777777778*G0_1_1;
    A[95] = 0.011160714285714*G0_0_0 + 0.043824404761905*G0_0_1 + 0.004340277777778*G0_1_0 + 0.013144841269841*G0_1_1;
    A[96] = 0.101289682539682*G0_0_0 + 0.032787698412698*G0_0_1 + 0.032787698412698*G0_1_0 + 0.021626984126984*G0_1_1;
    A[97] = -0.094444444444444*G0_0_0 - 0.039781746031746*G0_0_1 - 0.035813492063492*G0_1_0 - 0.029861111111111*G0_1_1;
    A[98] = 0.044742063492063*G0_0_0 + 0.022371031746032*G0_0_1 + 0.022371031746032*G0_1_0 + 0.017658730158730*G0_1_1;
    A[99] = -0.206239477846070*G0_0_0 + 0.047000153114580*G0_0_1 - 0.093298811406555*G0_1_0 + 0.035074741130284*G0_1_1;
    A[100] = 0.131450284502991*G0_0_0 + 0.157654426184959*G0_0_1 - 0.010739402328676*G0_1_0 + 0.103957414541580*G0_1_1;
    A[101] = 0.147321428571423*G0_0_0 + 0.106894841269838*G0_0_1 + 0.049355158730157*G0_1_0 + 0.056051587301586*G0_1_1;
    A[102] = 0.042089689356341*G0_0_0 - 0.152925871328038*G0_0_1 + 0.026656803259016*G0_1_0 - 0.078567420131836*G0_1_1;
    A[103] = 0.103098262355286*G0_0_0 + 0.015464739353293*G0_0_1 + 0.077323696766465*G0_1_0 - 0.056704044295408*G0_1_1;
    A[104] = 0.074404761904760*G0_0_0 + 0.015376984126983*G0_0_1 + 0.047123015873014*G0_1_0 - 0.007936507936508*G0_1_1;
    A[105] = 0.027777777777778*G0_0_0 - 0.072767857142857*G0_0_1 + 0.014136904761905*G0_1_0 - 0.061111111111111*G0_1_1;
    A[106] = -0.017857142857143*G0_0_0 + 0.053273809523810*G0_0_1 - 0.009424603174603*G0_1_0 + 0.043849206349207*G0_1_1;
    A[107] = 0.011904761904762*G0_0_0 - 0.021676587301587*G0_0_1 + 0.005704365079365*G0_1_0 - 0.017460317460318*G0_1_1;
    A[108] = -0.027777777777778*G0_0_0 - 0.100545634920635*G0_0_1 - 0.013640873015873*G0_1_0 - 0.025297619047619*G0_1_1;
    A[109] = 0.017857142857143*G0_0_0 + 0.071130952380952*G0_0_1 + 0.008432539682540*G0_1_0 + 0.017857142857143*G0_1_1;
    A[110] = -0.011904761904762*G0_0_0 - 0.033581349206349*G0_0_1 - 0.006200396825397*G0_1_0 - 0.010416666666667*G0_1_1;
    A[111] = -0.094444444444444*G0_0_0 - 0.035813492063492*G0_0_1 - 0.039781746031746*G0_1_0 - 0.029861111111111*G0_1_1;
    A[112] = 0.163095238095238*G0_0_0 + 0.081547619047619*G0_0_1 + 0.081547619047619*G0_1_0 + 0.068650793650794*G0_1_1;
    A[113] = -0.094444444444444*G0_0_0 - 0.058630952380952*G0_0_1 - 0.054662698412698*G0_1_0 - 0.048710317460318*G0_1_1;
    A[114] = 0.134687005940290*G0_0_0 - 0.079970409777047*G0_0_1 + 0.065940513324934*G0_1_0 - 0.070149482260567*G0_1_1;
    A[115] = 0.103098262355288*G0_0_0 - 0.152069936974047*G0_0_1 + 0.102239110168993*G0_1_0 - 0.130591132316696*G0_1_1;
    A[116] = -0.107142857142853*G0_0_0 + 0.019345238095237*G0_0_1 - 0.056051587301585*G0_1_0 + 0.021825396825396*G0_1_1;
    A[117] = 0.294627825494384*G0_0_1 + 0.002805979290423*G0_1_0 + 0.148716902392403*G0_1_1;
    A[118] = -0.206196524710573*G0_0_0 - 0.103098262355286*G0_0_1 - 0.103098262355286*G0_1_0 + 0.108253175473051*G0_1_1;
    A[119] = -0.145833333333329*G0_0_1 + 0.004960317460317*G0_1_0 - 0.070436507936506*G0_1_1;
    A[120] = -0.020585317460317*G0_0_0 + 0.058209325396825*G0_0_1 - 0.007068452380952*G0_1_0 + 0.051140873015873*G0_1_1;
    A[121] = 0.025297619047619*G0_0_0 - 0.075248015873016*G0_0_1 + 0.011656746031746*G0_1_0 - 0.061111111111111*G0_1_1;
    A[122] = -0.011160714285714*G0_0_0 + 0.032663690476191*G0_0_1 - 0.006820436507936*G0_1_0 + 0.023859126984127*G0_1_1;
    A[123] = 0.013144841269841*G0_0_0 + 0.043824404761905*G0_0_1 + 0.004340277777778*G0_1_0 + 0.011160714285714*G0_1_1;
    A[124] = -0.010416666666667*G0_0_0 - 0.033581349206349*G0_0_1 - 0.006200396825397*G0_1_0 - 0.011904761904762*G0_1_1;
    A[125] = 0.018601190476191*G0_0_0 + 0.043080357142857*G0_0_1 + 0.009548611111111*G0_1_0 + 0.018601190476190*G0_1_1;
    A[126] = 0.044742063492063*G0_0_0 + 0.022371031746032*G0_0_1 + 0.022371031746032*G0_1_0 + 0.017658730158730*G0_1_1;
    A[127] = -0.094444444444444*G0_0_0 - 0.054662698412698*G0_0_1 - 0.058630952380952*G0_1_0 - 0.048710317460318*G0_1_1;
    A[128] = 0.101289682539683*G0_0_0 + 0.068501984126984*G0_0_1 + 0.068501984126984*G0_1_0 + 0.057341269841270*G0_1_1;
    A[129] = -0.164149788489729*G0_0_0 - 0.058224070276272*G0_0_1 - 0.097507780342189*G0_1_0 - 0.035074741130284*G0_1_1;
    A[130] = -0.234548546858278*G0_0_0 - 0.061429381320025*G0_0_1 - 0.167964252420489*G0_1_0 - 0.042098457128409*G0_1_1;
    A[131] = 0.221726190476183*G0_0_0 + 0.099454365079362*G0_0_1 + 0.125248015873012*G0_1_0 + 0.051091269841268*G0_1_1;
    A[132] = -0.042089689356341*G0_0_0 - 0.195015560684378*G0_0_1 - 0.015432886097325*G0_1_0 - 0.089791337293527*G0_1_1;
    A[133] = 0.103098262355287*G0_0_0 + 0.087633523001993*G0_0_1 + 0.025774565588822*G0_1_0 - 0.046394218059879*G0_1_1;
    A[134] = -0.074404761904759*G0_0_0 - 0.059027777777776*G0_0_1 - 0.027281746031745*G0_1_0 - 0.003968253968253*G0_1_1;
    A[135] = 0.043492679001552*G0_0_0 - 0.062433039211905*G0_0_1 - 0.023149329145987*G0_1_0 + 0.035074741130284*G0_1_1;
    A[136] = -0.078567420131836*G0_0_0 + 0.136089995585501*G0_0_1 - 0.009820927516479*G0_1_0 + 0.070149482260568*G0_1_1;
    A[137] = 0.124866078423811*G0_0_0 - 0.128373552536839*G0_0_1 + 0.011925411984296*G0_1_0 - 0.035074741130284*G0_1_1;
    A[138] = -0.078567420131836*G0_0_0 - 0.152925871328038*G0_0_1 + 0.026656803259016*G0_1_0 + 0.042089689356341*G0_1_1;
    A[139] = 0.148716902392404*G0_0_0 + 0.294627825494385*G0_0_1 + 0.002805979290423*G0_1_0;
    A[140] = -0.089791337293527*G0_0_0 - 0.195015560684378*G0_0_1 - 0.015432886097325*G0_1_0 - 0.042089689356341*G0_1_1;
    A[141] = -0.206239477846070*G0_0_0 - 0.093298811406555*G0_0_1 + 0.047000153114580*G0_1_0 + 0.035074741130284*G0_1_1;
    A[142] = 0.134687005940290*G0_0_0 + 0.065940513324934*G0_0_1 - 0.079970409777047*G0_1_0 - 0.070149482260567*G0_1_1;
    A[143] = -0.164149788489729*G0_0_0 - 0.097507780342189*G0_0_1 - 0.058224070276272*G0_1_0 - 0.035074741130284*G0_1_1;
    A[144] = 4.920634920634577*G0_0_0 + 0.198412698412683*G0_0_1 + 0.198412698412683*G0_1_0 + 0.396825396825368*G0_1_1;
    A[145] = 0.024300493479987*G0_0_0 - 0.060751233699978*G0_0_1 + 0.230854688059907*G0_1_0 + 0.607512336999752*G0_1_1;
    A[146] = -0.519106168728181*G0_0_0 - 0.806719045996502*G0_0_1 - 0.301642773720432*G0_1_0 - 0.350747411302827*G0_1_1;
    A[147] = -0.198412698412685*G0_0_0 + 4.305555555555256*G0_0_1 + 0.019841269841269*G0_1_0 - 0.198412698412684*G0_1_1;
    A[148] = -0.218704441319912*G0_0_0 - 0.036450740219988*G0_0_1 + 0.255155181539896*G0_1_0 - 0.218704441319911*G0_1_1;
    A[149] = -0.350747411302827*G0_0_0 + 0.540151013406358*G0_0_1 + 0.035074741130283*G0_1_0 + 0.322687618398600*G0_1_1;
    A[150] = 0.065295566158349*G0_0_0 - 0.127154523571521*G0_0_1 - 0.051549131177643*G0_1_0 + 0.065295566158348*G0_1_1;
    A[151] = -0.053267435550232*G0_0_0 + 0.183858567866929*G0_0_1 - 0.008591521862940*G0_1_0 + 0.084196914256817*G0_1_1;
    A[152] = -0.003436608745176*G0_0_0 - 0.051549131177644*G0_0_1 - 0.017183043725881*G0_1_0 - 0.003436608745176*G0_1_1;
    A[153] = -0.035225239638057*G0_0_0 + 0.021049228564204*G0_0_1 + 0.079471577232200*G0_1_0 + 0.115985545149697*G0_1_1;
    A[154] = -0.006873217490352*G0_0_0 - 0.177844502562870*G0_0_1 - 0.047253370246173*G0_1_0 - 0.103098262355287*G0_1_1;
    A[155] = -0.026633717775116*G0_0_0 - 0.007302793583500*G0_0_1 - 0.010739402328676*G0_1_0 - 0.012887282794411*G0_1_1;
    A[156] = 0.131450284502991*G0_0_0 - 0.010739402328676*G0_0_1 + 0.157654426184959*G0_1_0 + 0.103957414541580*G0_1_1;
    A[157] = 0.103098262355288*G0_0_0 + 0.102239110168993*G0_0_1 - 0.152069936974047*G0_1_0 - 0.130591132316696*G0_1_1;
    A[158] = -0.234548546858278*G0_0_0 - 0.167964252420489*G0_0_1 - 0.061429381320025*G0_1_0 - 0.042098457128409*G0_1_1;
    A[159] = 0.024300493479987*G0_0_0 + 0.230854688059907*G0_0_1 - 0.060751233699978*G0_1_0 + 0.607512336999752*G0_1_1;
    A[160] = 5.416666666666291*G0_0_0 + 0.431547619047589*G0_0_1 + 0.431547619047589*G0_1_0 + 1.130952380952300*G0_1_1;
    A[161] = -0.189013480984686*G0_0_0 - 0.068732174903523*G0_0_1 - 0.274928699614089*G0_1_0 - 0.189013480984685*G0_1_1;
    A[162] = 0.170103454359931*G0_0_0 + 0.449559129379817*G0_0_1 + 0.157953207619936*G0_1_0 - 0.413108389159833*G0_1_1;
    A[163] = -0.401785714285688*G0_0_0 + 3.593749999999746*G0_0_1 + 0.558035714285674*G0_1_0 - 0.401785714285686*G0_1_1;
    A[164] = 0.300703265202909*G0_0_0 + 0.176126198190275*G0_0_1 + 0.279224460545559*G0_1_0 + 0.300703265202908*G0_1_1;
    A[165] = -0.016865079365079*G0_0_0 + 0.071924603174601*G0_0_1 - 0.007440476190476*G0_1_0 - 0.010912698412698*G0_1_1;
    A[166] = -0.004960317460317*G0_0_0 - 0.162698412698407*G0_0_1 + 0.019841269841269*G0_1_0 - 0.102182539682536*G0_1_1;
    A[167] = 0.100198412698409*G0_0_0 + 0.102678571428568*G0_0_1 - 0.071924603174601*G0_1_0 + 0.118055555555552*G0_1_1;
    A[168] = -0.045138888888887*G0_0_0 + 0.005704365079365*G0_0_1 + 0.043402777777776*G0_1_0 + 0.052083333333332*G0_1_1;
    A[169] = 0.128968253968249*G0_0_0 - 0.016369047619047*G0_0_1 - 0.091765873015870*G0_1_0 - 0.178571428571422*G0_1_1;
    A[170] = -0.038194444444443*G0_0_0 + 0.105406746031742*G0_0_1 + 0.035962301587300*G0_1_0 + 0.126488095238091*G0_1_1;
    A[171] = 0.147321428571423*G0_0_0 + 0.049355158730157*G0_0_1 + 0.106894841269838*G0_1_0 + 0.056051587301586*G0_1_1;
    A[172] = -0.107142857142853*G0_0_0 - 0.056051587301585*G0_0_1 + 0.019345238095237*G0_1_0 + 0.021825396825396*G0_1_1;
    A[173] = 0.221726190476183*G0_0_0 + 0.125248015873012*G0_0_1 + 0.099454365079362*G0_1_0 + 0.051091269841268*G0_1_1;
    A[174] = -0.519106168728181*G0_0_0 - 0.301642773720432*G0_0_1 - 0.806719045996502*G0_1_0 - 0.350747411302827*G0_1_1;
    A[175] = -0.189013480984685*G0_0_0 - 0.274928699614089*G0_0_1 - 0.068732174903523*G0_1_0 - 0.189013480984685*G0_1_1;
    A[176] = 5.555555555555168*G0_0_0 + 0.590277777777739*G0_0_1 + 0.590277777777739*G0_1_0 + 0.912698412698351*G0_1_1;
    A[177] = -0.350747411302826*G0_0_0 - 0.301642773720428*G0_0_1 + 0.203433498555639*G0_1_0 - 0.014029896452115*G0_1_1;
    A[178] = 0.077323696766461*G0_0_0 + 0.167534676327335*G0_0_1 + 0.064436413972052*G0_1_0 + 0.077323696766463*G0_1_1;
    A[179] = -0.620039682539638*G0_0_0 + 3.395337301587065*G0_0_1 + 0.359623015872991*G0_1_0 - 0.620039682539642*G0_1_1;
    A[180] = 0.035074741130284*G0_0_0 - 0.011925411984296*G0_0_1 + 0.128373552536839*G0_1_0 - 0.124866078423810*G0_1_1;
    A[181] = -0.070149482260567*G0_0_0 + 0.009820927516479*G0_0_1 - 0.136089995585501*G0_1_0 + 0.078567420131836*G0_1_1;
    A[182] = -0.035074741130284*G0_0_0 + 0.023149329145987*G0_0_1 + 0.062433039211905*G0_1_0 - 0.043492679001552*G0_1_1;
    A[183] = 0.035074741130284*G0_0_0 + 0.047000153114580*G0_0_1 - 0.093298811406555*G0_1_0 - 0.206239477846069*G0_1_1;
    A[184] = -0.070149482260568*G0_0_0 - 0.079970409777048*G0_0_1 + 0.065940513324934*G0_1_0 + 0.134687005940290*G0_1_1;
    A[185] = -0.035074741130283*G0_0_0 - 0.058224070276271*G0_0_1 - 0.097507780342189*G0_1_0 - 0.164149788489728*G0_1_1;
    A[186] = 0.042089689356341*G0_0_0 + 0.026656803259016*G0_0_1 - 0.152925871328038*G0_1_0 - 0.078567420131836*G0_1_1;
    A[187] = 0.002805979290423*G0_0_1 + 0.294627825494384*G0_1_0 + 0.148716902392403*G0_1_1;
    A[188] = -0.042089689356341*G0_0_0 - 0.015432886097325*G0_0_1 - 0.195015560684378*G0_1_0 - 0.089791337293527*G0_1_1;
    A[189] = -0.198412698412685*G0_0_0 + 0.019841269841269*G0_0_1 + 4.305555555555256*G0_1_0 - 0.198412698412684*G0_1_1;
    A[190] = 0.170103454359931*G0_0_0 + 0.157953207619936*G0_0_1 + 0.449559129379816*G0_1_0 - 0.413108389159833*G0_1_1;
    A[191] = -0.350747411302827*G0_0_0 + 0.203433498555639*G0_0_1 - 0.301642773720428*G0_1_0 - 0.014029896452115*G0_1_1;
    A[192] = 0.396825396825368*G0_0_0 + 0.198412698412683*G0_0_1 + 0.198412698412683*G0_1_0 + 4.920634920634575*G0_1_1;
    A[193] = -0.145802960879940*G0_0_1 - 0.729014804399704*G0_1_0 - 0.437408882639824*G0_1_1;
    A[194] = 0.701494822605651*G0_0_0 + 0.350747411302824*G0_0_1 + 0.350747411302824*G0_1_0 + 0.280597929042265*G0_1_1;
    A[195] = -0.100520805796404*G0_0_0 + 0.070880055369259*G0_0_1 - 0.063147685692613*G0_1_0 - 0.085056066443112*G0_1_1;
    A[196] = 0.046394218059879*G0_0_0 - 0.012887282794411*G0_0_1 + 0.048971674618761*G0_1_0 + 0.030929478706587*G0_1_1;
    A[197] = -0.023197109029940*G0_0_0 + 0.032218206986027*G0_0_1 + 0.001288728279441*G0_1_0 - 0.018042195912175*G0_1_1;
    A[198] = 0.100520805796404*G0_0_0 + 0.171400861165664*G0_0_1 + 0.037373120103791*G0_1_0 + 0.193309241916162*G0_1_1;
    A[199] = -0.046394218059879*G0_0_0 - 0.059281500854290*G0_0_1 + 0.002577456558882*G0_1_0 - 0.041239304942115*G0_1_1;
    A[200] = 0.023197109029939*G0_0_0 + 0.055415316015966*G0_0_1 + 0.024485837309380*G0_1_0 + 0.074746240207583*G0_1_1;
    A[201] = 0.103098262355286*G0_0_0 + 0.077323696766465*G0_0_1 + 0.015464739353293*G0_1_0 - 0.056704044295408*G0_1_1;
    A[202] = -0.206196524710573*G0_0_0 - 0.103098262355286*G0_0_1 - 0.103098262355286*G0_1_0 + 0.108253175473051*G0_1_1;
    A[203] = 0.103098262355287*G0_0_0 + 0.025774565588822*G0_0_1 + 0.087633523001993*G0_1_0 - 0.046394218059879*G0_1_1;
    A[204] = -0.218704441319912*G0_0_0 + 0.255155181539896*G0_0_1 - 0.036450740219988*G0_1_0 - 0.218704441319911*G0_1_1;
    A[205] = -0.401785714285688*G0_0_0 + 0.558035714285674*G0_0_1 + 3.593749999999746*G0_1_0 - 0.401785714285686*G0_1_1;
    A[206] = 0.077323696766461*G0_0_0 + 0.064436413972052*G0_0_1 + 0.167534676327335*G0_1_0 + 0.077323696766463*G0_1_1;
    A[207] = -0.729014804399704*G0_0_1 - 0.145802960879940*G0_1_0 - 0.437408882639824*G0_1_1;
    A[208] = 0.803571428571371*G0_0_0 + 0.401785714285684*G0_0_1 + 0.401785714285684*G0_1_0 + 5.357142857142473*G0_1_1;
    A[209] = -0.051549131177641*G0_0_1 - 0.257745655888206*G0_1_0 - 0.154647393532925*G0_1_1;
    A[210] = 0.062003968253966*G0_0_0 - 0.021081349206348*G0_0_1 + 0.095982142857139*G0_1_0 + 0.053075396825396*G0_1_1;
    A[211] = -0.124007936507931*G0_0_0 + 0.017361111111110*G0_0_1 - 0.240575396825388*G0_1_0 + 0.043650793650791*G0_1_1;
    A[212] = -0.062003968253966*G0_0_0 + 0.040922619047618*G0_0_1 + 0.146081349206344*G0_1_0 - 0.064980158730156*G0_1_1;
    A[213] = 0.062003968253966*G0_0_0 + 0.083085317460315*G0_0_1 - 0.033978174603173*G0_1_0 + 0.040178571428570*G0_1_1;
    A[214] = -0.124007936507932*G0_0_0 - 0.141369047619043*G0_0_1 + 0.116567460317456*G0_1_0 + 0.142857142857138*G0_1_1;
    A[215] = -0.062003968253965*G0_0_0 - 0.102926587301583*G0_0_1 - 0.208085317460310*G0_1_0 - 0.313988095238084*G0_1_1;
    A[216] = 0.074404761904760*G0_0_0 + 0.047123015873014*G0_0_1 + 0.015376984126983*G0_1_0 - 0.007936507936508*G0_1_1;
    A[217] = 0.004960317460317*G0_0_1 - 0.145833333333329*G0_1_0 - 0.070436507936506*G0_1_1;
    A[218] = -0.074404761904759*G0_0_0 - 0.027281746031745*G0_0_1 - 0.059027777777776*G0_1_0 - 0.003968253968253*G0_1_1;
    A[219] = -0.350747411302827*G0_0_0 + 0.035074741130283*G0_0_1 + 0.540151013406358*G0_1_0 + 0.322687618398600*G0_1_1;
    A[220] = 0.300703265202909*G0_0_0 + 0.279224460545559*G0_0_1 + 0.176126198190275*G0_1_0 + 0.300703265202908*G0_1_1;
    A[221] = -0.620039682539638*G0_0_0 + 0.359623015872991*G0_0_1 + 3.395337301587064*G0_1_0 - 0.620039682539642*G0_1_1;
    A[222] = 0.701494822605651*G0_0_0 + 0.350747411302824*G0_0_1 + 0.350747411302824*G0_1_0 + 0.280597929042265*G0_1_1;
    A[223] = -0.257745655888206*G0_0_1 - 0.051549131177641*G0_1_0 - 0.154647393532925*G0_1_1;
    A[224] = 1.240079365079275*G0_0_0 + 0.620039682539636*G0_0_1 + 0.620039682539636*G0_1_0 + 5.615079365078977*G0_1_1;
  }

};

/// This class defines the interface for the assembly of the global
/// tensor corresponding to a form with r + n arguments, that is, a
/// mapping
///
///     a : V1 x V2 x ... Vr x W1 x W2 x ... x Wn -> R
///
/// with arguments v1, v2, ..., vr, w1, w2, ..., wn. The rank r
/// global tensor A is defined by
///
///     A = a(V1, V2, ..., Vr, w1, w2, ..., wn),
///
/// where each argument Vj represents the application to the
/// sequence of basis functions of Vj and w1, w2, ..., wn are given
/// fixed functions (coefficients).

class forms_form_0: public ufc::form
{
public:

  /// Constructor
  forms_form_0() : ufc::form()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~forms_form_0()
  {
    // Do nothing
  }

  /// Return a string identifying the form
  virtual const char* signature() const
  {
    return "Form([Integral(Product(Sum(Indexed(SpatialDerivative(Argument(FiniteElement('Nedelec 1st kind H(curl)', Cell('triangle', 1, Space(2)), 3), 0), MultiIndex((FixedIndex(0),), {FixedIndex(0): 2})), MultiIndex((FixedIndex(1),), {FixedIndex(1): 2})), Product(IntValue(-1, (), (), {}), Indexed(SpatialDerivative(Argument(FiniteElement('Nedelec 1st kind H(curl)', Cell('triangle', 1, Space(2)), 3), 0), MultiIndex((FixedIndex(1),), {FixedIndex(1): 2})), MultiIndex((FixedIndex(0),), {FixedIndex(0): 2})))), Sum(Indexed(SpatialDerivative(Argument(FiniteElement('Nedelec 1st kind H(curl)', Cell('triangle', 1, Space(2)), 3), 1), MultiIndex((FixedIndex(0),), {FixedIndex(0): 2})), MultiIndex((FixedIndex(1),), {FixedIndex(1): 2})), Product(IntValue(-1, (), (), {}), Indexed(SpatialDerivative(Argument(FiniteElement('Nedelec 1st kind H(curl)', Cell('triangle', 1, Space(2)), 3), 1), MultiIndex((FixedIndex(1),), {FixedIndex(1): 2})), MultiIndex((FixedIndex(0),), {FixedIndex(0): 2}))))), Measure('cell', 0, None))])";
  }

  /// Return the rank of the global tensor (r)
  virtual unsigned int rank() const
  {
    return 2;
  }

  /// Return the number of coefficients (n)
  virtual unsigned int num_coefficients() const
  {
    return 0;
  }

  /// Return the number of cell integrals
  virtual unsigned int num_cell_integrals() const
  {
    return 1;
  }

  /// Return the number of exterior facet integrals
  virtual unsigned int num_exterior_facet_integrals() const
  {
    return 0;
  }

  /// Return the number of interior facet integrals
  virtual unsigned int num_interior_facet_integrals() const
  {
    return 0;
  }

  /// Create a new finite element for argument function i
  virtual ufc::finite_element* create_finite_element(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new forms_finite_element_0();
        break;
      }
    case 1:
      {
        return new forms_finite_element_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new dof map for argument function i
  virtual ufc::dof_map* create_dof_map(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new forms_dof_map_0();
        break;
      }
    case 1:
      {
        return new forms_dof_map_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new cell integral on sub domain i
  virtual ufc::cell_integral* create_cell_integral(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new forms_cell_integral_0_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new exterior facet integral on sub domain i
  virtual ufc::exterior_facet_integral* create_exterior_facet_integral(unsigned int i) const
  {
    return 0;
  }

  /// Create a new interior facet integral on sub domain i
  virtual ufc::interior_facet_integral* create_interior_facet_integral(unsigned int i) const
  {
    return 0;
  }

};

/// This class defines the interface for the assembly of the global
/// tensor corresponding to a form with r + n arguments, that is, a
/// mapping
///
///     a : V1 x V2 x ... Vr x W1 x W2 x ... x Wn -> R
///
/// with arguments v1, v2, ..., vr, w1, w2, ..., wn. The rank r
/// global tensor A is defined by
///
///     A = a(V1, V2, ..., Vr, w1, w2, ..., wn),
///
/// where each argument Vj represents the application to the
/// sequence of basis functions of Vj and w1, w2, ..., wn are given
/// fixed functions (coefficients).

class forms_form_1: public ufc::form
{
public:

  /// Constructor
  forms_form_1() : ufc::form()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~forms_form_1()
  {
    // Do nothing
  }

  /// Return a string identifying the form
  virtual const char* signature() const
  {
    return "Form([Integral(IndexSum(Product(Indexed(Argument(FiniteElement('Nedelec 1st kind H(curl)', Cell('triangle', 1, Space(2)), 3), 0), MultiIndex((Index(0),), {Index(0): 2})), Indexed(Argument(FiniteElement('Nedelec 1st kind H(curl)', Cell('triangle', 1, Space(2)), 3), 1), MultiIndex((Index(0),), {Index(0): 2}))), MultiIndex((Index(0),), {Index(0): 2})), Measure('cell', 0, None))])";
  }

  /// Return the rank of the global tensor (r)
  virtual unsigned int rank() const
  {
    return 2;
  }

  /// Return the number of coefficients (n)
  virtual unsigned int num_coefficients() const
  {
    return 0;
  }

  /// Return the number of cell integrals
  virtual unsigned int num_cell_integrals() const
  {
    return 1;
  }

  /// Return the number of exterior facet integrals
  virtual unsigned int num_exterior_facet_integrals() const
  {
    return 0;
  }

  /// Return the number of interior facet integrals
  virtual unsigned int num_interior_facet_integrals() const
  {
    return 0;
  }

  /// Create a new finite element for argument function i
  virtual ufc::finite_element* create_finite_element(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new forms_finite_element_0();
        break;
      }
    case 1:
      {
        return new forms_finite_element_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new dof map for argument function i
  virtual ufc::dof_map* create_dof_map(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new forms_dof_map_0();
        break;
      }
    case 1:
      {
        return new forms_dof_map_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new cell integral on sub domain i
  virtual ufc::cell_integral* create_cell_integral(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new forms_cell_integral_1_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new exterior facet integral on sub domain i
  virtual ufc::exterior_facet_integral* create_exterior_facet_integral(unsigned int i) const
  {
    return 0;
  }

  /// Create a new interior facet integral on sub domain i
  virtual ufc::interior_facet_integral* create_interior_facet_integral(unsigned int i) const
  {
    return 0;
  }

};

// DOLFIN wrappers

// Standard library includes
#include <string>

// DOLFIN includes
#include <dolfin/common/NoDeleter.h>
#include <dolfin/fem/FiniteElement.h>
#include <dolfin/fem/DofMap.h>
#include <dolfin/fem/Form.h>
#include <dolfin/function/FunctionSpace.h>
#include <dolfin/function/GenericFunction.h>
#include <dolfin/function/CoefficientAssigner.h>

namespace Forms
{

class Form_0_FunctionSpace_0: public dolfin::FunctionSpace
{
public:

  Form_0_FunctionSpace_0(const dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new forms_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dof_map>(new forms_dof_map_0()), mesh)))
  {
    // Do nothing
  }

  Form_0_FunctionSpace_0(dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new forms_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dof_map>(new forms_dof_map_0()), mesh)))
  {
    // Do nothing
  }

  Form_0_FunctionSpace_0(boost::shared_ptr<dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new forms_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dof_map>(new forms_dof_map_0()), *mesh)))
  {
      // Do nothing
  }

  Form_0_FunctionSpace_0(boost::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new forms_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dof_map>(new forms_dof_map_0()), *mesh)))
  {
      // Do nothing
  }

  ~Form_0_FunctionSpace_0()
  {
  }

};

class Form_0_FunctionSpace_1: public dolfin::FunctionSpace
{
public:

  Form_0_FunctionSpace_1(const dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new forms_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dof_map>(new forms_dof_map_0()), mesh)))
  {
    // Do nothing
  }

  Form_0_FunctionSpace_1(dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new forms_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dof_map>(new forms_dof_map_0()), mesh)))
  {
    // Do nothing
  }

  Form_0_FunctionSpace_1(boost::shared_ptr<dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new forms_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dof_map>(new forms_dof_map_0()), *mesh)))
  {
      // Do nothing
  }

  Form_0_FunctionSpace_1(boost::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new forms_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dof_map>(new forms_dof_map_0()), *mesh)))
  {
      // Do nothing
  }

  ~Form_0_FunctionSpace_1()
  {
  }

};

class Form_0: public dolfin::Form
{
public:

  // Constructor
  Form_0(const dolfin::FunctionSpace& V0, const dolfin::FunctionSpace& V1):
    dolfin::Form(2, 0)
  {
    _function_spaces[0] = reference_to_no_delete_pointer(V0);
    _function_spaces[1] = reference_to_no_delete_pointer(V1);

    _ufc_form = boost::shared_ptr<const ufc::form>(new forms_form_0());
  }

  // Constructor
  Form_0(boost::shared_ptr<const dolfin::FunctionSpace> V0, boost::shared_ptr<const dolfin::FunctionSpace> V1):
    dolfin::Form(2, 0)
  {
    _function_spaces[0] = V0;
    _function_spaces[1] = V1;

    _ufc_form = boost::shared_ptr<const ufc::form>(new forms_form_0());
  }

  // Destructor
  ~Form_0()
  {}

  /// Return the number of the coefficient with this name
  virtual dolfin::uint coefficient_number(const std::string& name) const
  {

    dolfin::error("No coefficients.");
    return 0;
  }

  /// Return the name of the coefficient with this number
  virtual std::string coefficient_name(dolfin::uint i) const
  {

    dolfin::error("No coefficients.");
    return "unnamed";
  }

  // Typedefs
  typedef Form_0_FunctionSpace_0 TestSpace;
  typedef Form_0_FunctionSpace_1 TrialSpace;

  // Coefficients
};

class Form_1_FunctionSpace_0: public dolfin::FunctionSpace
{
public:

  Form_1_FunctionSpace_0(const dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new forms_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dof_map>(new forms_dof_map_0()), mesh)))
  {
    // Do nothing
  }

  Form_1_FunctionSpace_0(dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new forms_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dof_map>(new forms_dof_map_0()), mesh)))
  {
    // Do nothing
  }

  Form_1_FunctionSpace_0(boost::shared_ptr<dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new forms_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dof_map>(new forms_dof_map_0()), *mesh)))
  {
      // Do nothing
  }

  Form_1_FunctionSpace_0(boost::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new forms_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dof_map>(new forms_dof_map_0()), *mesh)))
  {
      // Do nothing
  }

  ~Form_1_FunctionSpace_0()
  {
  }

};

class Form_1_FunctionSpace_1: public dolfin::FunctionSpace
{
public:

  Form_1_FunctionSpace_1(const dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new forms_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dof_map>(new forms_dof_map_0()), mesh)))
  {
    // Do nothing
  }

  Form_1_FunctionSpace_1(dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new forms_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dof_map>(new forms_dof_map_0()), mesh)))
  {
    // Do nothing
  }

  Form_1_FunctionSpace_1(boost::shared_ptr<dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new forms_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dof_map>(new forms_dof_map_0()), *mesh)))
  {
      // Do nothing
  }

  Form_1_FunctionSpace_1(boost::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new forms_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dof_map>(new forms_dof_map_0()), *mesh)))
  {
      // Do nothing
  }

  ~Form_1_FunctionSpace_1()
  {
  }

};

class Form_1: public dolfin::Form
{
public:

  // Constructor
  Form_1(const dolfin::FunctionSpace& V0, const dolfin::FunctionSpace& V1):
    dolfin::Form(2, 0)
  {
    _function_spaces[0] = reference_to_no_delete_pointer(V0);
    _function_spaces[1] = reference_to_no_delete_pointer(V1);

    _ufc_form = boost::shared_ptr<const ufc::form>(new forms_form_1());
  }

  // Constructor
  Form_1(boost::shared_ptr<const dolfin::FunctionSpace> V0, boost::shared_ptr<const dolfin::FunctionSpace> V1):
    dolfin::Form(2, 0)
  {
    _function_spaces[0] = V0;
    _function_spaces[1] = V1;

    _ufc_form = boost::shared_ptr<const ufc::form>(new forms_form_1());
  }

  // Destructor
  ~Form_1()
  {}

  /// Return the number of the coefficient with this name
  virtual dolfin::uint coefficient_number(const std::string& name) const
  {

    dolfin::error("No coefficients.");
    return 0;
  }

  /// Return the name of the coefficient with this number
  virtual std::string coefficient_name(dolfin::uint i) const
  {

    dolfin::error("No coefficients.");
    return "unnamed";
  }

  // Typedefs
  typedef Form_1_FunctionSpace_0 TestSpace;
  typedef Form_1_FunctionSpace_1 TrialSpace;

  // Coefficients
};

// Class typedefs
typedef Form_0::TestSpace FunctionSpace;

}

#endif
