/* dockmanager-daemon.c generated by valac 0.11.6, the Vala compiler
 * generated from dockmanager-daemon.vala, do not modify */

/*
 * Copyright (C) 2010 Michal Hruby <michal.mhr@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA.
 *
 * Authored by Michal Hruby <michal.mhr@gmail.com>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <dbus/dbus-glib.h>
#include <dbus/dbus-glib-lowlevel.h>
#include <gio/gio.h>
#include <config.h>
#include <libdesktop-agnostic/config.h>
#include <dbus/dbus.h>
#include <libdesktop-agnostic/vfs.h>
#include <signal.h>
#include <sys/types.h>


#define DOCK_MANAGER_TYPE_HELPER_PROCESS_INFO (dock_manager_helper_process_info_get_type ())
typedef struct _DockManagerHelperProcessInfo DockManagerHelperProcessInfo;

#define DOCK_MANAGER_TYPE_DAEMON_INTERFACE (dock_manager_daemon_interface_get_type ())
#define DOCK_MANAGER_DAEMON_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DOCK_MANAGER_TYPE_DAEMON_INTERFACE, DockManagerDaemonInterface))
#define DOCK_MANAGER_IS_DAEMON_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DOCK_MANAGER_TYPE_DAEMON_INTERFACE))
#define DOCK_MANAGER_DAEMON_INTERFACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DOCK_MANAGER_TYPE_DAEMON_INTERFACE, DockManagerDaemonInterfaceIface))

typedef struct _DockManagerDaemonInterface DockManagerDaemonInterface;
typedef struct _DockManagerDaemonInterfaceIface DockManagerDaemonInterfaceIface;

#define DOCK_MANAGER_TYPE_HELPER_INFO (dock_manager_helper_info_get_type ())
typedef struct _DockManagerHelperInfo DockManagerHelperInfo;

#define DOCK_MANAGER_TYPE_HELPER_DAEMON (dock_manager_helper_daemon_get_type ())
#define DOCK_MANAGER_HELPER_DAEMON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DOCK_MANAGER_TYPE_HELPER_DAEMON, DockManagerHelperDaemon))
#define DOCK_MANAGER_HELPER_DAEMON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DOCK_MANAGER_TYPE_HELPER_DAEMON, DockManagerHelperDaemonClass))
#define DOCK_MANAGER_IS_HELPER_DAEMON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DOCK_MANAGER_TYPE_HELPER_DAEMON))
#define DOCK_MANAGER_IS_HELPER_DAEMON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DOCK_MANAGER_TYPE_HELPER_DAEMON))
#define DOCK_MANAGER_HELPER_DAEMON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DOCK_MANAGER_TYPE_HELPER_DAEMON, DockManagerHelperDaemonClass))

typedef struct _DockManagerHelperDaemon DockManagerHelperDaemon;
typedef struct _DockManagerHelperDaemonClass DockManagerHelperDaemonClass;
typedef struct _DockManagerHelperDaemonPrivate DockManagerHelperDaemonPrivate;

#define DOCK_MANAGER_TYPE_DBUS_WATCHER (dock_manager_dbus_watcher_get_type ())
#define DOCK_MANAGER_DBUS_WATCHER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DOCK_MANAGER_TYPE_DBUS_WATCHER, DockManagerDBusWatcher))
#define DOCK_MANAGER_DBUS_WATCHER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DOCK_MANAGER_TYPE_DBUS_WATCHER, DockManagerDBusWatcherClass))
#define DOCK_MANAGER_IS_DBUS_WATCHER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DOCK_MANAGER_TYPE_DBUS_WATCHER))
#define DOCK_MANAGER_IS_DBUS_WATCHER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DOCK_MANAGER_TYPE_DBUS_WATCHER))
#define DOCK_MANAGER_DBUS_WATCHER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DOCK_MANAGER_TYPE_DBUS_WATCHER, DockManagerDBusWatcherClass))

typedef struct _DockManagerDBusWatcher DockManagerDBusWatcher;
typedef struct _DockManagerDBusWatcherClass DockManagerDBusWatcherClass;
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_value_array_free0(var) ((var == NULL) ? NULL : (var = (g_value_array_free (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define __g_list_free__dock_manager_helper_info_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__dock_manager_helper_info_free0_ (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _dbus_g_connection_unref0(var) ((var == NULL) ? NULL : (var = (dbus_g_connection_unref (var), NULL)))
typedef struct _DBusObjectVTable _DBusObjectVTable;
#define __g_slist_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_slist_free__g_object_unref0_ (var), NULL)))
#define _g_key_file_free0(var) ((var == NULL) ? NULL : (var = (g_key_file_free (var), NULL)))
typedef struct _Block1Data Block1Data;
typedef struct _Block2Data Block2Data;
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
typedef struct _Block3Data Block3Data;
typedef struct _Block4Data Block4Data;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_io_channel_unref0(var) ((var == NULL) ? NULL : (var = (g_io_channel_unref (var), NULL)))
typedef struct _Block5Data Block5Data;
typedef struct _DockManagerHelperDaemonInstallHelperData DockManagerHelperDaemonInstallHelperData;

struct _DockManagerHelperProcessInfo {
	gint pid;
	guint kill_timer_id;
	gulong dbus_appear_id;
	gulong dbus_disappear_id;
};

struct _DockManagerHelperInfo {
	gchar* path;
	gchar* name;
	gchar* description;
	gchar* icon_name;
	gchar* app_name;
	gchar* dbus_name;
	gboolean app_available;
	gboolean enabled;
	gboolean running;
};

struct _DockManagerDaemonInterfaceIface {
	GTypeInterface parent_iface;
	DockManagerHelperInfo* (*get_all_helpers) (DockManagerDaemonInterface* self, int* result_length1, GError** error);
	void (*enable_helper) (DockManagerDaemonInterface* self, const gchar* path, GError** error);
	void (*disable_helper) (DockManagerDaemonInterface* self, const gchar* path, GError** error);
	void (*restart_all) (DockManagerDaemonInterface* self, GError** error);
	void (*install_helper) (DockManagerDaemonInterface* self, const gchar* filename, GAsyncReadyCallback _callback_, gpointer _user_data_);
	gboolean (*install_helper_finish) (DockManagerDaemonInterface* self, GAsyncResult* _res_, GError** error);
	void (*show_preferences) (DockManagerDaemonInterface* self, GError** error);
	void (*embed_preferences) (DockManagerDaemonInterface* self, gint64 xid, GHashTable* hints, GError** error);
};

struct _DockManagerHelperDaemon {
	GObject parent_instance;
	DockManagerHelperDaemonPrivate * priv;
};

struct _DockManagerHelperDaemonClass {
	GObjectClass parent_class;
};

struct _DockManagerHelperDaemonPrivate {
	GMainLoop* main_loop;
	DockManagerDBusWatcher* watcher;
	GValueArray* _helper_list;
	GHashTable* helper_process_info;
	GList* all_scripts;
	gboolean dock_running;
};

struct _DBusObjectVTable {
	void (*register_object) (DBusConnection*, const char*, void*);
};

struct _Block1Data {
	int _ref_count_;
	DockManagerHelperDaemon * self;
	gchar* path;
};

struct _Block2Data {
	int _ref_count_;
	DockManagerHelperDaemon * self;
	DockManagerHelperProcessInfo* hpi;
};

struct _Block3Data {
	int _ref_count_;
	DockManagerHelperDaemon * self;
	gpointer _async_data_;
};

struct _Block4Data {
	int _ref_count_;
	Block3Data * _data3_;
	gboolean metadata_file_found;
	GRegex* re;
};

struct _Block5Data {
	int _ref_count_;
	Block3Data * _data3_;
	gint untar_status;
};

struct _DockManagerHelperDaemonInstallHelperData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	DockManagerHelperDaemon* self;
	gchar* filename;
	gboolean result;
	Block3Data* _data3_;
	GPid pid;
	gchar** argv;
	gint argv_length1;
	gint _argv_size_;
	Block4Data* _data4_;
	gint standard_output;
	gchar* _tmp0_;
	gchar* tar_command;
	gchar** _tmp1_;
	gint _tmp2_;
	GPid _tmp3_;
	gint _tmp4_;
	GRegex* _tmp5_;
	GIOChannel* _tmp6_;
	GIOChannel* chan;
	guint _tmp7_;
	guint src_id;
	GError * err;
	Block5Data* _data5_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* extract_command;
	gchar** _tmp12_;
	gint _tmp13_;
	GPid _tmp14_;
	GError * err2;
	GError * _inner_error_;
};


static gpointer dock_manager_helper_daemon_parent_class = NULL;
static DockManagerDaemonInterfaceIface* dock_manager_helper_daemon_dock_manager_daemon_interface_parent_iface = NULL;

#define DOCK_MANAGER_GROUP_NAME "DockmanagerHelper"
GType dock_manager_helper_process_info_get_type (void) G_GNUC_CONST;
DockManagerHelperProcessInfo* dock_manager_helper_process_info_dup (const DockManagerHelperProcessInfo* self);
void dock_manager_helper_process_info_free (DockManagerHelperProcessInfo* self);
DockManagerDaemonInterface* dock_manager_daemon_interface_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path);
GType dock_manager_helper_info_get_type (void) G_GNUC_CONST;
DockManagerHelperInfo* dock_manager_helper_info_dup (const DockManagerHelperInfo* self);
void dock_manager_helper_info_free (DockManagerHelperInfo* self);
void dock_manager_helper_info_copy (const DockManagerHelperInfo* self, DockManagerHelperInfo* dest);
void dock_manager_helper_info_destroy (DockManagerHelperInfo* self);
GType dock_manager_daemon_interface_get_type (void) G_GNUC_CONST;
GType dock_manager_helper_daemon_get_type (void) G_GNUC_CONST;
GType dock_manager_dbus_watcher_get_type (void) G_GNUC_CONST;
#define DOCK_MANAGER_HELPER_DAEMON_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DOCK_MANAGER_TYPE_HELPER_DAEMON, DockManagerHelperDaemonPrivate))
enum  {
	DOCK_MANAGER_HELPER_DAEMON_DUMMY_PROPERTY,
	DOCK_MANAGER_HELPER_DAEMON_HELPER_LIST
};
static void _dock_manager_helper_info_free0_ (gpointer var);
static void _g_list_free__dock_manager_helper_info_free0_ (GList* self);
DockManagerHelperDaemon* dock_manager_helper_daemon_new (void);
DockManagerHelperDaemon* dock_manager_helper_daemon_construct (GType object_type);
static void _g_free0_ (gpointer var);
static void _dock_manager_helper_process_info_free0_ (gpointer var);
DockManagerDBusWatcher* dock_manager_dbus_watcher_get_default (void);
gboolean dock_manager_dbus_watcher_name_has_owner (DockManagerDBusWatcher* self, const gchar* name);
static void _lambda0_ (DockManagerHelperDaemon* self);
void dock_manager_helper_daemon_run_helpers (DockManagerHelperDaemon* self);
static void __lambda0__dock_manager_dbus_watcher_name_appeared (DockManagerDBusWatcher* _sender, const gchar* name, gpointer self);
static void _lambda6_ (DockManagerHelperDaemon* self);
static void dock_manager_helper_daemon_kill_all (DockManagerHelperDaemon* self);
static void __lambda6__dock_manager_dbus_watcher_name_disappeared (DockManagerDBusWatcher* _sender, const gchar* name, gpointer self);
static void dock_manager_helper_daemon_real_constructed (GObject* base);
void dock_manager_helper_daemon_run (DockManagerHelperDaemon* self);
#define DOCK_MANAGER_DBUS_UNIQUE_NAME "net.launchpad.DockManager.Daemon"
static guint _dynamic_request_name0 (DBusGProxy* self, const gchar* param1, guint param2, GError** error);
#define DOCK_MANAGER_DBUS_OBJECT_PATH_NAME "/net/launchpad/DockManager/Daemon"
static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object);
static void _vala_dbus_unregister_object (gpointer connection, GObject* object);
static void dock_manager_helper_daemon_init (DockManagerHelperDaemon* self);
static void _g_object_unref0_ (gpointer var);
static void _g_slist_free__g_object_unref0_ (GSList* self);
void dock_manager_daemon_interface_enable_helper (DockManagerDaemonInterface* self, const gchar* path, GError** error);
static gint dock_manager_helper_daemon_get_helper_pid (DockManagerHelperDaemon* self, const gchar* path);
static gchar* dock_manager_helper_daemon_get_helper_dbus_name (DockManagerHelperDaemon* self, const gchar* path);
static gboolean dock_manager_helper_daemon_is_helper_enabled (DockManagerHelperDaemon* self, const gchar* path);
static void dock_manager_helper_daemon_real_enable_helper (DockManagerDaemonInterface* base, const gchar* path, GError** error);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (Block1Data* _data1_);
static DockManagerHelperProcessInfo* dock_manager_helper_daemon_update_helper (DockManagerHelperDaemon* self, const gchar* path);
static void _lambda1_ (Block1Data* _data1_);
static void __lambda1__gcallback (gpointer self);
static void _lambda2_ (Block1Data* _data1_);
static gboolean _lambda3_ (Block1Data* _data1_);
static void dock_manager_helper_daemon_kill_helper (DockManagerHelperDaemon* self, const gchar* path);
static gboolean __lambda3__gsource_func (gpointer self);
static void __lambda2__gcallback (gpointer self);
static void _lambda5_ (GPid pid, gint status, Block1Data* _data1_);
static void __lambda5__gchild_watch_func (GPid pid, gint status, gpointer self);
static void dock_manager_helper_daemon_real_disable_helper (DockManagerDaemonInterface* base, const gchar* path, GError** error);
void dock_manager_helper_daemon_set_helper_list (DockManagerHelperDaemon* self, GValueArray* value);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (Block2Data* _data2_);
static gboolean _lambda4_ (Block2Data* _data2_);
static gboolean __lambda4__gsource_func (gpointer self);
static void dock_manager_helper_daemon_real_install_helper_data_free (gpointer _data);
static void dock_manager_helper_daemon_real_install_helper (DockManagerDaemonInterface* base, const gchar* filename, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean dock_manager_helper_daemon_real_install_helper_co (DockManagerHelperDaemonInstallHelperData* data);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (Block3Data* _data3_);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (Block4Data* _data4_);
static gboolean _lambda7_ (GIOChannel* src, GIOCondition cond, Block4Data* _data4_);
static gboolean __lambda7__gio_func (GIOChannel* source, GIOCondition condition, gpointer self);
static void _lambda8_ (GPid p, gint status, Block4Data* _data4_);
void dock_manager_daemon_interface_install_helper (DockManagerDaemonInterface* self, const gchar* filename, GAsyncReadyCallback _callback_, gpointer _user_data_);
gboolean dock_manager_daemon_interface_install_helper_finish (DockManagerDaemonInterface* self, GAsyncResult* _res_, GError** error);
static void __lambda8__gchild_watch_func (GPid pid, gint status, gpointer self);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (Block5Data* _data5_);
static void _lambda9_ (GPid p, gint status, Block5Data* _data5_);
static void __lambda9__gchild_watch_func (GPid pid, gint status, gpointer self);
static void dock_manager_helper_daemon_real_show_preferences (DockManagerDaemonInterface* base, GError** error);
static void dock_manager_helper_daemon_real_embed_preferences (DockManagerDaemonInterface* base, gint64 xid, GHashTable* hints, GError** error);
static DockManagerHelperInfo* dock_manager_helper_daemon_real_get_all_helpers (DockManagerDaemonInterface* base, int* result_length1, GError** error);
static void _vala_DockManagerHelperInfo_array_free (DockManagerHelperInfo* array, gint array_length);
static void dock_manager_helper_daemon_real_restart_all (DockManagerDaemonInterface* base, GError** error);
gint dock_manager_helper_daemon_main (gchar** argv, int argv_length1);
GValueArray* dock_manager_helper_daemon_get_helper_list (DockManagerHelperDaemon* self);
static void dock_manager_helper_daemon_finalize (GObject* obj);
void dock_manager_helper_daemon_dbus_register_object (DBusConnection* connection, const char* path, void* object);
void _dock_manager_helper_daemon_dbus_unregister (DBusConnection* connection, void* _user_data_);
DBusHandlerResult dock_manager_helper_daemon_dbus_message (DBusConnection* connection, DBusMessage* message, void* object);
static DBusHandlerResult _dbus_dock_manager_helper_daemon_introspect (DockManagerHelperDaemon* self, DBusConnection* connection, DBusMessage* message);
static void _vala_dock_manager_helper_daemon_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_dock_manager_helper_daemon_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const DBusObjectPathVTable _dock_manager_helper_daemon_dbus_path_vtable = {_dock_manager_helper_daemon_dbus_unregister, dock_manager_helper_daemon_dbus_message};
static const _DBusObjectVTable _dock_manager_helper_daemon_dbus_vtable = {dock_manager_helper_daemon_dbus_register_object};

DockManagerHelperProcessInfo* dock_manager_helper_process_info_dup (const DockManagerHelperProcessInfo* self) {
	DockManagerHelperProcessInfo* dup;
	dup = g_new0 (DockManagerHelperProcessInfo, 1);
	memcpy (dup, self, sizeof (DockManagerHelperProcessInfo));
	return dup;
}


void dock_manager_helper_process_info_free (DockManagerHelperProcessInfo* self) {
	g_free (self);
}


GType dock_manager_helper_process_info_get_type (void) {
	static volatile gsize dock_manager_helper_process_info_type_id__volatile = 0;
	if (g_once_init_enter (&dock_manager_helper_process_info_type_id__volatile)) {
		GType dock_manager_helper_process_info_type_id;
		dock_manager_helper_process_info_type_id = g_boxed_type_register_static ("DockManagerHelperProcessInfo", (GBoxedCopyFunc) dock_manager_helper_process_info_dup, (GBoxedFreeFunc) dock_manager_helper_process_info_free);
		g_once_init_leave (&dock_manager_helper_process_info_type_id__volatile, dock_manager_helper_process_info_type_id);
	}
	return dock_manager_helper_process_info_type_id__volatile;
}


static void _dock_manager_helper_info_free0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (dock_manager_helper_info_free (var), NULL));
}


static void _g_list_free__dock_manager_helper_info_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) _dock_manager_helper_info_free0_, NULL);
	g_list_free (self);
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _dock_manager_helper_process_info_free0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (dock_manager_helper_process_info_free (var), NULL));
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _lambda0_ (DockManagerHelperDaemon* self) {
	self->priv->dock_running = TRUE;
	dock_manager_helper_daemon_run_helpers (self);
}


static void __lambda0__dock_manager_dbus_watcher_name_appeared (DockManagerDBusWatcher* _sender, const gchar* name, gpointer self) {
	_lambda0_ (self);
}


static void _lambda6_ (DockManagerHelperDaemon* self) {
	self->priv->dock_running = FALSE;
	dock_manager_helper_daemon_kill_all (self);
}


static void __lambda6__dock_manager_dbus_watcher_name_disappeared (DockManagerDBusWatcher* _sender, const gchar* name, gpointer self) {
	_lambda6_ (self);
}


DockManagerHelperDaemon* dock_manager_helper_daemon_construct (GType object_type) {
	DockManagerHelperDaemon * self = NULL;
	GMainLoop* _tmp0_ = NULL;
	GMainLoop* _tmp1_;
	GHashTable* _tmp2_ = NULL;
	GHashTable* _tmp3_;
	GList* _tmp4_;
	DockManagerDBusWatcher* _tmp5_ = NULL;
	DockManagerDBusWatcher* _tmp6_;
	DockManagerDBusWatcher* _tmp7_;
	gboolean _tmp8_;
	self = (DockManagerHelperDaemon*) g_object_new (object_type, NULL);
	_tmp0_ = g_main_loop_new (NULL, FALSE);
	_tmp1_ = _tmp0_;
	_g_main_loop_unref0 (self->priv->main_loop);
	self->priv->main_loop = _tmp1_;
	_tmp2_ = g_hash_table_new_full (g_str_hash, g_str_equal, _g_free0_, _dock_manager_helper_process_info_free0_);
	_tmp3_ = _tmp2_;
	_g_hash_table_unref0 (self->priv->helper_process_info);
	self->priv->helper_process_info = _tmp3_;
	_tmp4_ = NULL;
	__g_list_free__dock_manager_helper_info_free0_0 (self->priv->all_scripts);
	self->priv->all_scripts = _tmp4_;
	_tmp5_ = dock_manager_dbus_watcher_get_default ();
	_tmp6_ = _g_object_ref0 (_tmp5_);
	_tmp7_ = _tmp6_;
	_g_object_unref0 (self->priv->watcher);
	self->priv->watcher = _tmp7_;
	_tmp8_ = dock_manager_dbus_watcher_name_has_owner (self->priv->watcher, "net.launchpad.DockManager");
	self->priv->dock_running = _tmp8_;
	g_signal_connect_object (self->priv->watcher, "name-appeared::net.launchpad.DockManager", (GCallback) __lambda0__dock_manager_dbus_watcher_name_appeared, self, 0);
	g_signal_connect_object (self->priv->watcher, "name-disappeared::net.launchpad.DockManager", (GCallback) __lambda6__dock_manager_dbus_watcher_name_disappeared, self, 0);
	return self;
}


DockManagerHelperDaemon* dock_manager_helper_daemon_new (void) {
	return dock_manager_helper_daemon_construct (DOCK_MANAGER_TYPE_HELPER_DAEMON);
}


static void dock_manager_helper_daemon_real_constructed (GObject* base) {
	DockManagerHelperDaemon * self;
	gchar* _tmp0_;
	gchar* schema_filename;
	gchar* schema_full;
	DesktopAgnosticConfigClient* _tmp1_ = NULL;
	DesktopAgnosticConfigClient* client;
	GError * _inner_error_ = NULL;
	self = (DockManagerHelperDaemon*) base;
	_tmp0_ = g_strdup ("dockmanager-daemon.schema-ini");
	schema_filename = _tmp0_;
	schema_full = g_strconcat (SCHEMAFILEDIR "/", schema_filename, NULL);
	_tmp1_ = desktop_agnostic_config_client_new (schema_full);
	client = _tmp1_;
	desktop_agnostic_config_client_bind (client, "DEFAULT", "helper_list", (GObject*) self, "helper-list", FALSE, DESKTOP_AGNOSTIC_CONFIG_BIND_METHOD_FALLBACK, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DESKTOP_AGNOSTIC_CONFIG_ERROR) {
			goto __catch0_desktop_agnostic_config_error;
		}
		_g_object_unref0 (client);
		_g_free0 (schema_full);
		_g_free0 (schema_filename);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	goto __finally0;
	__catch0_desktop_agnostic_config_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("dockmanager-daemon.vala:95: %s", err->message);
		_g_error_free0 (err);
	}
	__finally0:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (client);
		_g_free0 (schema_full);
		_g_free0 (schema_filename);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (client);
	_g_free0 (schema_full);
	_g_free0 (schema_filename);
}


static guint _dynamic_request_name0 (DBusGProxy* self, const gchar* param1, guint param2, GError** error) {
	guint result;
	dbus_g_proxy_call (self, "RequestName", error, G_TYPE_STRING, param1, G_TYPE_UINT, param2, G_TYPE_INVALID, G_TYPE_UINT, &result, G_TYPE_INVALID);
	if (*error) {
		return 0U;
	}
	return result;
}


static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	const _DBusObjectVTable * vtable;
	vtable = g_type_get_qdata (G_TYPE_FROM_INSTANCE (object), g_quark_from_static_string ("DBusObjectVTable"));
	if (vtable) {
		vtable->register_object (connection, path, object);
	} else {
		g_warning ("Object does not implement any D-Bus interface");
	}
}


static void _vala_dbus_unregister_object (gpointer connection, GObject* object) {
	char* path;
	path = g_object_steal_data ((GObject*) object, "dbus_object_path");
	dbus_connection_unregister_object_path (connection, path);
	g_free (path);
}


void dock_manager_helper_daemon_run (DockManagerHelperDaemon* self) {
	DBusGConnection* _tmp0_ = NULL;
	DBusGConnection* connection;
	DBusGProxy* _tmp1_ = NULL;
	DBusGProxy* bus;
	guint _tmp2_;
	guint request_name_result;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = dbus_g_bus_get (DBUS_BUS_SESSION, &_inner_error_);
	connection = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DBUS_GERROR) {
			goto __catch1_dbus_gerror;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp1_ = dbus_g_proxy_new_for_name (connection, "org.freedesktop.DBus", "/org/freedesktop/DBus", "org.freedesktop.DBus");
	bus = _tmp1_;
	_tmp2_ = _dynamic_request_name0 (bus, DOCK_MANAGER_DBUS_UNIQUE_NAME, (guint) DBUS_NAME_FLAG_DO_NOT_QUEUE, &_inner_error_);
	request_name_result = _tmp2_;
	if (_inner_error_ != NULL) {
		_g_object_unref0 (bus);
		_dbus_g_connection_unref0 (connection);
		if (_inner_error_->domain == DBUS_GERROR) {
			goto __catch1_dbus_gerror;
		}
		goto __finally1;
	}
	if (request_name_result == DBUS_REQUEST_NAME_REPLY_PRIMARY_OWNER) {
		_vala_dbus_register_object (dbus_g_connection_get_connection (connection), DOCK_MANAGER_DBUS_OBJECT_PATH_NAME, (GObject*) self);
		dock_manager_helper_daemon_init (self);
		dock_manager_helper_daemon_run_helpers (self);
		g_main_loop_run (self->priv->main_loop);
		dock_manager_helper_daemon_kill_all (self);
	} else {
		g_error ("dockmanager-daemon.vala:124: Another instance of DockManager daemon is" \
" already running!");
	}
	_g_object_unref0 (bus);
	_dbus_g_connection_unref0 (connection);
	goto __finally1;
	__catch1_dbus_gerror:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("dockmanager-daemon.vala:129: %s", err->message);
		_g_error_free0 (err);
	}
	__finally1:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static gpointer _dock_manager_helper_info_dup0 (gpointer self) {
	return self ? dock_manager_helper_info_dup (self) : NULL;
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_slist_free__g_object_unref0_ (GSList* self) {
	g_slist_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_slist_free (self);
}


static void dock_manager_helper_daemon_init (DockManagerHelperDaemon* self) {
	gchar* _tmp0_;
	const gchar* _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	gchar** prefixes;
	gint prefixes_length1;
	gint _prefixes_size_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (PKGDATADIR);
	_tmp1_ = g_get_user_data_dir ();
	_tmp2_ = g_new0 (gchar*, 2 + 1);
	_tmp2_[0] = _tmp0_;
	_tmp2_[1] = g_strconcat (_tmp1_, "/dockmanager", NULL);
	prefixes = _tmp2_;
	prefixes_length1 = 2;
	_prefixes_size_ = 2;
	{
		gchar** prefix_collection;
		int prefix_collection_length1;
		int prefix_it;
		prefix_collection = prefixes;
		prefix_collection_length1 = prefixes_length1;
		for (prefix_it = 0; prefix_it < prefixes_length1; prefix_it = prefix_it + 1) {
			const gchar* prefix;
			prefix = prefix_collection[prefix_it];
			{
				gchar* path;
				gchar* metadata_dir;
				DesktopAgnosticVFSFile* _tmp3_ = NULL;
				DesktopAgnosticVFSFile* scripts_dir;
				gboolean _tmp4_;
				GSList* _tmp5_ = NULL;
				GSList* _tmp6_;
				path = g_strconcat (prefix, "/scripts", NULL);
				metadata_dir = g_strconcat (prefix, "/metadata/", NULL);
				_tmp3_ = desktop_agnostic_vfs_file_new_for_path (path, &_inner_error_);
				scripts_dir = _tmp3_;
				if (_inner_error_ != NULL) {
					_g_free0 (metadata_dir);
					_g_free0 (path);
					prefixes = (_vala_array_free (prefixes, prefixes_length1, (GDestroyNotify) g_free), NULL);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
				_tmp4_ = desktop_agnostic_vfs_file_exists (scripts_dir);
				if (!_tmp4_) {
					_g_object_unref0 (scripts_dir);
					_g_free0 (metadata_dir);
					_g_free0 (path);
					continue;
				}
				_tmp5_ = desktop_agnostic_vfs_file_enumerate_children (scripts_dir, &_inner_error_);
				_tmp6_ = _tmp5_;
				if (_inner_error_ != NULL) {
					_g_object_unref0 (scripts_dir);
					_g_free0 (metadata_dir);
					_g_free0 (path);
					prefixes = (_vala_array_free (prefixes, prefixes_length1, (GDestroyNotify) g_free), NULL);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
				{
					GSList* f_collection;
					GSList* f_it;
					f_collection = _tmp6_;
					for (f_it = f_collection; f_it != NULL; f_it = f_it->next) {
						DesktopAgnosticVFSFile* _tmp7_;
						DesktopAgnosticVFSFile* f;
						_tmp7_ = _g_object_ref0 ((DesktopAgnosticVFSFile*) f_it->data);
						f = _tmp7_;
						{
							DockManagerHelperInfo hi = {0};
							gchar* _tmp8_ = NULL;
							gchar* _tmp9_;
							DockManagerHelperInfo* _tmp10_;
							memset (&hi, 0, sizeof (DockManagerHelperInfo));
							_tmp8_ = desktop_agnostic_vfs_file_get_path (f);
							_tmp9_ = _tmp8_;
							_g_free0 (hi.path);
							hi.path = _tmp9_;
							hi.app_available = TRUE;
							_tmp10_ = _dock_manager_helper_info_dup0 (&hi);
							self->priv->all_scripts = g_list_append (self->priv->all_scripts, _tmp10_);
							dock_manager_helper_info_destroy (&hi);
							_g_object_unref0 (f);
						}
					}
					__g_slist_free__g_object_unref0_0 (f_collection);
				}
				{
					GList* hi_collection;
					GList* hi_it;
					hi_collection = self->priv->all_scripts;
					for (hi_it = hi_collection; hi_it != NULL; hi_it = hi_it->next) {
						DockManagerHelperInfo* hi;
						hi = (DockManagerHelperInfo*) hi_it->data;
						{
							gchar* _tmp11_ = NULL;
							gchar* _tmp12_;
							gchar* _tmp13_;
							gchar* _tmp14_;
							gchar* metadata;
							DesktopAgnosticVFSFile* _tmp15_ = NULL;
							DesktopAgnosticVFSFile* metadata_file;
							gboolean _tmp16_;
							gchar* contents = NULL;
							gsize length = 0UL;
							gchar* _tmp17_ = NULL;
							gsize _tmp18_;
							GKeyFile* _tmp19_ = NULL;
							GKeyFile* keyfile;
							gchar* _tmp20_ = NULL;
							gchar* _tmp21_;
							gchar* _tmp22_;
							gchar* _tmp23_ = NULL;
							gchar* _tmp24_;
							gchar* _tmp25_;
							gchar* _tmp26_ = NULL;
							gchar* _tmp27_;
							gchar* _tmp28_;
							gchar* _tmp29_ = NULL;
							gchar* _tmp30_;
							gchar* _tmp31_;
							gchar* _tmp32_ = NULL;
							gchar* _tmp33_;
							gchar* _tmp34_ = NULL;
							gchar* _tmp35_;
							gchar* _tmp36_;
							_tmp11_ = g_path_get_basename ((*hi).path);
							_tmp12_ = _tmp11_;
							_tmp13_ = g_strconcat (metadata_dir, _tmp12_, NULL);
							metadata = (_tmp14_ = g_strconcat (_tmp13_, ".info", NULL), _g_free0 (_tmp13_), _g_free0 (_tmp12_), _tmp14_);
							_tmp15_ = desktop_agnostic_vfs_file_new_for_path (metadata, &_inner_error_);
							metadata_file = _tmp15_;
							if (_inner_error_ != NULL) {
								_g_free0 (metadata);
								_g_object_unref0 (scripts_dir);
								_g_free0 (metadata_dir);
								_g_free0 (path);
								prefixes = (_vala_array_free (prefixes, prefixes_length1, (GDestroyNotify) g_free), NULL);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return;
							}
							_tmp16_ = desktop_agnostic_vfs_file_exists (metadata_file);
							if (!_tmp16_) {
								_g_object_unref0 (metadata_file);
								_g_free0 (metadata);
								continue;
							}
							desktop_agnostic_vfs_file_load_contents (metadata_file, &_tmp17_, &_tmp18_, &_inner_error_);
							_g_free0 (contents);
							contents = _tmp17_;
							length = _tmp18_;
							if (_inner_error_ != NULL) {
								_g_free0 (contents);
								_g_object_unref0 (metadata_file);
								_g_free0 (metadata);
								_g_object_unref0 (scripts_dir);
								_g_free0 (metadata_dir);
								_g_free0 (path);
								prefixes = (_vala_array_free (prefixes, prefixes_length1, (GDestroyNotify) g_free), NULL);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return;
							}
							_tmp19_ = g_key_file_new ();
							keyfile = _tmp19_;
							g_key_file_load_from_data (keyfile, contents, length, G_KEY_FILE_NONE, &_inner_error_);
							if (_inner_error_ != NULL) {
								if (_inner_error_->domain == G_KEY_FILE_ERROR) {
									goto __catch2_g_key_file_error;
								}
								_g_key_file_free0 (keyfile);
								_g_free0 (contents);
								_g_object_unref0 (metadata_file);
								_g_free0 (metadata);
								_g_object_unref0 (scripts_dir);
								_g_free0 (metadata_dir);
								_g_free0 (path);
								prefixes = (_vala_array_free (prefixes, prefixes_length1, (GDestroyNotify) g_free), NULL);
								g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return;
							}
							goto __finally2;
							__catch2_g_key_file_error:
							{
								GError * err;
								err = _inner_error_;
								_inner_error_ = NULL;
								g_warning ("dockmanager-daemon.vala:173: Cannot load %s: %s", metadata, err->message);
								_g_error_free0 (err);
								_g_key_file_free0 (keyfile);
								_g_free0 (contents);
								_g_object_unref0 (metadata_file);
								_g_free0 (metadata);
								continue;
							}
							__finally2:
							if (_inner_error_ != NULL) {
								_g_key_file_free0 (keyfile);
								_g_free0 (contents);
								_g_object_unref0 (metadata_file);
								_g_free0 (metadata);
								_g_object_unref0 (scripts_dir);
								_g_free0 (metadata_dir);
								_g_free0 (path);
								prefixes = (_vala_array_free (prefixes, prefixes_length1, (GDestroyNotify) g_free), NULL);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return;
							}
							_tmp20_ = g_key_file_get_string (keyfile, DOCK_MANAGER_GROUP_NAME, "Name", &_inner_error_);
							_tmp21_ = _tmp20_;
							if (_inner_error_ != NULL) {
								if (_inner_error_->domain == G_KEY_FILE_ERROR) {
									goto __catch3_g_key_file_error;
								}
								_g_key_file_free0 (keyfile);
								_g_free0 (contents);
								_g_object_unref0 (metadata_file);
								_g_free0 (metadata);
								_g_object_unref0 (scripts_dir);
								_g_free0 (metadata_dir);
								_g_free0 (path);
								prefixes = (_vala_array_free (prefixes, prefixes_length1, (GDestroyNotify) g_free), NULL);
								g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return;
							}
							_tmp22_ = _tmp21_;
							_g_free0 ((*hi).name);
							(*hi).name = _tmp22_;
							_tmp23_ = g_key_file_get_string (keyfile, DOCK_MANAGER_GROUP_NAME, "Description", &_inner_error_);
							_tmp24_ = _tmp23_;
							if (_inner_error_ != NULL) {
								if (_inner_error_->domain == G_KEY_FILE_ERROR) {
									goto __catch3_g_key_file_error;
								}
								_g_key_file_free0 (keyfile);
								_g_free0 (contents);
								_g_object_unref0 (metadata_file);
								_g_free0 (metadata);
								_g_object_unref0 (scripts_dir);
								_g_free0 (metadata_dir);
								_g_free0 (path);
								prefixes = (_vala_array_free (prefixes, prefixes_length1, (GDestroyNotify) g_free), NULL);
								g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return;
							}
							_tmp25_ = _tmp24_;
							_g_free0 ((*hi).description);
							(*hi).description = _tmp25_;
							goto __finally3;
							__catch3_g_key_file_error:
							{
								GError * err;
								err = _inner_error_;
								_inner_error_ = NULL;
								g_warning ("dockmanager-daemon.vala:184: Required key missing in %s", metadata);
								_g_error_free0 (err);
								_g_key_file_free0 (keyfile);
								_g_free0 (contents);
								_g_object_unref0 (metadata_file);
								_g_free0 (metadata);
								continue;
							}
							__finally3:
							if (_inner_error_ != NULL) {
								_g_key_file_free0 (keyfile);
								_g_free0 (contents);
								_g_object_unref0 (metadata_file);
								_g_free0 (metadata);
								_g_object_unref0 (scripts_dir);
								_g_free0 (metadata_dir);
								_g_free0 (path);
								prefixes = (_vala_array_free (prefixes, prefixes_length1, (GDestroyNotify) g_free), NULL);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return;
							}
							_tmp26_ = g_key_file_get_string (keyfile, DOCK_MANAGER_GROUP_NAME, "Icon", &_inner_error_);
							_tmp27_ = _tmp26_;
							if (_inner_error_ != NULL) {
								if (_inner_error_->domain == G_KEY_FILE_ERROR) {
									goto __catch4_g_key_file_error;
								}
								_g_key_file_free0 (keyfile);
								_g_free0 (contents);
								_g_object_unref0 (metadata_file);
								_g_free0 (metadata);
								_g_object_unref0 (scripts_dir);
								_g_free0 (metadata_dir);
								_g_free0 (path);
								prefixes = (_vala_array_free (prefixes, prefixes_length1, (GDestroyNotify) g_free), NULL);
								g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return;
							}
							_tmp28_ = _tmp27_;
							_g_free0 ((*hi).icon_name);
							(*hi).icon_name = _tmp28_;
							goto __finally4;
							__catch4_g_key_file_error:
							{
								GError * err;
								err = _inner_error_;
								_inner_error_ = NULL;
								_g_error_free0 (err);
							}
							__finally4:
							if (_inner_error_ != NULL) {
								_g_key_file_free0 (keyfile);
								_g_free0 (contents);
								_g_object_unref0 (metadata_file);
								_g_free0 (metadata);
								_g_object_unref0 (scripts_dir);
								_g_free0 (metadata_dir);
								_g_free0 (path);
								prefixes = (_vala_array_free (prefixes, prefixes_length1, (GDestroyNotify) g_free), NULL);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return;
							}
							_tmp29_ = g_key_file_get_string (keyfile, DOCK_MANAGER_GROUP_NAME, "AppName", &_inner_error_);
							_tmp30_ = _tmp29_;
							if (_inner_error_ != NULL) {
								goto __catch5_g_error;
							}
							_tmp31_ = _tmp30_;
							_g_free0 ((*hi).app_name);
							(*hi).app_name = _tmp31_;
							_tmp32_ = g_find_program_in_path ((*hi).app_name);
							_tmp33_ = _tmp32_;
							(*hi).app_available = _tmp33_ != NULL;
							_g_free0 (_tmp33_);
							goto __finally5;
							__catch5_g_error:
							{
								GError * err;
								err = _inner_error_;
								_inner_error_ = NULL;
								g_warning ("dockmanager-daemon.vala:201: %s", err->message);
								_g_error_free0 (err);
							}
							__finally5:
							if (_inner_error_ != NULL) {
								_g_key_file_free0 (keyfile);
								_g_free0 (contents);
								_g_object_unref0 (metadata_file);
								_g_free0 (metadata);
								_g_object_unref0 (scripts_dir);
								_g_free0 (metadata_dir);
								_g_free0 (path);
								prefixes = (_vala_array_free (prefixes, prefixes_length1, (GDestroyNotify) g_free), NULL);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return;
							}
							_tmp34_ = g_key_file_get_string (keyfile, DOCK_MANAGER_GROUP_NAME, "DBusName", &_inner_error_);
							_tmp35_ = _tmp34_;
							if (_inner_error_ != NULL) {
								if (_inner_error_->domain == G_KEY_FILE_ERROR) {
									goto __catch6_g_key_file_error;
								}
								_g_key_file_free0 (keyfile);
								_g_free0 (contents);
								_g_object_unref0 (metadata_file);
								_g_free0 (metadata);
								_g_object_unref0 (scripts_dir);
								_g_free0 (metadata_dir);
								_g_free0 (path);
								prefixes = (_vala_array_free (prefixes, prefixes_length1, (GDestroyNotify) g_free), NULL);
								g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return;
							}
							_tmp36_ = _tmp35_;
							_g_free0 ((*hi).dbus_name);
							(*hi).dbus_name = _tmp36_;
							goto __finally6;
							__catch6_g_key_file_error:
							{
								GError * err;
								err = _inner_error_;
								_inner_error_ = NULL;
								_g_error_free0 (err);
							}
							__finally6:
							if (_inner_error_ != NULL) {
								_g_key_file_free0 (keyfile);
								_g_free0 (contents);
								_g_object_unref0 (metadata_file);
								_g_free0 (metadata);
								_g_object_unref0 (scripts_dir);
								_g_free0 (metadata_dir);
								_g_free0 (path);
								prefixes = (_vala_array_free (prefixes, prefixes_length1, (GDestroyNotify) g_free), NULL);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return;
							}
							_g_key_file_free0 (keyfile);
							_g_free0 (contents);
							_g_object_unref0 (metadata_file);
							_g_free0 (metadata);
						}
					}
				}
				_g_object_unref0 (scripts_dir);
				_g_free0 (metadata_dir);
				_g_free0 (path);
			}
		}
	}
	prefixes = (_vala_array_free (prefixes, prefixes_length1, (GDestroyNotify) g_free), NULL);
}


void dock_manager_helper_daemon_run_helpers (DockManagerHelperDaemon* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GValueArray* v_collection;
		guint v_index;
		v_collection = self->priv->_helper_list;
		for (v_index = 0; v_index < v_collection->n_values; v_index = v_index + 1) {
			GValue _tmp0_ = {0};
			GValue v;
			v = G_IS_VALUE (g_value_array_get_nth (v_collection, v_index)) ? (g_value_init (&_tmp0_, G_VALUE_TYPE (g_value_array_get_nth (v_collection, v_index))), g_value_copy (g_value_array_get_nth (v_collection, v_index), &_tmp0_), _tmp0_) : (*g_value_array_get_nth (v_collection, v_index));
			{
				const gchar* _tmp1_ = NULL;
				const gchar* helper;
				_tmp1_ = g_value_get_string (&v);
				helper = _tmp1_;
				dock_manager_daemon_interface_enable_helper ((DockManagerDaemonInterface*) self, helper, &_inner_error_);
				if (_inner_error_ != NULL) {
					G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
				G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
			}
		}
	}
}


static gint dock_manager_helper_daemon_get_helper_pid (DockManagerHelperDaemon* self, const gchar* path) {
	gint result = 0;
	gconstpointer _tmp0_ = NULL;
	DockManagerHelperProcessInfo* hpi;
	gint _tmp1_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (path != NULL, 0);
	_tmp0_ = g_hash_table_lookup (self->priv->helper_process_info, path);
	hpi = (DockManagerHelperProcessInfo*) _tmp0_;
	if (hpi != NULL) {
		_tmp1_ = (*hpi).pid;
	} else {
		_tmp1_ = 0;
	}
	result = _tmp1_;
	return result;
}


static gchar* dock_manager_helper_daemon_get_helper_dbus_name (DockManagerHelperDaemon* self, const gchar* path) {
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (path != NULL, NULL);
	{
		GList* hi_collection;
		GList* hi_it;
		hi_collection = self->priv->all_scripts;
		for (hi_it = hi_collection; hi_it != NULL; hi_it = hi_it->next) {
			DockManagerHelperInfo* hi;
			hi = (DockManagerHelperInfo*) hi_it->data;
			{
				if (g_strcmp0 ((*hi).path, path) == 0) {
					gchar* _tmp0_;
					_tmp0_ = g_strdup ((*hi).dbus_name);
					result = _tmp0_;
					return result;
				}
			}
		}
	}
	result = NULL;
	return result;
}


static gboolean dock_manager_helper_daemon_is_helper_enabled (DockManagerHelperDaemon* self, const gchar* path) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (path != NULL, FALSE);
	{
		GValueArray* v_collection;
		guint v_index;
		v_collection = self->priv->_helper_list;
		for (v_index = 0; v_index < v_collection->n_values; v_index = v_index + 1) {
			GValue _tmp0_ = {0};
			GValue v;
			v = G_IS_VALUE (g_value_array_get_nth (v_collection, v_index)) ? (g_value_init (&_tmp0_, G_VALUE_TYPE (g_value_array_get_nth (v_collection, v_index))), g_value_copy (g_value_array_get_nth (v_collection, v_index), &_tmp0_), _tmp0_) : (*g_value_array_get_nth (v_collection, v_index));
			{
				const gchar* _tmp1_ = NULL;
				_tmp1_ = g_value_get_string (&v);
				if (g_strcmp0 (_tmp1_, path) == 0) {
					result = TRUE;
					G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
					return result;
				}
				G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
			}
		}
	}
	result = FALSE;
	return result;
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (Block1Data* _data1_) {
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_g_object_unref0 (_data1_->self);
		_g_free0 (_data1_->path);
		g_slice_free (Block1Data, _data1_);
	}
}


static void _lambda1_ (Block1Data* _data1_) {
	DockManagerHelperDaemon * self;
	GError * _inner_error_ = NULL;
	self = _data1_->self;
	dock_manager_daemon_interface_enable_helper ((DockManagerDaemonInterface*) self, _data1_->path, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void __lambda1__gcallback (gpointer self) {
	_lambda1_ (self);
}


static gboolean _lambda3_ (Block1Data* _data1_) {
	DockManagerHelperDaemon * self;
	gboolean result = FALSE;
	self = _data1_->self;
	dock_manager_helper_daemon_kill_helper (self, _data1_->path);
	result = FALSE;
	return result;
}


static gboolean __lambda3__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda3_ (self);
	return result;
}


static void _lambda2_ (Block1Data* _data1_) {
	DockManagerHelperDaemon * self;
	self = _data1_->self;
	g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 1000, __lambda3__gsource_func, block1_data_ref (_data1_), block1_data_unref);
}


static void __lambda2__gcallback (gpointer self) {
	_lambda2_ (self);
}


static void _lambda5_ (GPid pid, gint status, Block1Data* _data1_) {
	DockManagerHelperDaemon * self;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	DockManagerHelperProcessInfo* _tmp2_ = NULL;
	DockManagerHelperProcessInfo* hpi;
	gboolean _tmp3_;
	self = _data1_->self;
	_tmp0_ = g_path_get_basename (_data1_->path);
	_tmp1_ = _tmp0_;
	g_debug ("dockmanager-daemon.vala:319: [%d] \"%s\" exitted", (gint) pid, _tmp1_);
	_g_free0 (_tmp1_);
	_tmp2_ = dock_manager_helper_daemon_update_helper (self, _data1_->path);
	hpi = _tmp2_;
	if ((*hpi).kill_timer_id != 0) {
		g_source_remove ((*hpi).kill_timer_id);
	}
	(*hpi).pid = 0;
	(*hpi).kill_timer_id = (guint) 0;
	g_spawn_close_pid (pid);
	_tmp3_ = dock_manager_helper_daemon_is_helper_enabled (self, _data1_->path);
	g_signal_emit_by_name ((DockManagerDaemonInterface*) self, "helper-state-changed", _data1_->path, _tmp3_, FALSE);
}


static void __lambda5__gchild_watch_func (GPid pid, gint status, gpointer self) {
	_lambda5_ (pid, status, self);
}


static void dock_manager_helper_daemon_real_enable_helper (DockManagerDaemonInterface* base, const gchar* path, GError** error) {
	DockManagerHelperDaemon * self;
	Block1Data* _data1_;
	GPid child_pid;
	gchar** argv = NULL;
	gint argv_length1 = 0;
	gint _argv_size_ = 0;
	gint _tmp0_;
	gboolean _tmp1_;
	gchar* _tmp3_ = NULL;
	gchar* dbus_name;
	gchar** _tmp12_ = NULL;
	gint _tmp13_;
	GSpawnFlags flags;
	GPid _tmp14_;
	DockManagerHelperProcessInfo* _tmp16_ = NULL;
	DockManagerHelperProcessInfo* hpi;
	GError * _inner_error_ = NULL;
	self = (DockManagerHelperDaemon*) base;
	g_return_if_fail (path != NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_data1_->path = g_strdup (path);
	child_pid = (GPid) 0;
	_tmp0_ = dock_manager_helper_daemon_get_helper_pid (self, _data1_->path);
	if (_tmp0_ != 0) {
		argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
		block1_data_unref (_data1_);
		_data1_ = NULL;
		return;
	}
	_tmp1_ = dock_manager_helper_daemon_is_helper_enabled (self, _data1_->path);
	if (!_tmp1_) {
		GValue _tmp2_ = {0};
		GValue p;
		g_value_init (&_tmp2_, G_TYPE_STRING);
		g_value_set_string (&_tmp2_, _data1_->path);
		p = _tmp2_;
		g_value_array_append (self->priv->_helper_list, &p);
		g_object_notify ((GObject*) self, "helper-list");
		G_IS_VALUE (&p) ? (g_value_unset (&p), NULL) : NULL;
	}
	if (!self->priv->dock_running) {
		g_signal_emit_by_name ((DockManagerDaemonInterface*) self, "helper-state-changed", _data1_->path, TRUE, FALSE);
		argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
		block1_data_unref (_data1_);
		_data1_ = NULL;
		return;
	}
	_tmp3_ = dock_manager_helper_daemon_get_helper_dbus_name (self, _data1_->path);
	dbus_name = _tmp3_;
	if (dbus_name != NULL) {
		DockManagerHelperProcessInfo* _tmp4_ = NULL;
		DockManagerHelperProcessInfo* hpi;
		gboolean _tmp11_;
		_tmp4_ = dock_manager_helper_daemon_update_helper (self, _data1_->path);
		hpi = _tmp4_;
		if ((*hpi).dbus_appear_id == 0) {
			gchar* _tmp5_ = NULL;
			gchar* _tmp6_;
			gulong _tmp7_;
			_tmp5_ = g_strdup_printf ("name-appeared::%s", dbus_name);
			_tmp6_ = _tmp5_;
			_tmp7_ = g_signal_connect_data (self->priv->watcher, _tmp6_, __lambda1__gcallback, block1_data_ref (_data1_), block1_data_unref, G_CONNECT_SWAPPED);
			(*hpi).dbus_appear_id = _tmp7_;
			_g_free0 (_tmp6_);
		}
		if ((*hpi).dbus_disappear_id == 0) {
			gchar* _tmp8_ = NULL;
			gchar* _tmp9_;
			gulong _tmp10_;
			_tmp8_ = g_strdup_printf ("name-disappeared::%s", dbus_name);
			_tmp9_ = _tmp8_;
			_tmp10_ = g_signal_connect_data (self->priv->watcher, _tmp9_, __lambda2__gcallback, block1_data_ref (_data1_), block1_data_unref, G_CONNECT_SWAPPED);
			(*hpi).dbus_disappear_id = _tmp10_;
			_g_free0 (_tmp9_);
		}
		_tmp11_ = dock_manager_dbus_watcher_name_has_owner (self->priv->watcher, dbus_name);
		if (!_tmp11_) {
			g_signal_emit_by_name ((DockManagerDaemonInterface*) self, "helper-state-changed", _data1_->path, TRUE, FALSE);
			_g_free0 (dbus_name);
			argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
			block1_data_unref (_data1_);
			_data1_ = NULL;
			return;
		}
	}
	g_shell_parse_argv (_data1_->path, &_tmp13_, &_tmp12_, &_inner_error_);
	argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
	argv = _tmp12_;
	argv_length1 = _tmp13_;
	if (_inner_error_ != NULL) {
		goto __catch7_g_error;
	}
	flags = G_SPAWN_DO_NOT_REAP_CHILD | G_SPAWN_SEARCH_PATH;
	g_spawn_async (NULL, argv, NULL, flags, NULL, NULL, &_tmp14_, &_inner_error_);
	child_pid = _tmp14_;
	if (_inner_error_ != NULL) {
		goto __catch7_g_error;
	}
	g_child_watch_add_full (G_PRIORITY_DEFAULT, child_pid, __lambda5__gchild_watch_func, block1_data_ref (_data1_), block1_data_unref);
	g_debug ("dockmanager-daemon.vala:331: Spawned \"%s\" [%d]", _data1_->path, (gint) child_pid);
	goto __finally7;
	__catch7_g_error:
	{
		GError * err;
		GError* _tmp15_ = NULL;
		err = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("dockmanager-daemon.vala:335: %s", err->message);
		_tmp15_ = g_error_new_literal (DBUS_GERROR, DBUS_GERROR_SPAWN_FAILED, err->message);
		_inner_error_ = _tmp15_;
		_g_error_free0 (err);
		goto __finally7;
	}
	__finally7:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DBUS_GERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (dbus_name);
			argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
			block1_data_unref (_data1_);
			_data1_ = NULL;
			return;
		} else {
			_g_free0 (dbus_name);
			argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
			block1_data_unref (_data1_);
			_data1_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp16_ = dock_manager_helper_daemon_update_helper (self, _data1_->path);
	hpi = _tmp16_;
	(*hpi).pid = (gint) child_pid;
	g_signal_emit_by_name ((DockManagerDaemonInterface*) self, "helper-state-changed", _data1_->path, TRUE, child_pid != 0);
	_g_free0 (dbus_name);
	argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
	block1_data_unref (_data1_);
	_data1_ = NULL;
}


static gpointer _dock_manager_helper_process_info_dup0 (gpointer self) {
	return self ? dock_manager_helper_process_info_dup (self) : NULL;
}


static DockManagerHelperProcessInfo* dock_manager_helper_daemon_update_helper (DockManagerHelperDaemon* self, const gchar* path) {
	DockManagerHelperProcessInfo* result = NULL;
	gconstpointer _tmp0_ = NULL;
	DockManagerHelperProcessInfo* hpi;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (path != NULL, NULL);
	_tmp0_ = g_hash_table_lookup (self->priv->helper_process_info, path);
	hpi = (DockManagerHelperProcessInfo*) _tmp0_;
	if (hpi != NULL) {
		result = hpi;
		return result;
	} else {
		DockManagerHelperProcessInfo pi = {0};
		gchar* _tmp1_;
		DockManagerHelperProcessInfo* _tmp2_;
		gconstpointer _tmp3_ = NULL;
		memset (&pi, 0, sizeof (DockManagerHelperProcessInfo));
		pi.pid = 0;
		pi.kill_timer_id = (guint) 0;
		pi.dbus_appear_id = (gulong) 0;
		pi.dbus_disappear_id = (gulong) 0;
		_tmp1_ = g_strdup (path);
		_tmp2_ = _dock_manager_helper_process_info_dup0 (&pi);
		g_hash_table_insert (self->priv->helper_process_info, _tmp1_, _tmp2_);
		_tmp3_ = g_hash_table_lookup (self->priv->helper_process_info, path);
		result = (DockManagerHelperProcessInfo*) _tmp3_;
		return result;
	}
}


static void dock_manager_helper_daemon_real_disable_helper (DockManagerDaemonInterface* base, const gchar* path, GError** error) {
	DockManagerHelperDaemon * self;
	gboolean _tmp0_;
	GValueArray* _tmp1_ = NULL;
	GValueArray* enabled_helpers;
	DockManagerHelperProcessInfo* _tmp4_ = NULL;
	DockManagerHelperProcessInfo* hpi;
	gint _tmp5_;
	self = (DockManagerHelperDaemon*) base;
	g_return_if_fail (path != NULL);
	_tmp0_ = dock_manager_helper_daemon_is_helper_enabled (self, path);
	if (!_tmp0_) {
		return;
	}
	_tmp1_ = g_value_array_new ((guint) 4);
	enabled_helpers = _tmp1_;
	{
		GValueArray* v_collection;
		guint v_index;
		v_collection = self->priv->_helper_list;
		for (v_index = 0; v_index < v_collection->n_values; v_index = v_index + 1) {
			GValue _tmp2_ = {0};
			GValue v;
			v = G_IS_VALUE (g_value_array_get_nth (v_collection, v_index)) ? (g_value_init (&_tmp2_, G_VALUE_TYPE (g_value_array_get_nth (v_collection, v_index))), g_value_copy (g_value_array_get_nth (v_collection, v_index), &_tmp2_), _tmp2_) : (*g_value_array_get_nth (v_collection, v_index));
			{
				const gchar* _tmp3_ = NULL;
				_tmp3_ = g_value_get_string (&v);
				if (g_strcmp0 (_tmp3_, path) != 0) {
					g_value_array_append (enabled_helpers, &v);
				}
				G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
			}
		}
	}
	dock_manager_helper_daemon_set_helper_list (self, enabled_helpers);
	_tmp4_ = dock_manager_helper_daemon_update_helper (self, path);
	hpi = _tmp4_;
	if ((*hpi).dbus_appear_id != 0) {
		g_signal_handler_disconnect (self->priv->watcher, (*hpi).dbus_appear_id);
		(*hpi).dbus_appear_id = (gulong) 0;
	}
	if ((*hpi).dbus_disappear_id != 0) {
		g_signal_handler_disconnect (self->priv->watcher, (*hpi).dbus_disappear_id);
		(*hpi).dbus_disappear_id = (gulong) 0;
	}
	if ((*hpi).pid == 0) {
		g_signal_emit_by_name ((DockManagerDaemonInterface*) self, "helper-state-changed", path, FALSE, FALSE);
		_g_value_array_free0 (enabled_helpers);
		return;
	}
	dock_manager_helper_daemon_kill_helper (self, path);
	_tmp5_ = dock_manager_helper_daemon_get_helper_pid (self, path);
	g_signal_emit_by_name ((DockManagerDaemonInterface*) self, "helper-state-changed", path, FALSE, _tmp5_ != 0);
	_g_value_array_free0 (enabled_helpers);
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (Block2Data* _data2_) {
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		_g_object_unref0 (_data2_->self);
		g_slice_free (Block2Data, _data2_);
	}
}


static gboolean _lambda4_ (Block2Data* _data2_) {
	DockManagerHelperDaemon * self;
	gboolean result = FALSE;
	self = _data2_->self;
	if ((*_data2_->hpi).pid != 0) {
		g_debug ("dockmanager-daemon.vala:413: Sending SIGKILL to %d", (*_data2_->hpi).pid);
		kill ((pid_t) (*_data2_->hpi).pid, SIGKILL);
	}
	(*_data2_->hpi).kill_timer_id = (guint) 0;
	result = FALSE;
	return result;
}


static gboolean __lambda4__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda4_ (self);
	return result;
}


static void dock_manager_helper_daemon_kill_helper (DockManagerHelperDaemon* self, const gchar* path) {
	Block2Data* _data2_;
	DockManagerHelperProcessInfo* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_tmp0_ = dock_manager_helper_daemon_update_helper (self, path);
	_data2_->hpi = _tmp0_;
	if ((*_data2_->hpi).pid == 0) {
		block2_data_unref (_data2_);
		_data2_ = NULL;
		return;
	}
	g_debug ("dockmanager-daemon.vala:404: Sending SIGTERM to %d", (*_data2_->hpi).pid);
	kill ((pid_t) (*_data2_->hpi).pid, SIGTERM);
	if ((*_data2_->hpi).kill_timer_id == 0) {
		guint _tmp1_;
		_tmp1_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 2000, __lambda4__gsource_func, block2_data_ref (_data2_), block2_data_unref);
		(*_data2_->hpi).kill_timer_id = _tmp1_;
	}
	block2_data_unref (_data2_);
	_data2_ = NULL;
}


static void dock_manager_helper_daemon_kill_all (DockManagerHelperDaemon* self) {
	GList* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_hash_table_get_keys (self->priv->helper_process_info);
	{
		GList* path_collection;
		GList* path_it;
		path_collection = _tmp0_;
		for (path_it = path_collection; path_it != NULL; path_it = path_it->next) {
			const gchar* path;
			path = (const gchar*) path_it->data;
			{
				dock_manager_helper_daemon_kill_helper (self, path);
			}
		}
		_g_list_free0 (path_collection);
	}
}


static void dock_manager_helper_daemon_real_install_helper_data_free (gpointer _data) {
	DockManagerHelperDaemonInstallHelperData* data;
	data = _data;
	_g_free0 (data->filename);
	_g_object_unref0 (data->self);
	g_slice_free (DockManagerHelperDaemonInstallHelperData, data);
}


static void dock_manager_helper_daemon_real_install_helper (DockManagerDaemonInterface* base, const gchar* filename, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DockManagerHelperDaemon * self;
	DockManagerHelperDaemonInstallHelperData* _data_;
	self = (DockManagerHelperDaemon*) base;
	_data_ = g_slice_new0 (DockManagerHelperDaemonInstallHelperData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, dock_manager_helper_daemon_real_install_helper);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, dock_manager_helper_daemon_real_install_helper_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->filename = g_strdup (filename);
	dock_manager_helper_daemon_real_install_helper_co (_data_);
}


static gboolean dock_manager_helper_daemon_real_install_helper_finish (DockManagerDaemonInterface* base, GAsyncResult* _res_, GError** error) {
	gboolean result;
	DockManagerHelperDaemonInstallHelperData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return FALSE;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	return result;
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}


static void block3_data_unref (Block3Data* _data3_) {
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		_g_object_unref0 (_data3_->self);
		g_slice_free (Block3Data, _data3_);
	}
}


static Block4Data* block4_data_ref (Block4Data* _data4_) {
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}


static void block4_data_unref (Block4Data* _data4_) {
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		block3_data_unref (_data4_->_data3_);
		_data4_->_data3_ = NULL;
		_g_regex_unref0 (_data4_->re);
		g_slice_free (Block4Data, _data4_);
	}
}


static gboolean _lambda7_ (GIOChannel* src, GIOCondition cond, Block4Data* _data4_) {
	Block3Data* _data3_;
	DockManagerHelperDaemon * self;
	gboolean result = FALSE;
	GIOStatus io_status;
	GError * _inner_error_ = NULL;
	_data3_ = _data4_->_data3_;
	self = _data3_->self;
	g_return_val_if_fail (src != NULL, FALSE);
	io_status = G_IO_STATUS_NORMAL;
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gchar* line;
		gchar* _tmp1_ = NULL;
		GIOStatus _tmp2_;
		GIOStatus _tmp3_;
		if (io_status == G_IO_STATUS_NORMAL) {
			_tmp0_ = !_data4_->metadata_file_found;
		} else {
			_tmp0_ = FALSE;
		}
		if (!_tmp0_) {
			break;
		}
		line = NULL;
		_tmp2_ = g_io_channel_read_line (src, &_tmp1_, NULL, NULL, &_inner_error_);
		_g_free0 (line);
		line = _tmp1_;
		_tmp3_ = _tmp2_;
		if (_inner_error_ != NULL) {
			_g_free0 (line);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		io_status = _tmp3_;
		if (line != NULL) {
			gboolean _tmp4_;
			_tmp4_ = g_regex_match (_data4_->re, line, 0, NULL);
			_data4_->metadata_file_found = _tmp4_;
		}
		_g_free0 (line);
	}
}


static gboolean __lambda7__gio_func (GIOChannel* source, GIOCondition condition, gpointer self) {
	gboolean result;
	result = _lambda7_ (source, condition, self);
	return result;
}


static void _lambda8_ (GPid p, gint status, Block4Data* _data4_) {
	Block3Data* _data3_;
	DockManagerHelperDaemon * self;
	_data3_ = _data4_->_data3_;
	self = _data3_->self;
	dock_manager_helper_daemon_real_install_helper_co (_data3_->_async_data_);
}


static void __lambda8__gchild_watch_func (GPid pid, gint status, gpointer self) {
	_lambda8_ (pid, status, self);
}


static Block5Data* block5_data_ref (Block5Data* _data5_) {
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}


static void block5_data_unref (Block5Data* _data5_) {
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		block3_data_unref (_data5_->_data3_);
		_data5_->_data3_ = NULL;
		g_slice_free (Block5Data, _data5_);
	}
}


static void _lambda9_ (GPid p, gint status, Block5Data* _data5_) {
	Block3Data* _data3_;
	DockManagerHelperDaemon * self;
	_data3_ = _data5_->_data3_;
	self = _data3_->self;
	_data5_->untar_status = status;
	dock_manager_helper_daemon_real_install_helper_co (_data3_->_async_data_);
}


static void __lambda9__gchild_watch_func (GPid pid, gint status, gpointer self) {
	_lambda9_ (pid, status, self);
}


static gboolean dock_manager_helper_daemon_real_install_helper_co (DockManagerHelperDaemonInstallHelperData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_data3_ = g_slice_new0 (Block3Data);
	data->_data3_->_ref_count_ = 1;
	data->_data3_->self = g_object_ref (data->self);
	data->_data3_->_async_data_ = data;
	g_debug ("dockmanager-daemon.vala:432: Trying to install %s", data->filename);
	data->argv_length1 = 0;
	data->_argv_size_ = 0;
	data->_data4_ = g_slice_new0 (Block4Data);
	data->_data4_->_ref_count_ = 1;
	data->_data4_->_data3_ = block3_data_ref (data->_data3_);
	data->_data4_->metadata_file_found = FALSE;
	data->_tmp0_ = NULL;
	data->_tmp0_ = g_strdup_printf ("tar -t -f \"%s\"", data->filename);
	data->tar_command = data->_tmp0_;
	data->_tmp1_ = NULL;
	g_shell_parse_argv (data->tar_command, &data->_tmp2_, &data->_tmp1_, &data->_inner_error_);
	data->argv = (_vala_array_free (data->argv, data->argv_length1, (GDestroyNotify) g_free), NULL);
	data->argv = data->_tmp1_;
	data->argv_length1 = data->_tmp2_;
	if (data->_inner_error_ != NULL) {
		_g_free0 (data->tar_command);
		block4_data_unref (data->_data4_);
		data->_data4_ = NULL;
		goto __catch8_g_error;
	}
	g_spawn_async_with_pipes (NULL, data->argv, NULL, G_SPAWN_SEARCH_PATH | G_SPAWN_DO_NOT_REAP_CHILD, NULL, NULL, &data->_tmp3_, NULL, &data->_tmp4_, NULL, &data->_inner_error_);
	data->pid = data->_tmp3_;
	data->standard_output = data->_tmp4_;
	if (data->_inner_error_ != NULL) {
		_g_free0 (data->tar_command);
		block4_data_unref (data->_data4_);
		data->_data4_ = NULL;
		goto __catch8_g_error;
	}
	data->_tmp5_ = NULL;
	data->_tmp5_ = g_regex_new ("^metadata/.*info$", G_REGEX_OPTIMIZE, 0, &data->_inner_error_);
	data->_data4_->re = data->_tmp5_;
	if (data->_inner_error_ != NULL) {
		_g_free0 (data->tar_command);
		block4_data_unref (data->_data4_);
		data->_data4_ = NULL;
		goto __catch8_g_error;
	}
	data->_tmp6_ = NULL;
	data->_tmp6_ = g_io_channel_unix_new (data->standard_output);
	data->chan = data->_tmp6_;
	data->_tmp7_ = g_io_add_watch (data->chan, G_IO_IN | G_IO_HUP, __lambda7__gio_func, data->_data4_);
	data->src_id = data->_tmp7_;
	g_child_watch_add_full (G_PRIORITY_DEFAULT_IDLE, data->pid, __lambda8__gchild_watch_func, block4_data_ref (data->_data4_), block4_data_unref);
	data->_state_ = 1;
	return FALSE;
	_state_1:
	;
	g_source_remove (data->src_id);
	if (!data->_data4_->metadata_file_found) {
		g_warning ("dockmanager-daemon.vala:476: Helper installation failed: %s", "No metadata file found!");
		data->result = FALSE;
		_g_io_channel_unref0 (data->chan);
		_g_free0 (data->tar_command);
		block4_data_unref (data->_data4_);
		data->_data4_ = NULL;
		data->argv = (_vala_array_free (data->argv, data->argv_length1, (GDestroyNotify) g_free), NULL);
		block3_data_unref (data->_data3_);
		data->_data3_ = NULL;
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	_g_io_channel_unref0 (data->chan);
	_g_free0 (data->tar_command);
	block4_data_unref (data->_data4_);
	data->_data4_ = NULL;
	goto __finally8;
	__catch8_g_error:
	{
		data->err = data->_inner_error_;
		data->_inner_error_ = NULL;
		g_warning ("dockmanager-daemon.vala:482: Helper installation failed: %s", data->err->message);
		data->result = FALSE;
		_g_error_free0 (data->err);
		data->argv = (_vala_array_free (data->argv, data->argv_length1, (GDestroyNotify) g_free), NULL);
		block3_data_unref (data->_data3_);
		data->_data3_ = NULL;
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	__finally8:
	if (data->_inner_error_ != NULL) {
		if (data->_inner_error_->domain == DBUS_GERROR) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			data->argv = (_vala_array_free (data->argv, data->argv_length1, (GDestroyNotify) g_free), NULL);
			block3_data_unref (data->_data3_);
			data->_data3_ = NULL;
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		} else {
			data->argv = (_vala_array_free (data->argv, data->argv_length1, (GDestroyNotify) g_free), NULL);
			block3_data_unref (data->_data3_);
			data->_data3_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	data->_data5_ = g_slice_new0 (Block5Data);
	data->_data5_->_ref_count_ = 1;
	data->_data5_->_data3_ = block3_data_ref (data->_data3_);
	data->_tmp8_ = NULL;
	data->_tmp8_ = g_get_user_data_dir ();
	data->_tmp9_ = g_strconcat (data->_tmp8_, "/dockmanager", NULL);
	data->_tmp10_ = NULL;
	data->_tmp10_ = g_strdup_printf ("tar -C \"%s\" -x -f \"%s\"", data->_tmp9_, data->filename);
	data->extract_command = (data->_tmp11_ = data->_tmp10_, _g_free0 (data->_tmp9_), data->_tmp11_);
	data->_tmp12_ = NULL;
	g_shell_parse_argv (data->extract_command, &data->_tmp13_, &data->_tmp12_, &data->_inner_error_);
	data->argv = (_vala_array_free (data->argv, data->argv_length1, (GDestroyNotify) g_free), NULL);
	data->argv = data->_tmp12_;
	data->argv_length1 = data->_tmp13_;
	if (data->_inner_error_ != NULL) {
		_g_free0 (data->extract_command);
		block5_data_unref (data->_data5_);
		data->_data5_ = NULL;
		goto __catch9_g_error;
	}
	g_spawn_async (NULL, data->argv, NULL, G_SPAWN_SEARCH_PATH | G_SPAWN_DO_NOT_REAP_CHILD, NULL, NULL, &data->_tmp14_, &data->_inner_error_);
	data->pid = data->_tmp14_;
	if (data->_inner_error_ != NULL) {
		_g_free0 (data->extract_command);
		block5_data_unref (data->_data5_);
		data->_data5_ = NULL;
		goto __catch9_g_error;
	}
	data->_data5_->untar_status = 0;
	g_child_watch_add_full (G_PRIORITY_DEFAULT_IDLE, data->pid, __lambda9__gchild_watch_func, block5_data_ref (data->_data5_), block5_data_unref);
	data->_state_ = 2;
	return FALSE;
	_state_2:
	;
	if (data->_data5_->untar_status == 0) {
		data->result = TRUE;
		_g_free0 (data->extract_command);
		block5_data_unref (data->_data5_);
		data->_data5_ = NULL;
		data->argv = (_vala_array_free (data->argv, data->argv_length1, (GDestroyNotify) g_free), NULL);
		block3_data_unref (data->_data3_);
		data->_data3_ = NULL;
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	} else {
		g_warning ("dockmanager-daemon.vala:516: Helper installation failed: tar returned " \
"errorcode %d!", data->_data5_->untar_status);
	}
	_g_free0 (data->extract_command);
	block5_data_unref (data->_data5_);
	data->_data5_ = NULL;
	goto __finally9;
	__catch9_g_error:
	{
		data->err2 = data->_inner_error_;
		data->_inner_error_ = NULL;
		g_warning ("dockmanager-daemon.vala:521: Helper installation failed: %s", data->err2->message);
		data->result = FALSE;
		_g_error_free0 (data->err2);
		data->argv = (_vala_array_free (data->argv, data->argv_length1, (GDestroyNotify) g_free), NULL);
		block3_data_unref (data->_data3_);
		data->_data3_ = NULL;
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	__finally9:
	if (data->_inner_error_ != NULL) {
		if (data->_inner_error_->domain == DBUS_GERROR) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			data->argv = (_vala_array_free (data->argv, data->argv_length1, (GDestroyNotify) g_free), NULL);
			block3_data_unref (data->_data3_);
			data->_data3_ = NULL;
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		} else {
			data->argv = (_vala_array_free (data->argv, data->argv_length1, (GDestroyNotify) g_free), NULL);
			block3_data_unref (data->_data3_);
			data->_data3_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	data->result = FALSE;
	data->argv = (_vala_array_free (data->argv, data->argv_length1, (GDestroyNotify) g_free), NULL);
	block3_data_unref (data->_data3_);
	data->_data3_ = NULL;
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
	data->argv = (_vala_array_free (data->argv, data->argv_length1, (GDestroyNotify) g_free), NULL);
	block3_data_unref (data->_data3_);
	data->_data3_ = NULL;
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void dock_manager_helper_daemon_real_show_preferences (DockManagerDaemonInterface* base, GError** error) {
	DockManagerHelperDaemon * self;
	GError * _inner_error_ = NULL;
	self = (DockManagerHelperDaemon*) base;
	g_spawn_command_line_async ("dockmanager-settings", &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_SPAWN_ERROR) {
			goto __catch10_g_spawn_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	goto __finally10;
	__catch10_g_spawn_error:
	{
		GError * err;
		GError* _tmp0_ = NULL;
		err = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("dockmanager-daemon.vala:536: %s", err->message);
		_tmp0_ = g_error_new_literal (DBUS_GERROR, DBUS_GERROR_SPAWN_FAILED, err->message);
		_inner_error_ = _tmp0_;
		_g_error_free0 (err);
		goto __finally10;
	}
	__finally10:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DBUS_GERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static void dock_manager_helper_daemon_real_embed_preferences (DockManagerDaemonInterface* base, gint64 xid, GHashTable* hints, GError** error) {
	DockManagerHelperDaemon * self;
	gchar* _tmp0_ = NULL;
	gchar* command;
	const gchar* key = NULL;
	GValue* val = NULL;
	GHashTableIter iter = {0};
	GError * _inner_error_ = NULL;
	self = (DockManagerHelperDaemon*) base;
	g_return_if_fail (hints != NULL);
	_tmp0_ = g_strdup_printf ("dockmanager-settings -x %lld", xid);
	command = _tmp0_;
	g_hash_table_iter_init (&iter, hints);
	while (TRUE) {
		gconstpointer _tmp1_ = NULL;
		gconstpointer _tmp2_ = NULL;
		gboolean _tmp3_;
		_tmp3_ = g_hash_table_iter_next (&iter, &_tmp1_, &_tmp2_);
		key = _tmp1_;
		val = _tmp2_;
		if (!_tmp3_) {
			break;
		}
		if (g_strcmp0 (key, "no-install") == 0) {
			gchar* _tmp4_ = NULL;
			gchar* _tmp5_;
			_tmp4_ = g_strjoin (" ", command, "--no-install", NULL, NULL);
			_tmp5_ = _tmp4_;
			_g_free0 (command);
			command = _tmp5_;
		}
	}
	g_spawn_command_line_async (command, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_SPAWN_ERROR) {
			goto __catch11_g_spawn_error;
		}
		_g_free0 (command);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	goto __finally11;
	__catch11_g_spawn_error:
	{
		GError * err;
		GError* _tmp6_ = NULL;
		err = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("dockmanager-daemon.vala:564: %s", err->message);
		_tmp6_ = g_error_new_literal (DBUS_GERROR, DBUS_GERROR_SPAWN_FAILED, err->message);
		_inner_error_ = _tmp6_;
		_g_error_free0 (err);
		goto __finally11;
	}
	__finally11:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DBUS_GERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (command);
			return;
		} else {
			_g_free0 (command);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_g_free0 (command);
}


static void _vala_DockManagerHelperInfo_array_free (DockManagerHelperInfo* array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			dock_manager_helper_info_destroy (&array[i]);
		}
	}
	g_free (array);
}


static DockManagerHelperInfo* dock_manager_helper_daemon_real_get_all_helpers (DockManagerDaemonInterface* base, int* result_length1, GError** error) {
	DockManagerHelperDaemon * self;
	DockManagerHelperInfo* result = NULL;
	gint i;
	guint _tmp0_;
	DockManagerHelperInfo* _tmp1_ = NULL;
	DockManagerHelperInfo* helpers;
	gint helpers_length1;
	gint _helpers_size_;
	DockManagerHelperInfo* _tmp21_;
	self = (DockManagerHelperDaemon*) base;
	i = 0;
	_tmp0_ = g_list_length (self->priv->all_scripts);
	_tmp1_ = g_new0 (DockManagerHelperInfo, _tmp0_);
	helpers = _tmp1_;
	helpers_length1 = _tmp0_;
	_helpers_size_ = _tmp0_;
	{
		GList* hi_collection;
		GList* hi_it;
		hi_collection = self->priv->all_scripts;
		for (hi_it = hi_collection; hi_it != NULL; hi_it = hi_it->next) {
			DockManagerHelperInfo hi;
			hi = *((DockManagerHelperInfo*) hi_it->data);
			{
				gchar* _tmp2_;
				gchar* _tmp3_;
				const gchar* _tmp4_ = NULL;
				gchar* _tmp5_;
				gchar* _tmp6_;
				const gchar* _tmp7_ = NULL;
				gchar* _tmp8_;
				gchar* _tmp9_;
				const gchar* _tmp10_ = NULL;
				gchar* _tmp11_;
				gchar* _tmp12_;
				const gchar* _tmp13_ = NULL;
				gchar* _tmp14_;
				gchar* _tmp15_;
				gboolean _tmp16_;
				gint _tmp17_;
				const gchar* _tmp18_ = NULL;
				gchar* _tmp19_;
				gchar* _tmp20_;
				_tmp2_ = g_strdup (hi.path);
				_tmp3_ = _tmp2_;
				_g_free0 (helpers[i].path);
				helpers[i].path = _tmp3_;
				if (hi.name != NULL) {
					_tmp4_ = hi.name;
				} else {
					_tmp4_ = "";
				}
				_tmp5_ = g_strdup (_tmp4_);
				_tmp6_ = _tmp5_;
				_g_free0 (helpers[i].name);
				helpers[i].name = _tmp6_;
				if (hi.description != NULL) {
					_tmp7_ = hi.description;
				} else {
					_tmp7_ = "";
				}
				_tmp8_ = g_strdup (_tmp7_);
				_tmp9_ = _tmp8_;
				_g_free0 (helpers[i].description);
				helpers[i].description = _tmp9_;
				if (hi.icon_name != NULL) {
					_tmp10_ = hi.icon_name;
				} else {
					_tmp10_ = "";
				}
				_tmp11_ = g_strdup (_tmp10_);
				_tmp12_ = _tmp11_;
				_g_free0 (helpers[i].icon_name);
				helpers[i].icon_name = _tmp12_;
				if (hi.app_name != NULL) {
					_tmp13_ = hi.app_name;
				} else {
					_tmp13_ = "";
				}
				_tmp14_ = g_strdup (_tmp13_);
				_tmp15_ = _tmp14_;
				_g_free0 (helpers[i].app_name);
				helpers[i].app_name = _tmp15_;
				helpers[i].app_available = hi.app_available;
				_tmp16_ = dock_manager_helper_daemon_is_helper_enabled (self, hi.path);
				helpers[i].enabled = _tmp16_;
				_tmp17_ = dock_manager_helper_daemon_get_helper_pid (self, hi.path);
				helpers[i].running = _tmp17_ != 0;
				if (hi.dbus_name != NULL) {
					_tmp18_ = hi.dbus_name;
				} else {
					_tmp18_ = "";
				}
				_tmp19_ = g_strdup (_tmp18_);
				_tmp20_ = _tmp19_;
				_g_free0 (helpers[i].dbus_name);
				helpers[i].dbus_name = _tmp20_;
				i++;
			}
		}
	}
	_tmp21_ = helpers;
	*result_length1 = helpers_length1;
	result = _tmp21_;
	return result;
}


static void dock_manager_helper_daemon_real_restart_all (DockManagerDaemonInterface* base, GError** error) {
	DockManagerHelperDaemon * self;
	self = (DockManagerHelperDaemon*) base;
}


gint dock_manager_helper_daemon_main (gchar** argv, int argv_length1) {
	gint result = 0;
	DockManagerHelperDaemon* _tmp0_ = NULL;
	DockManagerHelperDaemon* daemon;
	GError * _inner_error_ = NULL;
	desktop_agnostic_vfs_init (&_inner_error_);
	if (_inner_error_ != NULL) {
		goto __catch12_g_error;
	}
	_tmp0_ = dock_manager_helper_daemon_new ();
	daemon = _tmp0_;
	dock_manager_helper_daemon_run (daemon);
	desktop_agnostic_vfs_shutdown (&_inner_error_);
	if (_inner_error_ != NULL) {
		_g_object_unref0 (daemon);
		goto __catch12_g_error;
	}
	_g_object_unref0 (daemon);
	goto __finally12;
	__catch12_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("dockmanager-daemon.vala:610: %s", err->message);
		_g_error_free0 (err);
	}
	__finally12:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	result = 0;
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return dock_manager_helper_daemon_main (argv, argc);
}


GValueArray* dock_manager_helper_daemon_get_helper_list (DockManagerHelperDaemon* self) {
	GValueArray* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_helper_list;
	return result;
}


void dock_manager_helper_daemon_set_helper_list (DockManagerHelperDaemon* self, GValueArray* value) {
	GValueArray* _tmp0_ = NULL;
	GValueArray* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_value_array_copy (value);
	_tmp1_ = _tmp0_;
	_g_value_array_free0 (self->priv->_helper_list);
	self->priv->_helper_list = _tmp1_;
	g_object_notify ((GObject *) self, "helper-list");
}


static void dock_manager_helper_daemon_class_init (DockManagerHelperDaemonClass * klass) {
	dock_manager_helper_daemon_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DockManagerHelperDaemonPrivate));
	G_OBJECT_CLASS (klass)->constructed = dock_manager_helper_daemon_real_constructed;
	G_OBJECT_CLASS (klass)->get_property = _vala_dock_manager_helper_daemon_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_dock_manager_helper_daemon_set_property;
	G_OBJECT_CLASS (klass)->finalize = dock_manager_helper_daemon_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DOCK_MANAGER_HELPER_DAEMON_HELPER_LIST, g_param_spec_boxed ("helper-list", "helper-list", "helper-list", G_TYPE_VALUE_ARRAY, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void dock_manager_helper_daemon_dock_manager_daemon_interface_interface_init (DockManagerDaemonInterfaceIface * iface) {
	dock_manager_helper_daemon_dock_manager_daemon_interface_parent_iface = g_type_interface_peek_parent (iface);
	iface->enable_helper = (void (*)(DockManagerDaemonInterface* ,const gchar* ,GError**)) dock_manager_helper_daemon_real_enable_helper;
	iface->disable_helper = (void (*)(DockManagerDaemonInterface* ,const gchar* ,GError**)) dock_manager_helper_daemon_real_disable_helper;
	iface->install_helper = (gboolean (*)(DockManagerDaemonInterface* ,const gchar* ,GError**)) dock_manager_helper_daemon_real_install_helper;
	iface->install_helper_finish = dock_manager_helper_daemon_real_install_helper_finish;
	iface->show_preferences = (void (*)(DockManagerDaemonInterface* ,GError**)) dock_manager_helper_daemon_real_show_preferences;
	iface->embed_preferences = (void (*)(DockManagerDaemonInterface* ,gint64 ,GHashTable* ,GError**)) dock_manager_helper_daemon_real_embed_preferences;
	iface->get_all_helpers = (DockManagerHelperInfo* (*)(DockManagerDaemonInterface* ,int* ,GError**)) dock_manager_helper_daemon_real_get_all_helpers;
	iface->restart_all = (void (*)(DockManagerDaemonInterface* ,GError**)) dock_manager_helper_daemon_real_restart_all;
}


static void dock_manager_helper_daemon_instance_init (DockManagerHelperDaemon * self) {
	GValueArray* _tmp0_ = NULL;
	self->priv = DOCK_MANAGER_HELPER_DAEMON_GET_PRIVATE (self);
	_tmp0_ = g_value_array_new ((guint) 4);
	self->priv->_helper_list = _tmp0_;
}


static void dock_manager_helper_daemon_finalize (GObject* obj) {
	DockManagerHelperDaemon * self;
	self = DOCK_MANAGER_HELPER_DAEMON (obj);
	_g_main_loop_unref0 (self->priv->main_loop);
	_g_object_unref0 (self->priv->watcher);
	_g_value_array_free0 (self->priv->_helper_list);
	_g_hash_table_unref0 (self->priv->helper_process_info);
	__g_list_free__dock_manager_helper_info_free0_0 (self->priv->all_scripts);
	G_OBJECT_CLASS (dock_manager_helper_daemon_parent_class)->finalize (obj);
}


void _dock_manager_helper_daemon_dbus_unregister (DBusConnection* connection, void* _user_data_) {
}


static DBusHandlerResult _dbus_dock_manager_helper_daemon_introspect (DockManagerHelperDaemon* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter;
	GString* xml_data;
	char** children;
	int i;
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	xml_data = g_string_new ("<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\" \"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">\n");
	g_string_append (xml_data, "<node>\n<interface name=\"org.freedesktop.DBus.Introspectable\">\n  <method name=\"Introspect\">\n    <arg name=\"data\" direction=\"out\" type=\"s\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.DBus.Properties\">\n  <method name=\"Get\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"out\" type=\"v\"/>\n  </method>\n  <method name=\"Set\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"in\" type=\"v\"/>\n  </method>\n  <method name=\"GetAll\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"props\" direction=\"out\" type=\"a{sv}\"/>\n  </method>\n</interface>\n<interface name=\"net.launchpad.DockManager.Daemon\">\n  <method name=\"GetAllHelpers\">\n    <arg name=\"result\" type=\"a(ssssssbbb)\" direction=\"out\"/>\n  </method>\n  <method name=\"EnableHelper\">\n    <arg name=\"path\" type=\"s\" direction=\"in\"/>\n  </method>\n  <method name=\"DisableHelper\">\n    <arg name=\"path\" type=\"s\" direction=\"in\"/>\n  </method>\n  <method name=\"RestartAll\">\n  </method>\n  <method name=\"InstallHelper\">\n    <arg name=\"filename\" type=\"s\" direction=\"in\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <method name=\"ShowPreferences\">\n  </method>\n  <method name=\"EmbedPreferences\">\n    <arg name=\"xid\" type=\"x\" direction=\"in\"/>\n    <arg name=\"hints\" type=\"a{sv}\" direction=\"in\"/>\n  </method>\n  <signal name=\"HelperListChanged\">\n  </signal>\n  <signal name=\"HelperStateChanged\">\n    <arg name=\"path\" type=\"s\"/>\n    <arg name=\"enabled\" type=\"b\"/>\n    <arg name=\"running\" type=\"b\"/>\n  </signal>\n</interface>\n");
	dbus_connection_list_registered (connection, g_object_get_data ((GObject *) self, "dbus_object_path"), &children);
	for (i = 0; children[i]; i++) {
		g_string_append_printf (xml_data, "<node name=\"%s\"/>\n", children[i]);
	}
	dbus_free_string_array (children);
	g_string_append (xml_data, "</node>\n");
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &xml_data->str);
	g_string_free (xml_data, TRUE);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


DBusHandlerResult dock_manager_helper_daemon_dbus_message (DBusConnection* connection, DBusMessage* message, void* object) {
	DBusHandlerResult result;
	result = DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Introspectable", "Introspect")) {
		result = _dbus_dock_manager_helper_daemon_introspect (object, connection, message);
	}
	if (result == DBUS_HANDLER_RESULT_HANDLED) {
		return result;
	} else if (dock_manager_daemon_interface_dbus_message (connection, message, object) == DBUS_HANDLER_RESULT_HANDLED) {
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


void dock_manager_helper_daemon_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	if (!g_object_get_data (object, "dbus_object_path")) {
		g_object_set_data (object, "dbus_object_path", g_strdup (path));
		dbus_connection_register_object_path (connection, path, &_dock_manager_helper_daemon_dbus_path_vtable, object);
		g_object_weak_ref (object, _vala_dbus_unregister_object, connection);
	}
	dock_manager_daemon_interface_dbus_register_object (connection, path, object);
}


GType dock_manager_helper_daemon_get_type (void) {
	static volatile gsize dock_manager_helper_daemon_type_id__volatile = 0;
	if (g_once_init_enter (&dock_manager_helper_daemon_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DockManagerHelperDaemonClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dock_manager_helper_daemon_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DockManagerHelperDaemon), 0, (GInstanceInitFunc) dock_manager_helper_daemon_instance_init, NULL };
		static const GInterfaceInfo dock_manager_daemon_interface_info = { (GInterfaceInitFunc) dock_manager_helper_daemon_dock_manager_daemon_interface_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType dock_manager_helper_daemon_type_id;
		dock_manager_helper_daemon_type_id = g_type_register_static (G_TYPE_OBJECT, "DockManagerHelperDaemon", &g_define_type_info, 0);
		g_type_add_interface_static (dock_manager_helper_daemon_type_id, DOCK_MANAGER_TYPE_DAEMON_INTERFACE, &dock_manager_daemon_interface_info);
		g_type_set_qdata (dock_manager_helper_daemon_type_id, g_quark_from_static_string ("DBusObjectVTable"), (void*) (&_dock_manager_helper_daemon_dbus_vtable));
		g_once_init_leave (&dock_manager_helper_daemon_type_id__volatile, dock_manager_helper_daemon_type_id);
	}
	return dock_manager_helper_daemon_type_id__volatile;
}


static void _vala_dock_manager_helper_daemon_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DockManagerHelperDaemon * self;
	self = DOCK_MANAGER_HELPER_DAEMON (object);
	switch (property_id) {
		case DOCK_MANAGER_HELPER_DAEMON_HELPER_LIST:
		g_value_set_boxed (value, dock_manager_helper_daemon_get_helper_list (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_dock_manager_helper_daemon_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DockManagerHelperDaemon * self;
	self = DOCK_MANAGER_HELPER_DAEMON (object);
	switch (property_id) {
		case DOCK_MANAGER_HELPER_DAEMON_HELPER_LIST:
		dock_manager_helper_daemon_set_helper_list (self, g_value_get_boxed (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



