describe :file_writable_real, :shared => true do
  before :each do
    @file = tmp('i_exist')
  end

  after :each do
    File.delete(@file) if File.exist?(@file)
  end

  it "returns true if named file is writable by the real user id of the process, otherwise false" do
    File.open(@file,'w') { @object.send(@method, @file).should == true }
  end

  it "raises an ArgumentError if not passed one argument" do
    lambda { File.writable_real?        }.should raise_error(ArgumentError)
  end

  it "raises a TypeError if not passed a String type" do
    lambda { @object.send(@method, 1)     }.should raise_error(TypeError)
    lambda { @object.send(@method, nil)   }.should raise_error(TypeError)
    lambda { @object.send(@method, false) }.should raise_error(TypeError)
  end
end

describe :file_writable_real_missing, :shared => true do
  it "returns false if the file does not exist" do
    @object.send(@method, 'fake_file').should == false
  end
end
