require File.dirname(__FILE__) + '/../../spec_helper'

describe "ENV.delete_if" do

  it "deletes pairs if the block returns true" do
    ENV["foo"] = "bar"
    ENV.delete_if { |k, v| k == "foo" }
    ENV["foo"].should == nil
  end

  it "returns ENV even if nothing deleted" do
    ENV.delete_if { false }.should_not == nil
  end

  it "returns the value of break" do
    ENV.delete_if { break 1}.should == 1
  end

  ruby_version_is "" ... "1.8.7" do
    it "raises LocalJumpError if no block given" do
      lambda { ENV.delete_if }.should raise_error(LocalJumpError)
    end
  end

  ruby_version_is "1.8.7" do
    it "returns an Enumerator if no block given" do
      ENV.delete_if.should be_kind_of(Enumerable::Enumerator)
    end
  end

end
