#include "mixeffect.h"
#include "jacklow.h"

MixEffectChannel::MixEffectChannel(MixEffect *e, unsigned long in_port, unsigned long out_port) : EffectChannel((Effect *)e, in_port, out_port)
{
	e_port=0;
	e_gain[0]=e_gain[1]=e_gain[2]=e_gain[3]=1.0;
}

MixEffectChannel::~MixEffectChannel()
{
}

void MixEffectChannel::setControl(unsigned long port, float data)
{
	e_gain[port]=data;
}

float MixEffectChannel::control(unsigned long port)
{
	return e_gain[port];
}

void MixEffectChannel::setPort(Port *p)
{
	e_port=p;
}

Port *MixEffectChannel::port()
{
	return e_port;
}

void MixEffectChannel::process(unsigned long nsamples)
{
	float *out;

	unsigned long i;

	if(!e_port)
	{
		for(i=0;i<nsamples;++i)
			e_buffer[i]*=e_gain[0]*e_gain[1]*e_gain[2]*e_gain[3];
	}
	else
	{
		out=(float *)e_port->buffer(nsamples);
		for(i=0;i<nsamples;++i)
			out[i]+=e_buffer[i]*e_gain[0]*e_gain[1]*e_gain[2]*e_gain[3];
	}
}

void MixEffectChannel::setBuffer(float *buffer)
{
	e_buffer=buffer;
}

MixEffect::MixEffect()
{
	e_left=(EffectChannel *)new MixEffectChannel(this, 0, 0);
	e_right=(EffectChannel *)new MixEffectChannel(this, 0, 0);
}

MixEffect::~MixEffect()
{
}

void MixEffect::setControl(unsigned long port, float data)
{
	left()->setControl(port, data);
	right()->setControl(port, data);
}

float MixEffect::control(unsigned long port)
{
	return left()->control(port);
}

MixEffectChannel *MixEffect::left()
{
	return (MixEffectChannel *)e_left;
}

MixEffectChannel *MixEffect::right()
{
	return (MixEffectChannel *)e_right;
}

unsigned long MixEffect::ports()
{
	return 4;
}
