"""Platform specific code."""
# pylint: disable=W0611

import sys

if sys.platform == "win32":
    from desktopcouch.application.platform.windows.keyring import (
        Keyring, TestKeyring)
    from desktopcouch.application.platform.windows.base_dirs import (
        CACHE_HOME, CONFIG_HOME, save_config_path, save_data_path,
        load_config_paths)
else:
    # install the correct reactor for linux
    from desktopcouch.application.platform.linux import (
        process_is_couchdb, platform_read_pidfile,
        platform_find_pid, platform_find_port,
        set_application_name, init_mainloop,
        direct_access_find_port)
    from desktopcouch.application.platform.linux.ipc import PortAdvertiser
    from desktopcouch.application.platform.linux.keyring import (
        Keyring, TestKeyring)
    from desktopcouch.application.platform.linux.base_dirs import (
        CACHE_HOME, CONFIG_HOME, save_config_path, save_data_path,
        load_config_paths)


def read_pidfile(ctx=None):
    """Read the pid file of couchdb in the executing ctx."""
    if ctx is None:
        from desktopcouch.application.local_files import DEFAULT_CONTEXT
        ctx = DEFAULT_CONTEXT
    return platform_read_pidfile(ctx)


def find_pid(start_if_not_running=True, ctx=None):
    """Find the process id of the currently executing couchdb."""
    if ctx is None:
        from desktopcouch.application.local_files import DEFAULT_CONTEXT
        ctx = DEFAULT_CONTEXT
    return platform_find_pid(start_if_not_running, ctx)


def find_port(pid=None, ctx=None):
    """Find the port where couchdb is listening for the current ctx."""
    if ctx is None:
        from desktopcouch.application.local_files import DEFAULT_CONTEXT
        ctx = DEFAULT_CONTEXT
    return platform_find_port(pid, ctx)
