/*!

\if MANPAGES
\page dcmqrscp DICOM image archive (central test node)
\else
\page dcmqrscp dcmqrscp: DICOM image archive (central test node)
\endif

\section synopsis SYNOPSIS

\verbatim
dcmqrscp [options] [port]
\endverbatim

\section description DESCRIPTION

The Image Central Test Node (\b dcmqrscp) Application implements a simple image
archive.  It manages a number of storage areas and allows images to be stored
in these storage areas using the DICOM Storage Service Class.  It also allows
image attributes to be queried and images to be retrieved using the DICOM
Query/Retrieve Service Class.  The \b dcmqrscp application also implements
access restriction rules to limit operations to specific peer application
entities.

The \b dcmqrscp application is intended to be used in DICOM demonstrations and
as a compatibilitiy test tool.  In particular, \b dcmqrscp will delete images
if its quota restrictions have been exceeded.

\section parameters PARAMETERS

\verbatim
port  tcp/ip port number to listen on (default: in config file)
\endverbatim

\section options OPTIONS

\subsection general_options general options
\verbatim
  -h    --help
          print this help text and exit

        --version
          print version information and exit

  -v    --verbose
          verbose mode, print processing details

  -vv   --very-verbose
          print more processing details

  -d    --debug
          debug mode, print debug information

  -c    --config  [f]ilename: string (default: dcmqrscp.cfg)
          use specific configuration file

  # This option allows a specific configuration file to be
  # specified.  By default, the configuration file in the current
  # working directory with the name "dcmqrscp.cfg" will be used
  # (i.e. the file ./dcmqrscp.cfg).  It is an error if a valid
  # configuration file is not available.  See the documentation
  # on configuration for more information (ctnconf.txt and the
  # example configuration file dcmqrscp.cfg).

  -s    --single-process
          single process mode

  # This option instructs dcmqrscp to run in single process mode.
  # Normally, dcmqrscp will spawn a new copy of itself to handle
  # each association.  This option will prevent such copies being
  # spawned and is particularly useful when running within a
  # debugger.
\endverbatim

\subsection database_options database options
\verbatim
association negotiation:

        --require-find
          reject all MOVE/GET presentation contexts for
          which no corresponding FIND context is proposed

  # This option causes dcmqrscp to enforce a restriction about
  # FIND and MOVE presentation contexts.  The RSNA'93 demonstration
  # required that a CTN refuse to accept a presentation context for
  # a MOVE if a FIND presentation context is not also requested.
  # This option enforces this restriction.

        --no-parallel-store
          reject multiple simultaneous STORE presentation
          contexts for one application entity title

  # This option causes dcmqrscp to refuse storage presentations
  # contexts for AE Titles if another association has already
  # sucessfully negotiated storage presentation contexts for the
  # AE Title.  This option should only be needed for debugging
  # since the dcmqrscp database back-end sequentialises access via
  # file-locking.

        --disable-get
          disable C-GET support

        --allow-shutdown
          allow external shutdown via a private SOP class

checking identifier validity:

  -XF   --check-find
          check C-FIND identifier validity

  # This option causes dcmqrscp database back-end to perform checks
  # on the Query Identifiers for a C-FIND command.  With this option,
  # dcmqrscp will reject any queries which do not conform to the very
  # strict DICOM rules for Query Identifiers.

        --no-check-find
          do not check C-FIND identif. validity (default)

  -XM   --check-move
          check C-MOVE identifier validity


  # This option causes dcmqrscp database back-end to perform checks
  # on the Query Identifiers for a C-MOVE command.  With this option,
  # dcmqrscp will reject any queries which do not conform to the very
  # strict DICOM rules for Query Identifiers.

        --no-check-move
          do not check C-MOVE identif. validity (default)

restriction of move targets:

        --move-unrestricted
          do not restrict move destination (default)

  -ZA   --move-aetitle
          restrict move dest. to requesting AE title

  -ZH   --move-host
          restrict move destination to requesting host

  -ZV   --move-vendor
          restrict move destination to requesting vendor

restriction of query/retrieve models:

  -QP   --no-patient-root
          do not support Patient Root Q/R models

  -QS   --no-study-root
          do not support Study Root Q/R models

  -QO   --no-patient-study
          do not support Patient/Study Only Q/R models
\endverbatim

\subsection network_options network options
\verbatim
preferred network transfer syntaxes (incoming associations):

  +x=   --prefer-uncompr       
          prefer explicit VR local byte order (default)

  +xe   --prefer-little        
          prefer explicit VR little endian TS

  +xb   --prefer-big           
          prefer explicit VR big endian TS

  +xs   --prefer-lossless      
          prefer default JPEG lossless TS

  +xy   --prefer-jpeg8         
          prefer default JPEG lossy TS for 8 bit data

  +xx   --prefer-jpeg12        
          prefer default JPEG lossy TS for 12 bit data

  +xr   --prefer-rle           
          prefer RLE lossless TS

  +xv   --prefer-j2k-lossless  
          prefer JPEG 2000 lossless TS

  +xw   --prefer-j2k-lossy     
          prefer JPEG 2000 lossy TS

  +xd   --prefer-deflated      
          prefer deflated expl. VR little endian TS

  +xi   --implicit             
          accept implicit VR little endian TS only

proposed transmission transfer syntaxes (outgoing associations):

  -x=   --propose-uncompr       
          propose all uncompressed TS, explicit VR
          with local byte ordering first (default)

  -xe   --propose-little        
          propose all uncompressed TS, explicit VR
          little endian first

  -xb   --propose-big           
          propose all uncompressed TS, explicit VR
          big endian first

  -xs   --propose-lossless      
          propose default JPEG lossless TS

  -xy   --propose-jpeg8         
          propose default JPEG lossy TS for 8 bit data

  -xx   --propose-jpeg12        
          propose default JPEG lossy TS for 12 bit data

  -xv   --propose-j2k-lossless  
          propose default JPEG 2000 lossless TS

  -xw   --propose-j2k-lossy     
          propose default JPEG 2000 lossy TS

  -xr   --propose-rle           
          propose RLE lossless TS

  -xd   --propose-deflated      
          propose deflated expl. VR little endian TS

  -xi   --propose-implicit      
          propose implicit VR little endian TS only

network host access control (tcp wrapper) options:

  -ac   --access-full
          accept connections from any host (default)

  +ac   --access-control
          enforce host access control rules

other network options:

  -to   --timeout  [s]econds: integer (default: unlimited)
          timeout for connection requests

  -ta   --acse-timeout  [s]econds: integer (default: 30)
          timeout for ACSE messages

  -td   --dimse-timeout  [s]econds: integer (default: unlimited)
          timeout for DIMSE messages

  -pdu  --max-pdu  [n]umber of bytes: integer [4096..131072]
          set max receive pdu to n bytes (default: 16384)

  -dhl  --disable-host-lookup
          disable hostname lookup

        --refuse
          refuse association

        --reject
          reject association if no implement. class UID

        --ignore
          ignore store data, receive but do not store

  # This option causes dcmqrscp database back-end to ignore
  # all images received by the Storage Service Class.  All images
  # will be received from the network but not stored to disk nor
  # recorded in database.

  -up   --uid-padding
          silently correct space-padded UIDs
\endverbatim

\subsection encoding_options encoding options
\verbatim
post-1993 value representations:

  +u    --enable-new-vr
          enable support for new VRs (UN/UT) (default)

  -u    --disable-new-vr
          disable support for new VRs, convert to OB

  # This option disables generation of new VRs (UN/UT) when writing
  # DICOM encoded data to a file to the network.  This option can be
  # used to force compatibility with applications which do not support
  # these value representations.
\endverbatim

\subsection output_options output options
\verbatim
bit preserving mode:

  -B    --normal
          allow implicit format conversions (default)

  +B    --bit-preserving
          write data exactly as read

output file format:

  +F    --write-file
          write file format (default)

  -F    --write-dataset
          write data set without file meta information

output transfer syntax:
(not with --bit-preserving or compressed transmission)

  +t=   --write-xfer-same
          write with same TS as input (default)

  +te   --write-xfer-little
          write with explicit VR little endian TS

  +tb   --write-xfer-big
          write with explicit VR big endian TS

  +ti   --write-xfer-implicit
          write with implicit VR little endian TS

group length encoding (not with --bit-preserving):

  +g=   --group-length-recalc
          recalculate group lengths if present (default)

  +g    --group-length-create
          always write with group length elements

  -g    --group-length-remove
          always write without group length elements

length encoding in sequences and items (not with --bit-preserving):

  +e    --length-explicit
          write with explicit lengths (default)

  -e    --length-undefined
          write with undefined lengths

data set trailing padding (not with --write-dataset or --bit-preserving):

  -p    --padding-off
          no padding (default)

  +p    --padding-create  [f]ile-pad [i]tem-pad: integer
          align file on multiple of f bytes
          and items on multiple of i bytes
\endverbatim

\section notes NOTES

\subsection operation Operation

\b dcmqrscp waits for another application to connect at the presentation
address (port number) specified in its configuration file (or overridden by a
command line option).  When another application connects, \b dcmqrscp expects
it to be a DICOM application and to use calling and called AE Titles specified
in <b>dcmqrscp's</b> configuration file.  \b dcmqrscp will accept associations
with Presentation Contexts for SOP Classes of the Verification Service Class,
Storage Service Class and Query/Retreive Service Class.  Associations will be
rejected or Presentation Contexts will be refused if the peer application does
not have appropriate access rights as specified by \b dcmqrscp configuration
file.

\b dcmqrscp will receive images on Presentation Contexts of the Storage Service
Class, write them to a configurable storage area associated with the class AE
title, extract attributes from these images and store them in a database.
\b dcmqrscp will receive query requests and generate query responses on
Presentation Contexts of the Query/Retrieve Service class.  \b dcmqrscp will
receive retrieve requests and generate retrieve responses on Presentation
Contexts of the Query/Retrieve Service class.  \b dcmqrscp will also process
C-CANCEL messages to interrupt query/retrieve operations.

Under normal operations \b dcmqrscp will never exit, it keeps on waiting for
new associations until killed.

\subsection dicom_conformance DICOM Conformance

\subsubsection scu_conformance SCU Conformance

The \b dcmqrscp application supports the following SOP Classes as an SCU:

\verbatim
VerificationSOPClass                                 1.2.840.10008.1.1

StoredPrintStorage                                   1.2.840.10008.5.1.1.27
HardcopyGrayscaleImageStorage                        1.2.840.10008.5.1.1.29
HardcopyColorImageStorage                            1.2.840.10008.5.1.1.30
ComputedRadiographyImageStorage                      1.2.840.10008.5.1.4.1.1.1
DigitalXRayImageStorageForPresentation               1.2.840.10008.5.1.4.1.1.1.1
DigitalXRayImageStorageForProcessing                 1.2.840.10008.5.1.4.1.1.1.1.1
DigitalMammographyXRayImageStorageForPresentation    1.2.840.10008.5.1.4.1.1.1.2
DigitalMammographyXRayImageStorageForProcessing      1.2.840.10008.5.1.4.1.1.1.2.1
DigitalIntraOralXRayImageStorageForPresentation      1.2.840.10008.5.1.4.1.1.1.3
DigitalIntraOralXRayImageStorageForProcessing        1.2.840.10008.5.1.4.1.1.1.3.1
StandaloneModalityLUTStorage                         1.2.840.10008.5.1.4.1.1.10
EncapsulatedPDFStorage                               1.2.840.10008.5.1.4.1.1.104.1
StandaloneVOILUTStorage                              1.2.840.10008.5.1.4.1.1.11
GrayscaleSoftcopyPresentationStateStorage            1.2.840.10008.5.1.4.1.1.11.1
ColorSoftcopyPresentationStateStorage                1.2.840.10008.5.1.4.1.1.11.2
PseudoColorSoftcopyPresentationStateStorage          1.2.840.10008.5.1.4.1.1.11.3
BlendingSoftcopyPresentationStateStorage             1.2.840.10008.5.1.4.1.1.11.4
XRayAngiographicImageStorage                         1.2.840.10008.5.1.4.1.1.12.1
EnhancedXAImageStorage                               1.2.840.10008.5.1.4.1.1.12.1.1
XRayFluoroscopyImageStorage                          1.2.840.10008.5.1.4.1.1.12.2
EnhancedXRFImageStorage                              1.2.840.10008.5.1.4.1.1.12.2.1
RETIRED_XRayAngiographicBiPlaneImageStorage          1.2.840.10008.5.1.4.1.1.12.3
PETImageStorage                                      1.2.840.10008.5.1.4.1.1.128
PETCurveStorage                                      1.2.840.10008.5.1.4.1.1.129
CTImageStorage                                       1.2.840.10008.5.1.4.1.1.2
EnhancedCTImageStorage                               1.2.840.10008.5.1.4.1.1.2.1
NuclearMedicineImageStorage                          1.2.840.10008.5.1.4.1.1.20
RETIRED_UltrasoundMultiframeImageStorage             1.2.840.10008.5.1.4.1.1.3
UltrasoundMultiframeImageStorage                     1.2.840.10008.5.1.4.1.1.3.1
MRImageStorage                                       1.2.840.10008.5.1.4.1.1.4
EnhancedMRImageStorage                               1.2.840.10008.5.1.4.1.1.4.1
MRSpectroscopyStorage                                1.2.840.10008.5.1.4.1.1.4.2
RTImageStorage                                       1.2.840.10008.5.1.4.1.1.481.1
RTDoseStorage                                        1.2.840.10008.5.1.4.1.1.481.2
RTStructureSetStorage                                1.2.840.10008.5.1.4.1.1.481.3
RTBeamsTreatmentRecordStorage                        1.2.840.10008.5.1.4.1.1.481.4
RTPlanStorage                                        1.2.840.10008.5.1.4.1.1.481.5
RTBrachyTreatmentRecordStorage                       1.2.840.10008.5.1.4.1.1.481.6
RTTreatmentSummaryRecordStorage                      1.2.840.10008.5.1.4.1.1.481.7
RETIRED_NuclearMedicineImageStorage                  1.2.840.10008.5.1.4.1.1.5
RETIRED_UltrasoundImageStorage                       1.2.840.10008.5.1.4.1.1.6
UltrasoundImageStorage                               1.2.840.10008.5.1.4.1.1.6.1
RawDataStorage                                       1.2.840.10008.5.1.4.1.1.66
SpatialRegistrationStorage                           1.2.840.10008.5.1.4.1.1.66.1
SpatialFiducialsStorage                              1.2.840.10008.5.1.4.1.1.66.2
RealWorldValueMappingStorage                         1.2.840.10008.5.1.4.1.1.67
SecondaryCaptureImageStorage                         1.2.840.10008.5.1.4.1.1.7
MultiframeSingleBitSecondaryCaptureImageStorage      1.2.840.10008.5.1.4.1.1.7.1
MultiframeGrayscaleByteSecondaryCaptureImageStorage  1.2.840.10008.5.1.4.1.1.7.2
MultiframeGrayscaleWordSecondaryCaptureImageStorage  1.2.840.10008.5.1.4.1.1.7.3
MultiframeTrueColorSecondaryCaptureImageStorage      1.2.840.10008.5.1.4.1.1.7.4
RETIRED_VLImageStorage                               1.2.840.10008.5.1.4.1.1.77.1
VLEndoscopicImageStorage                             1.2.840.10008.5.1.4.1.1.77.1.1
VideoEndoscopicImageStorage                          1.2.840.10008.5.1.4.1.1.77.1.1.1
VLMicroscopicImageStorage                            1.2.840.10008.5.1.4.1.1.77.1.2
VideoMicroscopicImageStorage                         1.2.840.10008.5.1.4.1.1.77.1.2.1
VLSlideCoordinatesMicroscopicImageStorage            1.2.840.10008.5.1.4.1.1.77.1.3
VLPhotographicImageStorage                           1.2.840.10008.5.1.4.1.1.77.1.4
VideoPhotographicImageStorage                        1.2.840.10008.5.1.4.1.1.77.1.4.1
OphthalmicPhotography8BitImageStorage                1.2.840.10008.5.1.4.1.1.77.1.5.1
OphthalmicPhotography16BitImageStorage               1.2.840.10008.5.1.4.1.1.77.1.5.2
StereometricRelationshipStorage                      1.2.840.10008.5.1.4.1.1.77.1.5.3
RETIRED_VLMultiFrameImageStorage                     1.2.840.10008.5.1.4.1.1.77.2
StandaloneOverlayStorage                             1.2.840.10008.5.1.4.1.1.8
DRAFT_SRTextStorage                                  1.2.840.10008.5.1.4.1.1.88.1
DRAFT_SRAudioStorage                                 1.2.840.10008.5.1.4.1.1.88.2
DRAFT_SRDetailStorage                                1.2.840.10008.5.1.4.1.1.88.3
DRAFT_SRComprehensiveStorage                         1.2.840.10008.5.1.4.1.1.88.4
BasicTextSR                                          1.2.840.10008.5.1.4.1.1.88.11
EnhancedSR                                           1.2.840.10008.5.1.4.1.1.88.22
ComprehensiveSR                                      1.2.840.10008.5.1.4.1.1.88.33
ProcedureLogStorage                                  1.2.840.10008.5.1.4.1.1.88.40
MammographyCADSR                                     1.2.840.10008.5.1.4.1.1.88.50
KeyObjectSelectionDocument                           1.2.840.10008.5.1.4.1.1.88.59
ChestCADSR                                           1.2.840.10008.5.1.4.1.1.88.65
XRayRadiationDoseSR                                  1.2.840.10008.5.1.4.1.1.88.67
StandaloneCurveStorage                               1.2.840.10008.5.1.4.1.1.9
DRAFT_WaveformStorage                                1.2.840.10008.5.1.4.1.1.9.1
TwelveLeadECGWaveformStorage                         1.2.840.10008.5.1.4.1.1.9.1.1
GeneralECGWaveformStorage                            1.2.840.10008.5.1.4.1.1.9.1.2
AmbulatoryECGWaveformStorage                         1.2.840.10008.5.1.4.1.1.9.1.3
HemodynamicWaveformStorage                           1.2.840.10008.5.1.4.1.1.9.2.1
CardiacElectrophysiologyWaveformStorage              1.2.840.10008.5.1.4.1.1.9.3.1
BasicVoiceAudioWaveformStorage                       1.2.840.10008.5.1.4.1.1.9.4.1
\endverbatim

The \b dcmqrscp application will propose presentation contexts for all of the
abovementioned supported SOP Classes using the transfer syntaxes:

\verbatim
LittleEndianImplicitTransferSyntax                   1.2.840.10008.1.2
LittleEndianExplicitTransferSyntax                   1.2.840.10008.1.2.1
BigEndianExplicitTransferSyntax                      1.2.840.10008.1.2.2
\endverbatim

The \b dcmqrscp application does not support extended negotiation.

\subsubsection scp_conformance SCP Conformance

The \b dcmqrscp application supports the following SOP Classes as an SCP:

\verbatim
VerificationSOPClass                                 1.2.840.10008.1.1

FINDPatientRootQueryRetrieveInformationModel         1.2.840.10008.5.1.4.1.2.1.1
FINDPatientStudyOnlyQueryRetrieveInformationModel    1.2.840.10008.5.1.4.1.2.3.1
FINDStudyRootQueryRetrieveInformationModel           1.2.840.10008.5.1.4.1.2.2.1
GETPatientRootQueryRetrieveInformationModel          1.2.840.10008.5.1.4.1.2.1.3
GETPatientStudyOnlyQueryRetrieveInformationModel     1.2.840.10008.5.1.4.1.2.3.3
GETStudyRootQueryRetrieveInformationModel            1.2.840.10008.5.1.4.1.2.2.3
MOVEPatientRootQueryRetrieveInformationModel         1.2.840.10008.5.1.4.1.2.1.2
MOVEPatientStudyOnlyQueryRetrieveInformationModel    1.2.840.10008.5.1.4.1.2.3.2
MOVEStudyRootQueryRetrieveInformationModel           1.2.840.10008.5.1.4.1.2.2.2

StoredPrintStorage                                   1.2.840.10008.5.1.1.27
HardcopyGrayscaleImageStorage                        1.2.840.10008.5.1.1.29
HardcopyColorImageStorage                            1.2.840.10008.5.1.1.30
ComputedRadiographyImageStorage                      1.2.840.10008.5.1.4.1.1.1
DigitalXRayImageStorageForPresentation               1.2.840.10008.5.1.4.1.1.1.1
DigitalXRayImageStorageForProcessing                 1.2.840.10008.5.1.4.1.1.1.1.1
DigitalMammographyXRayImageStorageForPresentation    1.2.840.10008.5.1.4.1.1.1.2
DigitalMammographyXRayImageStorageForProcessing      1.2.840.10008.5.1.4.1.1.1.2.1
DigitalIntraOralXRayImageStorageForPresentation      1.2.840.10008.5.1.4.1.1.1.3
DigitalIntraOralXRayImageStorageForProcessing        1.2.840.10008.5.1.4.1.1.1.3.1
GrayscaleSoftcopyPresentationStateStorage            1.2.840.10008.5.1.4.1.1.11.1
XRayAngiographicImageStorage                         1.2.840.10008.5.1.4.1.1.12.1
XRayFluoroscopyImageStorage                          1.2.840.10008.5.1.4.1.1.12.2
PETImageStorage                                      1.2.840.10008.5.1.4.1.1.128
PETCurveStorage                                      1.2.840.10008.5.1.4.1.1.129
CTImageStorage                                       1.2.840.10008.5.1.4.1.1.2
EnhancedCTImageStorage                               1.2.840.10008.5.1.4.1.1.2.1
NuclearMedicineImageStorage                          1.2.840.10008.5.1.4.1.1.20
RETIRED_UltrasoundMultiframeImageStorage             1.2.840.10008.5.1.4.1.1.3
UltrasoundMultiframeImageStorage                     1.2.840.10008.5.1.4.1.1.3.1
MRImageStorage                                       1.2.840.10008.5.1.4.1.1.4
EnhancedMRImageStorage                               1.2.840.10008.5.1.4.1.1.4.1
MRSpectroscopyStorage                                1.2.840.10008.5.1.4.1.1.4.2
RTImageStorage                                       1.2.840.10008.5.1.4.1.1.481.1
RTDoseStorage                                        1.2.840.10008.5.1.4.1.1.481.2
RTStructureSetStorage                                1.2.840.10008.5.1.4.1.1.481.3
RTBeamsTreatmentRecordStorage                        1.2.840.10008.5.1.4.1.1.481.4
RTPlanStorage                                        1.2.840.10008.5.1.4.1.1.481.5
RTBrachyTreatmentRecordStorage                       1.2.840.10008.5.1.4.1.1.481.6
RTTreatmentSummaryRecordStorage                      1.2.840.10008.5.1.4.1.1.481.7
RETIRED_UltrasoundImageStorage                       1.2.840.10008.5.1.4.1.1.6
UltrasoundImageStorage                               1.2.840.10008.5.1.4.1.1.6.1
RawDataStorage                                       1.2.840.10008.5.1.4.1.1.66
SpatialRegistrationStorage                           1.2.840.10008.5.1.4.1.1.66.1
SpatialFiducialsStorage                              1.2.840.10008.5.1.4.1.1.66.2
SecondaryCaptureImageStorage                         1.2.840.10008.5.1.4.1.1.7
MultiframeSingleBitSecondaryCaptureImageStorage      1.2.840.10008.5.1.4.1.1.7.1
MultiframeGrayscaleByteSecondaryCaptureImageStorage  1.2.840.10008.5.1.4.1.1.7.2
MultiframeGrayscaleWordSecondaryCaptureImageStorage  1.2.840.10008.5.1.4.1.1.7.3
MultiframeTrueColorSecondaryCaptureImageStorage      1.2.840.10008.5.1.4.1.1.7.4
VLEndoscopicImageStorage                             1.2.840.10008.5.1.4.1.1.77.1.1
VideoEndoscopicImageStorage                          1.2.840.10008.5.1.4.1.1.77.1.1.1
VLMicroscopicImageStorage                            1.2.840.10008.5.1.4.1.1.77.1.2
VideoMicroscopicImageStorage                         1.2.840.10008.5.1.4.1.1.77.1.2.1
VLSlideCoordinatesMicroscopicImageStorage            1.2.840.10008.5.1.4.1.1.77.1.3
VLPhotographicImageStorage                           1.2.840.10008.5.1.4.1.1.77.1.4
VideoPhotographicImageStorage                        1.2.840.10008.5.1.4.1.1.77.1.4.1
Ophthalmic8BitPhotographyImageStorage                1.2.840.10008.5.1.4.1.1.77.1.5.1
Ophthalmic16BitPhotographyImageStorage               1.2.840.10008.5.1.4.1.1.77.1.5.2
StereometricRelationshipStorage                      1.2.840.10008.5.1.4.1.1.77.1.5.3
BasicTextSR                                          1.2.840.10008.5.1.4.1.1.88.11
EnhancedSR                                           1.2.840.10008.5.1.4.1.1.88.22
ComprehensiveSR                                      1.2.840.10008.5.1.4.1.1.88.33
ProcedureLogStorage                                  1.2.840.10008.5.1.4.1.1.88.40
MammographyCADSR                                     1.2.840.10008.5.1.4.1.1.88.50
KeyObjectSelectionDocument                           1.2.840.10008.5.1.4.1.1.88.59
ChestCADSR                                           1.2.840.10008.5.1.4.1.1.88.65
TwelveLeadECGWaveformStorage                         1.2.840.10008.5.1.4.1.1.9.1.1
GeneralECGWaveformStorage                            1.2.840.10008.5.1.4.1.1.9.1.2
AmbulatoryECGWaveformStorage                         1.2.840.10008.5.1.4.1.1.9.1.3
HemodynamicWaveformStorage                           1.2.840.10008.5.1.4.1.1.9.2.1
CardiacElectrophysiologyWaveformStorage              1.2.840.10008.5.1.4.1.1.9.3.1
BasicVoiceAudioWaveformStorage                       1.2.840.10008.5.1.4.1.1.9.4.1

PrivateShutdownSOPClass                              1.2.276.0.7230010.3.4.1915765545.18030.917282194.0
\endverbatim

The \b dcmqrscp application will accept presentation contexts for all of the
above mentioned supported SOP Classes using any of the transfer syntaxes:

\verbatim
LittleEndianImplicitTransferSyntax                   1.2.840.10008.1.2
LittleEndianExplicitTransferSyntax                   1.2.840.10008.1.2.1
BigEndianExplicitTransferSyntax                      1.2.840.10008.1.2.2
\endverbatim

The \b dcmqrscp application will prefer transfer syntaxes having an explicit
encoding over the default implicit transfer syntax.  If \b dcmqrscp is running
on big-endian hardware it will prefer BigEndianExplicitTransferSyntax to
LittleEndianExplicitTransferSyntax (and vice versa).

The \b dcmqrscp application does not support extended negotiation.

\subsection configuration Configuration

The \b dcmqrscp program uses the same configuration file as the \b ti program.
See the documentation on configuration for more information.

\subsection access_control Access Control

When compiled on Unix platforms with TCP wrapper support, host-based access
control can be enabled with the \e --access-control command line option.  In
this case the access control rules defined in the system's host access control
tables for \b dcmqrscp are enforced.  The default locations of the host access
control tables are <em>/etc/hosts.allow</em> and <em>/etc/hosts.deny</em>.
Further details are described in <b>hosts_access</b>(5).

\section command_line COMMAND LINE

All command line tools use the following notation for parameters: square
brackets enclose optional values (0-1), three trailing dots indicate that
multiple values are allowed (1-n), a combination of both means 0 to n values.

Command line options are distinguished from parameters by a leading '+' or '-'
sign, respectively.  Usually, order and position of command line options are
arbitrary (i.e. they can appear anywhere).  However, if options are mutually
exclusive the rightmost appearance is used.  This behaviour conforms to the
standard evaluation rules of common Unix shells.

In addition, one or more command files can be specified using an '@' sign as a
prefix to the filename (e.g. <em>\@command.txt</em>).  Such a command argument
is replaced by the content of the corresponding text file (multiple
whitespaces are treated as a single separator) prior to any further
evaluation.  Please note that a command file cannot contain another command
file.  This simple but effective approach allows to summarize common
combinations of options/parameters and avoids longish and confusing command
lines (an example is provided in file <em>share/data/dumppat.txt</em>).

\section environment ENVIRONMENT

The \b dcmqrscp utility will attempt to load DICOM data dictionaries specified
in the \e DCMDICTPATH environment variable.  By default, i.e. if the
\e DCMDICTPATH environment variable is not set, the file
<em>\<PREFIX\>/lib/dicom.dic</em> will be loaded unless the dictionary is built
into the application (default for Windows).

The default behaviour should be preferred and the \e DCMDICTPATH environment
variable only used when alternative data dictionaries are required.  The
\e DCMDICTPATH environment variable has the same format as the Unix shell
\e PATH variable in that a colon (":") separates entries.  The data dictionary
code will attempt to load each file specified in the \e DCMDICTPATH
environment variable.  It is an error if no data dictionary can be loaded.

\section files FILES

<em>share/doc/dcmqrcnf.txt</em> - configuration information
\n<em>share/doc/dcmqrset.txt</em> - setup information
\n<em>etc/dcmqrscp.cfg</em> - example configuration file

\section see_also SEE ALSO

<b>dcmqrti</b>(1)

\section copyright COPYRIGHT

Copyright (C) 1993-2005 by Kuratorium OFFIS e.V., Escherweg 2, 26121 Oldenburg,
Germany.

*/