using System;
using Db4objects.Db4o.Query;
using Db4objects.Db4o;

namespace Db4oUnit.Extensions.Tests
{
    public class CascadeOnUpdate : AbstractDb4oTestCase
    {
        public class Atom
        {
            public Atom child;

            public string name;

            public Atom()
            {
            }

            public Atom(Atom child)
            {
                this.child = child;
            }

            public Atom(string name)
            {
                this.name = name;
            }

            public Atom(Atom child, string name)
                : this(child)
            {
                this.name = name;
            }
        }
        // end Atom

        public object child;

        protected override void Configure(Db4objects.Db4o.Config.IConfiguration conf)
        {
            conf.ObjectClass(typeof(Atom)).CascadeOnUpdate(true);
        }
        // end Configure

        protected override void Store()
        {
            Atom atom = new Atom(new Atom(new Atom("StoredGrandChildChild"), "StoredChild"), "Parent");
            Db().Set(atom);
        }
        // end Store

        public virtual void Test()
        {
            IQuery q = NewQuery(typeof(Atom));
            q.Descend("name").Constrain("Parent");
            IObjectSet objectSet = q.Execute();
            Atom atom = null;
            while (objectSet.HasNext())
            {
                // update child objects
                atom = (Atom)objectSet.Next();
                ((Atom)atom.child).name = "Updated";
                ((Atom)atom.child).child.name = "NotUpdated";
                // store the parent object
                Db().Set(atom);
            }

            // commit and refresh to make sure that the changes are saved
            // and reference cash is refreshed
            Db().Commit();
            Db().Refresh(atom, Int32.MaxValue);


            q = NewQuery(typeof(Atom));
            q.Descend("name").Constrain("Parent");
            objectSet = q.Execute();
            while (objectSet.HasNext())
            {
                atom = (Atom)objectSet.Next();
                // check if the child objects were updated
                Atom child = (Atom)atom.child;
                Assert.AreEqual("Updated", child.name);
                Assert.AreNotEqual("Updated", child.child.name);
            }
        }
        // end Test
    }
}

