/* Copyright (C) 2007 db4objects Inc. http://www.db4o.com */
using System;
using System.IO;

using Db4objects.Db4o;


namespace Db4objects.Db4odoc.SystemInfo
{

    class SystemInfoExample
    {

        private const string Db4oFileName = "reference.db4o";

        private const string LogFileName = "db4o.log";

        private const long MaxDbSize = 20000000;

        private const long MaxFsSize = 2000000;

        private static IObjectContainer _container = null;

        private static TextWriter _logWriter = null;

        public static void Main(string[] args)
        {
            Initialize();
            TestSystemInfo();
            Close();
        }
        // end Main

        private static void TestSystemInfo()
        {
            long dbSize = _container.Ext().SystemInfo().TotalSize();
            long fsSize = _container.Ext().SystemInfo().FreespaceSize();
            if (dbSize > MaxDbSize)
            {
                System.Console.WriteLine("Attention! Database file size is over the limit. Maintenance required");
            }
            _logWriter.WriteLine("Total database size: " + dbSize);
            if (fsSize > MaxFsSize)
            {
                System.Console.WriteLine("Attention! Freespace size is over the limit. Maintenance required");
            }
            _logWriter.WriteLine("Database freespace size: " + fsSize);
            _logWriter.WriteLine("Database freespace entries: " + _container.Ext().SystemInfo().FreespaceEntryCount());
        }
        // end TestSystemInfo

        private static void Initialize()
        {
            _logWriter = new StreamWriter(LogFileName);
            try
            {
                _container = Db4oFactory.OpenFile(Db4oFileName);
            }
            catch (DatabaseFileLockedException ex)
            {
                System.Console.WriteLine(ex.Message);
            }
            _logWriter.WriteLine("Database check-up: " + DateTime.Now.ToString());
        }

        // end Initialize

        private static void Close()
        {
            if (_container != null)
            {
                _container.Close();
                _container = null;
            }
            _logWriter.WriteLine("Done.");
            _logWriter.Close(); ;
        }

        // end Close

    }

}
