/* Copyright (C) 2004 - 2007 db4objects Inc. http://www.db4o.com */
using System;
using System.IO;
using System.IO.IsolatedStorage;
using Db4objects.Db4o;
using Db4objects.Db4o.Config;

namespace Db4objects.Db4odoc.IsolatedStorage
{
    class IsolatedStorageExample
    {
        private const string Db4oFileName = "reference.db4o";

        public static void Main(string[] args)
        {
            TestStore();
            TestRetrieve();
            TestDelete();
            TestRetrieve();
        }
        // end Main

        private static void TestDelete()
        {
            IsolatedStorageFile isf = IsolatedStorageFile.GetUserStoreForAssembly();
            isf.DeleteFile(Db4oFileName);
        }
        // end TestDelete

        private static void TestStore()
        {
            IObjectContainer db = Db4oFactory.OpenFile(Configure(), Db4oFileName);
            try
            {
                Pilot pilot = new Pilot("Michael Schumacher");
                db.Set(pilot);
                System.Console.WriteLine("New pilot added");
            }
            finally
            {
                db.Close();
            }
        }
        // end TestStore

        private static IConfiguration Configure()
        {
            IConfiguration configuration = Db4oFactory.NewConfiguration();
            configuration.MessageLevel(1);
            configuration.Io(new IsolatedStorageFileAdapter());
            return configuration;
        }
        // end Configure

        private static void TestRetrieve()
        {
            IObjectContainer db = Db4oFactory.OpenFile(Configure(), Db4oFileName);
            try
            {
                IObjectSet result = db.Get(typeof(Pilot));
                ListResult(result);
            }
            finally
            {
                db.Close();
            }
        }
        // end TestRetrieve

        private static void ListResult(IObjectSet result)
        {
            Console.WriteLine(result.Count);
            foreach (object item in result)
            {
                Console.WriteLine(item);
            }
        }
        // end ListResult
    }
}
