/***************************************************************************
 *   Copyright (C) 2005 by Adam Treat                                      *
 *   treat@kde.org                                                         *
 *                                                                         *
 *   Copyright (C) 2004 by Scott Wheeler                                   *
 *   wheeler@kde.org                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef VIEWMODE_H
#define VIEWMODE_H

#include <qdict.h>

#include "datatablebox.h"

class QString;
class QPainter;
class QColorGroup;
class SearchDataTable;

class ViewMode : public QObject
{
    Q_OBJECT

public:
    ViewMode( DataTableBox *b );
    virtual ~ViewMode();

    virtual QString name() const
    {
        return i18n( "Default" );
    }
    virtual void setShown( bool shown );

    virtual void paintCell( DataTableBox::Item *item,
                            QPainter *painter,
                            const QColorGroup &colorGroup,
                            int column, int width, int align );

    virtual bool eventFilter( QObject *watched, QEvent *e );

    virtual void setupItem( DataTableBox::Item *item ) const;

    void queueRefresh()
    {
        m_needsRefresh = true;
    }
    bool needsRefresh()
    {
        return m_needsRefresh;
    }
    void setNeedsRefresh( bool refresh )
    {
        m_needsRefresh = refresh;
    }

protected:
    DataTableBox *dataTableBox() const
    {
        return m_dataTableBox;
    }
    bool visible() const
    {
        return m_visible;
    }
    void setVisible( bool v )
    {
        m_visible = v;
    }
    void updateIcons( int size );
    virtual void updateHeights();
    static void paintDropIndicator( QPainter *painter, int width, int height );

    static QStringList lines( const DataTableBox::Item *item, const QFontMetrics &fm, int width );

    DataTableBox *m_dataTableBox;
    bool m_visible;
    bool m_needsRefresh;
    QMap<DataTableBox::Item *, QStringList> m_lines;
    static const int border = 4;
};

class CompactViewMode : public ViewMode
{
public:
    CompactViewMode( DataTableBox *b );
    virtual ~CompactViewMode();

    virtual QString name() const
    {
        return i18n( "Compact" );
    }
    virtual void setShown( bool shown );

    virtual void paintCell( DataTableBox::Item *item,
                            QPainter *painter,
                            const QColorGroup &colorGroup,
                            int column, int width, int align );

    virtual void setupItem( DataTableBox::Item *item ) const;

protected:
    virtual void updateHeights();
};

class TreeViewItemDataTable;

class TreeViewMode : public CompactViewMode
{
    Q_OBJECT

public:
    TreeViewMode( DataTableBox *l );
    virtual ~TreeViewMode();

    virtual QString name() const
    {
        return i18n( "Tree" );
    }
    virtual void setShown( bool shown );
};

#endif
