/***************************************************************************
*   Copyright (C) 2005 by Adam Treat                                      *
*   treat@kde.org                                                         *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
***************************************************************************/

/***************************************************************************
*   This file adapted from libkdepim ktimeedit.h                          *
*                                                                         *
*   Copyright (c) 1999 Preston Brown, Ian Dawes                           *
*                                                                         *
***************************************************************************/

#ifndef TIMEEDIT_H
#define TIMEEDIT_H

#include <qevent.h>
#include <qkeycode.h>
#include <qstring.h>
#include <qdatetime.h>

#include "datatableeditorfactory.h"

class TimeEdit : public DataComboBox
{
    Q_OBJECT
    Q_PROPERTY( QTime time READ getTime WRITE setTime )
public:
    TimeEdit( DataField* field, DataTable *dataTable,
              QWidget *parent = 0, QTime qt = QTime( 12, 0 ),
              const char *name = 0 );
    virtual ~TimeEdit();

    bool hasTime() const;
    QTime getTime() const;
    bool inputIsValid() const;

signals:
    void timeChanged( const QTime &newt );

public slots:
    void setTime( QTime qt );

protected slots:
    void active( int );
    void changedText();

protected:
    virtual void keyPressEvent( QKeyEvent *qke );
    void addTime( QTime qt );
    void subTime( QTime qt );
    void updateText();

private:
    QTime mTime;
};

#endif
