/***************************************************************************
*   Copyright (C) 2005 by Adam Treat                                      *
*   treat@kde.org                                                         *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
***************************************************************************/

#ifndef KCOMBOTABLE_H
#define KCOMBOTABLE_H

#include <kcombobox.h>

class QStringList;
class KTableEdit;
class KCompletionTable;

class KComboTable : public KComboBox
{
    Q_OBJECT
public:
    KComboTable( QWidget *parent = 0, const char *name = 0 );
    ~KComboTable();

    void clearAll();
    QValueList<int> columnWidths() const;
    void setColumnWidths( QValueList<int> &colWidths );
    void insertRow( QStringList &list, bool calculateWidths = true );

public slots:
    void slotMakeCompletion( const QString &txt );

private:
    KTableEdit *m_tableEdit;
    KCompletionTable *m_tableBox;
    KCompletionTable *m_completionTable;
};

#endif
