/***************************************************************************
 *   Copyright (C) 2005 by Adam Treat                                      *
 *   treat@kde.org                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DATAREPORT_H
#define DATAREPORT_H

#include <qhbox.h>

#include <kapplication.h>
#include <kparts/mainwindow.h>
#include <kparts/browserextension.h>

class Project;
class DataTable;

class DataReport : public QHBox
{
    Q_OBJECT
public:
    DataReport( Project *project );
    DataReport( Project *project, DataTable* parent );

    virtual ~DataReport();

    void setAsActiveReport( bool active );
    void initialize();
    bool isInitialized();

    DataTable *parent() const;
    KParts::ReadOnlyPart *kugarPart() const;

    int numRows() const;

    virtual QString name() const;
    void setName( const QString &n );

    QString iconName() const;
    void setIconName( const QString &n );

    QString templateURL() const;
    void setTemplateURL( const QString &url );

    QString dataSearch() const;
    void setDataSearch( const QString &dataSearch );

    void addTable( const QString &table );
    void clearTables();
    QStringList tables() const;

    QStringList sort() const;
    void setSort( const QStringList &sort );

    bool needsRefresh();

public slots:
    void refreshReport();
    void queueRefresh();

signals:
    void signalNameChanged( const QString &name );
    void reportRefreshed();

private:
    void setup();
    QMap<QString, int> readTemplateFields() const;

private:
    DataTable *m_parent;
    Project *m_project;
    KParts::ReadOnlyPart *m_part;
    KParts::BrowserExtension *m_browser;

    int m_numRows;
    QString m_dataReportName;
    QString m_dataReportIconName;
    QString m_templateURL;
    QString m_dataSearch;
    QStringList m_tables;
    QStringList m_sort;
    bool m_needsRefresh;
    bool m_isInitialized;
};

#endif
