/***************************************************************************
 *   Copyright (C) 2005 by Adam Treat                                      *
 *   treat@kde.org                                                         *
 *                                                                         *
 *   Copyright (C) 2004 by Scott Wheeler                                   *
 *   wheeler@kde.org                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "asciivalidator.h"

#include <qstring.h>

AsciiValidator::AsciiValidator( QObject * parent, const char *name )
        : QValidator( parent, name ), functionName( false )
{}

AsciiValidator::AsciiValidator( bool funcName, QObject * parent, const char *name )
        : QValidator( parent, name ), functionName( funcName )
{}

AsciiValidator::AsciiValidator( const QString &allow, QObject * parent, const char *name )
        : QValidator( parent, name ), functionName( false ), allowedChars( allow )
{}

AsciiValidator::~AsciiValidator()
{}

QValidator::State AsciiValidator::validate( QString &s, int & ) const
{
    bool inParen = false;
    bool outParen = false;
    if ( !s.isEmpty() && s[ 0 ].row() == 0 && s[ 0 ].cell() >= '0' && s[ 0 ].cell() <= '9' )
        s[ 0 ] = '_';
    for ( int i = 0, j = 0; i < ( int ) s.length(); i++ )
    {
        uchar r = s[ i ].row();
        uchar c = s[ i ].cell();

        if ( outParen )
        { // check if we have 'const' or 'volatile'
            static const QString con = " const";
            static const QString vol = " volatile";
            QString mid = s.mid( j );
            if ( !( con.startsWith( mid ) || vol.startsWith( mid ) ) )
                return QValidator::Invalid;
        }

        if ( inParen && c != ')' )
            continue;

        if ( r == 0 && ( ( c >= '0' && c <= '9' ) ||
                         ( c >= 'a' && c <= 'z' ) ||
                         ( c >= 'A' && c <= 'Z' ) ) )
            continue;

        if ( functionName )
        {
            if ( c == '(' )
            {
                inParen = true;
                continue;
            }
            if ( c == ')' )
            {
                outParen = true;
                j = i + 1;
                continue;
            }
        }

        if ( allowedChars.find( s[ i ] ) != -1 )
            continue;

        s[ i ] = '_';
    }
    return QValidator::Acceptable;
}

#include "asciivalidator.moc"
