/* Copyright 2008 Simon Richter <Simon.Richter@hogyros.de>
 *
 * Released under the GNU General Public Licence version 3.
 */

#ifndef dammit_build_project_hpp_
#define dammit_build_project_hpp_ 1

#include "project.hpp"

#include "platform.hpp"

#include <list>

namespace dammit {

class build_project :
	public project
{
public:
	build_project(name const &, path const &);
	virtual ~build_project(void) throw() { }

	enum type
	{
		program = 0,
		library = 1,
		//com_interface = 0x100,
		//com_component = 0x101,
		//linux_driver = 0x1000,
		//windows_driver = 0x2000
	};

	type project_type;

	typedef std::list<path> input_file_list;
	typedef input_file_list::iterator input_file_iterator;
	
	input_file_list input_files;

	typedef std::list<std::string> library_list;
	typedef library_list::iterator library_iterator;

	library_list libraries;

	typedef std::list<platform> platform_list;
	typedef platform_list::iterator platform_iterator;

	platform_list platforms;
};

template<typename CharT_, typename Traits_>
std::basic_ostream<CharT_, Traits_> &operator<<(
		std::basic_ostream<CharT_, Traits_> &stream,
		build_project::type type)
{
	switch(type)
	{
	case build_project::program:
		stream << "program";
		break;
	case build_project::library:
		stream << "library";
		break;
	}
	return stream;
}

}

#endif
