/* Copyright 2008 Simon Richter <Simon.Richter@hogyros.de>
 *
 * Released under the GNU General Public Licence version 3.
 */

#ifndef dammit_parallel_node_hpp_
#define dammit_parallel_node_hpp_ 1

#include "node.hpp"

#include "intrusive_ptr_list.hpp"

namespace dammit {

/** The children of this node have no dependency relationship at all and can
 * safely be parallelized.
 */
class parallel_node :
	public node
{
public:
	virtual ~parallel_node(void) throw() { }

	virtual intrusive_ptr<node> apply(visitor &);
	virtual void apply(const_visitor &) const;

	typedef intrusive_ptr_list<node> node_list;
	typedef node_list::iterator node_iterator;
	typedef node_list::const_iterator node_const_iterator;

	node_list nodes;
};

}

#endif
