/* Copyright 2008 Simon Richter <Simon.Richter@hogyros.de>
 *
 * Released under the GNU General Public Licence version 3.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "depth_first_adapter.hpp"

#include "parallel_node.hpp"
#include "project_node.hpp"
#include "configuration_node.hpp"
#include "input_node.hpp"
#include "temporary_node.hpp"
#include "output_node.hpp"
#include "tool_node.hpp"
#include "environment_node.hpp"
#include "action_node.hpp"

#include "exceptions.hpp"

namespace dammit {

intrusive_ptr<node> depth_first_adapter::visit(parallel_node &n)
{
	enter(n);
	for(parallel_node::node_iterator i = n.nodes.begin();
			i != n.nodes.end();)
	{
		*i = (**i).apply(*this);
		if(*i)
			++i;
		else
			i = n.nodes.erase(i);
	}
	return leave(n);
}

void depth_first_adapter::enter(parallel_node &)
{
	return;
}

intrusive_ptr<node> depth_first_adapter::leave(parallel_node &n)
{
	return &n;
}

intrusive_ptr<node> depth_first_adapter::visit(project_node &n)
{
	enter(n);
	for(project_node::node_iterator i = n.nodes.begin();
			i != n.nodes.end();)
	{
		*i = (**i).apply(*this);
		if(*i)
			++i;
		else
			i = n.nodes.erase(i);
	}
	return leave(n);
}

void depth_first_adapter::enter(project_node &)
{
	return;
}

intrusive_ptr<node> depth_first_adapter::leave(project_node &n)
{
	return &n;
}

intrusive_ptr<node> depth_first_adapter::visit(configuration_node &n)
{
	enter(n);
	for(configuration_node::node_iterator i = n.nodes.begin();
			i != n.nodes.end();)
	{
		*i = (**i).apply(*this);
		if(*i)
			++i;
		else
			i = n.nodes.erase(i);
	}
	return leave(n);
}

void depth_first_adapter::enter(configuration_node &)
{
	return;
}

intrusive_ptr<node> depth_first_adapter::leave(configuration_node &n)
{
	return &n;
}

intrusive_ptr<node> depth_first_adapter::visit(input_node &n)
{
	enter(n);
	return leave(n);
}

void depth_first_adapter::enter(input_node &)
{
	return;
}

intrusive_ptr<node> depth_first_adapter::leave(input_node &n)
{
	return &n;
}

intrusive_ptr<node> depth_first_adapter::visit(temporary_node &n)
{
	enter(n);
	n.action = n.action->apply(*this);
	return leave(n);
}

void depth_first_adapter::enter(temporary_node &)
{
	return;
}

intrusive_ptr<node> depth_first_adapter::leave(temporary_node &n)
{
	return &n;
}

intrusive_ptr<node> depth_first_adapter::visit(output_node &n)
{
	enter(n);
	for(output_node::input_iterator i = n.inputs.begin();
			i != n.inputs.end();)
	{
		if(*i = (**i).apply(*this))
			++i;
		else
			i = n.inputs.erase(i);
	}
	return leave(n);
}

void depth_first_adapter::enter(output_node &)
{
	return;
}

intrusive_ptr<node> depth_first_adapter::leave(output_node &n)
{
	return &n;
}

intrusive_ptr<node> depth_first_adapter::visit(tool_node &n)
{
	enter(n);
	if(n.tool_project != n.tool_project->apply(*this))
		throw invalid_tree_state("attempted to replace a project");
	return leave(n);
}

void depth_first_adapter::enter(tool_node &)
{
	return;
}

intrusive_ptr<node> depth_first_adapter::leave(tool_node &n)
{
	return &n;
}

intrusive_ptr<node> depth_first_adapter::visit(environment_node &n)
{
	enter(n);
	return leave(n);
}

void depth_first_adapter::enter(environment_node &)
{
	return;
}

intrusive_ptr<node> depth_first_adapter::leave(environment_node &n)
{
	return &n;
}

intrusive_ptr<node> depth_first_adapter::visit(action_node &n)
{
	enter(n);
	for(action_node::input_iterator i = n.inputs.begin();
			i != n.inputs.end();)
	{
		*i = (**i).apply(*this);
		if(*i)
			++i;
		else
			i = n.inputs.erase(i);
	}
	return leave(n);
}

void depth_first_adapter::enter(action_node &)
{
	return;
}

intrusive_ptr<node> depth_first_adapter::leave(action_node &n)
{
	return &n;
}

}
