/* Copyright 2008 Simon Richter <Simon.Richter@hogyros.de>
 *
 * Released under the GNU General Public Licence version 3.
 */

#ifndef dammit_apply_configurations_hpp_
#define dammit_apply_configurations_hpp_ 1

#include "visitor.hpp"

namespace dammit {

class apply_configurations :
	public visitor
{
public:
	virtual ~apply_configurations(void) throw() { }

	virtual intrusive_ptr<node> visit(parallel_node &);
	virtual intrusive_ptr<node> visit(project_node &);
	virtual intrusive_ptr<node> visit(configuration_node &);
	virtual intrusive_ptr<node> visit(input_node &);
	virtual intrusive_ptr<node> visit(temporary_node &);
	virtual intrusive_ptr<node> visit(output_node &);
	virtual intrusive_ptr<node> visit(tool_node &);
	virtual intrusive_ptr<node> visit(environment_node &);
	virtual intrusive_ptr<node> visit(action_node &);

private:
	intrusive_ptr<configuration_node> current_config;
};

}

#endif
